/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import azkaban.utils.FileIOUtils;
import azkaban.utils.Pair;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileIOUtils {
    public static String getSourcePathFromClass(Class<?> containedClass) {
        File file = new File(containedClass.getProtectionDomain().getCodeSource().getLocation().getPath());
        if (!file.isDirectory() && file.getName().endsWith(".class")) {
            String name = containedClass.getName();
            StringTokenizer tokenizer = new StringTokenizer(name, ".");
            while (tokenizer.hasMoreTokens()) {
                tokenizer.nextElement();
                file = file.getParentFile();
            }
            return file.getPath();
        }
        return containedClass.getProtectionDomain().getCodeSource().getLocation().getPath();
    }

    public static void createDeepSymlink(File sourceDir, File destDir) throws IOException {
        if (!sourceDir.exists()) {
            throw new IOException("Source directory " + sourceDir.getPath() + " doesn't exist");
        }
        if (!destDir.exists()) {
            throw new IOException("Destination directory " + destDir.getPath() + " doesn't exist");
        }
        if (sourceDir.isFile() && destDir.isFile()) {
            throw new IOException("Source or Destination is not a directory.");
        }
        HashSet paths = new HashSet();
        FileIOUtils.createDirsFindFiles((File)sourceDir, (File)sourceDir, (File)destDir, paths);
        StringBuffer buffer = new StringBuffer();
        for (String path : paths) {
            File sourceLink = new File(sourceDir, path);
            path = "." + path;
            buffer.append("ln -s ").append(sourceLink.getAbsolutePath()).append("/*").append(" ").append(path).append(";");
        }
        String command = buffer.toString();
        ProcessBuilder builder = new ProcessBuilder(new String[0]).command("sh", "-c", command);
        builder.directory(destDir);
        Process process = builder.start();
        try {
            NullLogger errorLogger = new NullLogger(process.getErrorStream());
            NullLogger inputLogger = new NullLogger(process.getInputStream());
            errorLogger.start();
            inputLogger.start();
            try {
                if (process.waitFor() < 0) {
                    String errorMessage = errorLogger.getLastMessages();
                    if (errorMessage.isEmpty()) {
                        errorMessage = inputLogger.getLastMessages();
                    }
                    throw new IOException(errorMessage);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)process.getInputStream());
            IOUtils.closeQuietly((OutputStream)process.getOutputStream());
            IOUtils.closeQuietly((InputStream)process.getErrorStream());
        }
    }

    private static void createDirsFindFiles(File baseDir, File sourceDir, File destDir, Set<String> paths) {
        File[] srcList = sourceDir.listFiles();
        String path = FileIOUtils.getRelativePath((File)baseDir, (File)sourceDir);
        paths.add(path);
        File[] fileArray = srcList;
        int n = srcList.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                File newDestDir = new File(destDir, file.getName());
                newDestDir.mkdirs();
                FileIOUtils.createDirsFindFiles((File)baseDir, (File)file, (File)newDestDir, paths);
            }
            ++n2;
        }
    }

    private static String getRelativePath(File basePath, File sourceDir) {
        return sourceDir.getPath().substring(basePath.getPath().length());
    }

    public static Pair<Integer, Integer> readUtf8File(File file, int offset, int length, OutputStream stream) throws IOException {
        byte[] buffer = new byte[length];
        FileInputStream fileStream = new FileInputStream(file);
        long skipped = fileStream.skip(offset);
        if (skipped < (long)offset) {
            fileStream.close();
            return new Pair((Object)0, (Object)0);
        }
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(fileStream);
            inputStream.read(buffer);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        Pair utf8Range = FileIOUtils.getUtf8Range((byte[])buffer, (int)0, (int)length);
        stream.write(buffer, (Integer)utf8Range.getFirst(), (Integer)utf8Range.getSecond());
        return new Pair((Object)(offset + (Integer)utf8Range.getFirst()), (Object)((Integer)utf8Range.getSecond()));
    }

    public static LogData readUtf8File(File file, int fileOffset, int length) throws IOException {
        byte[] buffer = new byte[length];
        FileInputStream fileStream = new FileInputStream(file);
        long skipped = fileStream.skip(fileOffset);
        if (skipped < (long)fileOffset) {
            fileStream.close();
            return new LogData(fileOffset, 0, "");
        }
        BufferedInputStream inputStream = null;
        int read = 0;
        try {
            inputStream = new BufferedInputStream(fileStream);
            read = inputStream.read(buffer);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        if (read <= 0) {
            return new LogData(fileOffset, 0, "");
        }
        Pair utf8Range = FileIOUtils.getUtf8Range((byte[])buffer, (int)0, (int)read);
        String outputString = new String(buffer, (int)((Integer)utf8Range.getFirst()), (int)((Integer)utf8Range.getSecond()));
        return new LogData(fileOffset + (Integer)utf8Range.getFirst(), ((Integer)utf8Range.getSecond()).intValue(), outputString);
    }

    public static JobMetaData readUtf8MetaDataFile(File file, int fileOffset, int length) throws IOException {
        byte[] buffer = new byte[length];
        FileInputStream fileStream = new FileInputStream(file);
        long skipped = fileStream.skip(fileOffset);
        if (skipped < (long)fileOffset) {
            fileStream.close();
            return new JobMetaData(fileOffset, 0, "");
        }
        BufferedInputStream inputStream = null;
        int read = 0;
        try {
            inputStream = new BufferedInputStream(fileStream);
            read = inputStream.read(buffer);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        if (read <= 0) {
            return new JobMetaData(fileOffset, 0, "");
        }
        Pair utf8Range = FileIOUtils.getUtf8Range((byte[])buffer, (int)0, (int)read);
        String outputString = new String(buffer, (int)((Integer)utf8Range.getFirst()), (int)((Integer)utf8Range.getSecond()));
        return new JobMetaData(fileOffset + (Integer)utf8Range.getFirst(), ((Integer)utf8Range.getSecond()).intValue(), outputString);
    }

    public static Pair<Integer, Integer> getUtf8Range(byte[] buffer, int offset, int length) {
        int start = FileIOUtils.getUtf8ByteStart((byte[])buffer, (int)offset);
        int end = FileIOUtils.getUtf8ByteEnd((byte[])buffer, (int)(offset + length - 1));
        return new Pair((Object)start, (Object)(end - start + 1));
    }

    private static int getUtf8ByteStart(byte[] buffer, int offset) {
        int i = offset;
        while (i < offset + 6 && i < buffer.length) {
            byte b = buffer[i];
            if ((0x80 & b) == 0) {
                return i;
            }
            if ((0xC0 & b) == 192) {
                return i;
            }
            ++i;
        }
        return offset;
    }

    private static int getUtf8ByteEnd(byte[] buffer, int offset) {
        int i = offset;
        while (i > offset - 11 && i >= 0) {
            byte b = buffer[i];
            if ((0x80 & b) == 0) {
                return i;
            }
            if ((b & 0xE0) == 192) {
                if (offset - i >= 1) {
                    return i + 1;
                }
            } else if ((b & 0xF0) == 224) {
                if (offset - i >= 2) {
                    return i + 2;
                }
            } else if ((b & 0xF8) == 240) {
                if (offset - i >= 3) {
                    return i + 3;
                }
            } else if ((b & 0xFC) >= 248) {
                if (offset - i == 4) {
                    return i + 4;
                }
            } else if ((b & 0xFE) == 252 && offset - i >= 5) {
                return i + 5;
            }
            --i;
        }
        return offset;
    }
}

