/*
 * Decompiled with CFR 0.152.
 */
package azkaban.execapp.event;

import azkaban.execapp.FlowRunner;
import azkaban.execapp.JobRunner;
import azkaban.execapp.event.Event;
import azkaban.execapp.event.EventListener;
import azkaban.execapp.event.FlowWatcher;
import azkaban.executor.ExecutableNode;

public class LocalFlowWatcher
extends FlowWatcher {
    private LocalFlowWatcherListener watcherListener;
    private FlowRunner runner;
    private boolean isShutdown = false;

    public LocalFlowWatcher(FlowRunner runner) {
        super(runner.getExecutableFlow().getExecutionId());
        super.setFlow(runner.getExecutableFlow());
        this.watcherListener = new LocalFlowWatcherListener();
        this.runner = runner;
        runner.addListener(this.watcherListener);
    }

    @Override
    public void stopWatcher() {
        if (this.isShutdown) {
            return;
        }
        this.isShutdown = true;
        this.runner.removeListener(this.watcherListener);
        this.runner = null;
        super.failAllWatches();
    }

    public class LocalFlowWatcherListener
    implements EventListener {
        @Override
        public void handleEvent(Event event) {
            if (event.getRunner() instanceof JobRunner) {
                JobRunner runner = (JobRunner)event.getRunner();
                ExecutableNode node = runner.getNode();
                LocalFlowWatcher.this.handleJobFinished(node.getJobId(), node.getStatus());
            }
        }
    }
}

