/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.compress;

import voldemort.serialization.Compression;
import voldemort.store.compress.CompressionStrategy;
import voldemort.store.compress.GzipCompressionStrategy;
import voldemort.store.compress.LzfCompressionStrategy;
import voldemort.store.compress.NoopCompressionStrategy;
import voldemort.store.compress.SnappyCompressionStrategy;

public class CompressionStrategyFactory {
    public CompressionStrategy get(Compression compression) {
        if (compression == null) {
            return new NoopCompressionStrategy();
        }
        if (compression.getType().equals("gzip")) {
            return new GzipCompressionStrategy();
        }
        if (compression.getType().equals("lzf")) {
            return new LzfCompressionStrategy();
        }
        if (compression.getType().equals("snappy")) {
            return new SnappyCompressionStrategy();
        }
        throw new IllegalArgumentException("Unsupported compression algorithm: " + compression.getType());
    }
}

