/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import java.util.List;
import voldemort.client.protocol.RequestFormatType;
import voldemort.cluster.Cluster;
import voldemort.server.RequestRoutingType;
import voldemort.store.StoreDefinition;
import voldemort.store.socket.SocketStore;
import voldemort.store.socket.clientrequest.ClientRequestExecutorPool;
import voldemort.utils.ByteArray;

public class KeyLocationValidation {
    private final int nodeId;
    private final ByteArray keyList;
    private final Cluster cluster;
    private final StoreDefinition storeDef;

    public KeyLocationValidation(Cluster cluster, int nodeId, StoreDefinition storeDef, ByteArray keyList) {
        this.nodeId = nodeId;
        this.keyList = keyList;
        this.cluster = cluster;
        this.storeDef = storeDef;
    }

    public boolean validate(boolean positiveTest) {
        boolean retVal = false;
        ClientRequestExecutorPool socketStoreFactory = new ClientRequestExecutorPool(2, 10000, 100000, 32768);
        SocketStore socketStore = socketStoreFactory.create(this.storeDef.getName(), this.cluster.getNodeById(this.nodeId).getHost(), this.cluster.getNodeById(this.nodeId).getSocketPort(), RequestFormatType.PROTOCOL_BUFFERS, RequestRoutingType.IGNORE_CHECKS);
        List value = socketStore.get(this.keyList, null);
        if (!(positiveTest || value != null && value.size() != 0)) {
            retVal = true;
        } else if (value != null && value.size() != 0) {
            retVal = true;
        }
        socketStore.close();
        return retVal;
    }
}

