/*
 * Decompiled with CFR 0.152.
 */
package voldemort.routing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import voldemort.cluster.Node;
import voldemort.routing.ConsistentRoutingStrategy;
import voldemort.utils.FnvHashFunction;
import voldemort.utils.HashFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZoneRoutingStrategy
extends ConsistentRoutingStrategy {
    private HashMap<Integer, Integer> zoneReplicationFactor;

    public ZoneRoutingStrategy(Collection<Node> nodes, HashMap<Integer, Integer> zoneReplicationFactor, int numReplicas) {
        this(new FnvHashFunction(), nodes, zoneReplicationFactor, numReplicas);
    }

    public ZoneRoutingStrategy(HashFunction hash, Collection<Node> nodes, HashMap<Integer, Integer> zoneReplicationFactor, int numReplicas) {
        super(hash, nodes, numReplicas);
        this.zoneReplicationFactor = zoneReplicationFactor;
    }

    @Override
    public List<Integer> getReplicatingPartitionList(int index) {
        ArrayList<Node> preferenceNodesList = new ArrayList<Node>(this.getNumReplicas());
        ArrayList<Integer> replicationPartitionsList = new ArrayList<Integer>(this.getNumReplicas());
        HashMap<Integer, Integer> requiredRepFactor = new HashMap<Integer, Integer>();
        requiredRepFactor.putAll(this.zoneReplicationFactor);
        int sum = 0;
        for (Integer zoneRepFactor : requiredRepFactor.values()) {
            sum += zoneRepFactor.intValue();
        }
        if (sum != this.getNumReplicas()) {
            throw new IllegalArgumentException("Number of zone replicas is not equal to the total replication factor");
        }
        if (this.getPartitionToNode().length == 0) {
            return new ArrayList<Integer>(0);
        }
        for (int i = 0; i < this.getPartitionToNode().length; ++i) {
            Node currentNode = this.getNodeByPartition(index);
            if (!preferenceNodesList.contains(currentNode)) {
                preferenceNodesList.add(currentNode);
                if (this.checkZoneRequirement(requiredRepFactor, currentNode.getZoneId())) {
                    replicationPartitionsList.add(index);
                }
            }
            if (replicationPartitionsList.size() >= this.getNumReplicas()) {
                return replicationPartitionsList;
            }
            index = (index + 1) % this.getPartitionToNode().length;
        }
        return replicationPartitionsList;
    }

    private boolean checkZoneRequirement(HashMap<Integer, Integer> requiredRepFactor, int zoneId) {
        if (requiredRepFactor.containsKey(zoneId)) {
            if (requiredRepFactor.get(zoneId) == 0) {
                return false;
            }
            requiredRepFactor.put(zoneId, requiredRepFactor.get(zoneId) - 1);
            return true;
        }
        return false;
    }

    @Override
    public String getType() {
        return "zone-routing";
    }
}

