/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.optimizer;

import java.util.Collection;
import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanWalker;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.optimizer.FieldSchemaResetter;
import org.apache.pig.newplan.logical.relational.LOCogroup;
import org.apache.pig.newplan.logical.relational.LOCross;
import org.apache.pig.newplan.logical.relational.LODistinct;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LOSplit;
import org.apache.pig.newplan.logical.relational.LOSplitOutput;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LOStream;
import org.apache.pig.newplan.logical.relational.LOUnion;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;

public class SchemaResetter
extends LogicalRelationalNodesVisitor {
    public SchemaResetter(OperatorPlan plan) throws FrontendException {
        super(plan, new DependencyOrderWalker(plan));
    }

    public void visit(LOLoad load) throws FrontendException {
        load.resetSchema();
        load.getSchema();
    }

    public void visit(LOFilter filter) throws FrontendException {
        filter.resetSchema();
        FieldSchemaResetter fsResetter = new FieldSchemaResetter(filter.getFilterPlan());
        fsResetter.visit();
        filter.getSchema();
    }

    public void visit(LOStore store) throws FrontendException {
        store.resetSchema();
        store.getSchema();
    }

    public void visit(LOJoin join) throws FrontendException {
        join.resetSchema();
        Collection<LogicalExpressionPlan> joinPlans = join.getExpressionPlanValues();
        for (LogicalExpressionPlan joinPlan : joinPlans) {
            FieldSchemaResetter fsResetter = new FieldSchemaResetter(joinPlan);
            fsResetter.visit();
        }
        join.getSchema();
    }

    public void visit(LOForEach foreach) throws FrontendException {
        foreach.resetSchema();
        LogicalPlan innerPlan = foreach.getInnerPlan();
        PlanWalker newWalker = this.currentWalker.spawnChildWalker(innerPlan);
        this.pushWalker(newWalker);
        this.currentWalker.walk(this);
        this.popWalker();
        foreach.getSchema();
    }

    public void visit(LOGenerate gen) throws FrontendException {
        gen.resetSchema();
        List<LogicalExpressionPlan> genPlans = gen.getOutputPlans();
        for (LogicalExpressionPlan genPlan : genPlans) {
            FieldSchemaResetter fsResetter = new FieldSchemaResetter(genPlan);
            fsResetter.visit();
        }
        gen.getSchema();
    }

    public void visit(LOInnerLoad load) throws FrontendException {
        load.resetSchema();
        load.getProjection().resetFieldSchema();
        load.getSchema();
    }

    public void visit(LOCogroup loCogroup) throws FrontendException {
        loCogroup.resetSchema();
        MultiMap<Integer, LogicalExpressionPlan> expPlans = loCogroup.getExpressionPlans();
        for (LogicalExpressionPlan expPlan : expPlans.values()) {
            FieldSchemaResetter fsResetter = new FieldSchemaResetter(expPlan);
            fsResetter.visit();
        }
        loCogroup.getSchema();
    }

    public void visit(LOSplit loSplit) throws FrontendException {
        loSplit.resetSchema();
        loSplit.getSchema();
    }

    public void visit(LOSplitOutput loSplitOutput) throws FrontendException {
        loSplitOutput.resetSchema();
        FieldSchemaResetter fsResetter = new FieldSchemaResetter(loSplitOutput.getFilterPlan());
        fsResetter.visit();
        loSplitOutput.getSchema();
    }

    public void visit(LOUnion loUnion) throws FrontendException {
        loUnion.resetSchema();
        loUnion.getSchema();
    }

    public void visit(LOSort loSort) throws FrontendException {
        loSort.resetSchema();
        List<LogicalExpressionPlan> sortPlans = loSort.getSortColPlans();
        for (LogicalExpressionPlan sortPlan : sortPlans) {
            FieldSchemaResetter fsResetter = new FieldSchemaResetter(sortPlan);
            fsResetter.visit();
        }
        loSort.getSchema();
    }

    public void visit(LODistinct loDistinct) throws FrontendException {
        loDistinct.resetSchema();
        loDistinct.getSchema();
    }

    public void visit(LOLimit loLimit) throws FrontendException {
        loLimit.resetSchema();
        loLimit.getSchema();
    }

    public void visit(LOCross loCross) throws FrontendException {
        loCross.resetSchema();
        loCross.getSchema();
    }

    public void visit(LOStream loStream) throws FrontendException {
        loStream.resetSchema();
        loStream.getSchema();
    }
}

