/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import azkaban.flow.Edge;
import azkaban.flow.Flow;
import azkaban.flow.FlowProps;
import azkaban.flow.Node;
import azkaban.utils.DirectoryFlowLoader;
import azkaban.utils.Props;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DirectoryFlowLoader {
    private static final DirFilter DIR_FILTER = new DirFilter(null);
    private static final String PROPERTY_SUFFIX = ".properties";
    private static final String JOB_SUFFIX = ".job";
    private final Logger logger;
    private HashSet<String> rootNodes;
    private HashMap<String, Flow> flowMap;
    private HashMap<String, Node> nodeMap;
    private HashMap<String, Map<String, Edge>> nodeDependencies;
    private HashMap<String, Props> jobPropsMap;
    private HashMap<String, Set<String>> flowDependencies;
    private ArrayList<FlowProps> flowPropsList;
    private ArrayList<Props> propsList;
    private Set<String> errors;
    private Set<String> duplicateJobs;

    public DirectoryFlowLoader(Logger logger) {
        this.logger = logger;
    }

    public Map<String, Flow> getFlowMap() {
        return this.flowMap;
    }

    public Set<String> getErrors() {
        return this.errors;
    }

    public Map<String, Props> getJobProps() {
        return this.jobPropsMap;
    }

    public List<Props> getProps() {
        return this.propsList;
    }

    public void loadProjectFlow(File baseDirectory) {
        this.propsList = new ArrayList();
        this.flowPropsList = new ArrayList();
        this.jobPropsMap = new HashMap();
        this.nodeMap = new HashMap();
        this.flowMap = new HashMap();
        this.errors = new HashSet();
        this.duplicateJobs = new HashSet();
        this.nodeDependencies = new HashMap();
        this.rootNodes = new HashSet();
        this.flowDependencies = new HashMap();
        this.loadProjectFromDir(baseDirectory.getPath(), baseDirectory, null);
        this.resolveDependencies();
        this.buildFlowsFromDependencies();
        this.resolveEmbeddedFlows();
    }

    private void loadProjectFromDir(String base, File dir, Props parent) {
        File[] subDirs;
        File[] jobFiles;
        Object[] propertyFiles = dir.listFiles((FileFilter)new SuffixFilter(PROPERTY_SUFFIX));
        Arrays.sort(propertyFiles);
        Object[] objectArray = propertyFiles;
        int n = propertyFiles.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            String relative = this.getRelativeFilePath(base, ((File)file).getPath());
            try {
                parent = new Props(parent, (File)file);
                parent.setSource(relative);
                FlowProps flowProps = new FlowProps(parent);
                this.flowPropsList.add(flowProps);
            }
            catch (IOException e) {
                this.errors.add("Error loading properties " + ((File)file).getName() + ":" + e.getMessage());
            }
            this.logger.info((Object)("Adding " + relative));
            this.propsList.add(parent);
            ++n2;
        }
        File[] fileArray = jobFiles = dir.listFiles((FileFilter)new SuffixFilter(JOB_SUFFIX));
        int n3 = jobFiles.length;
        n = 0;
        while (n < n3) {
            File file = fileArray[n];
            String jobName = this.getNameWithoutExtension(file);
            try {
                if (!this.duplicateJobs.contains(jobName)) {
                    if (this.jobPropsMap.containsKey(jobName)) {
                        this.errors.add("Duplicate job names found '" + jobName + "'.");
                        this.duplicateJobs.add(jobName);
                        this.jobPropsMap.remove(jobName);
                        this.nodeMap.remove(jobName);
                    } else {
                        Props prop = new Props(parent, file);
                        String relative = this.getRelativeFilePath(base, file.getPath());
                        prop.setSource(relative);
                        Node node = new Node(jobName);
                        String type = prop.getString("type", null);
                        if (type == null) {
                            this.errors.add("Job doesn't have type set '" + jobName + "'.");
                        }
                        node.setType(type);
                        node.setJobSource(relative);
                        if (parent != null) {
                            node.setPropsSource(parent.getSource());
                        }
                        if (prop.getBoolean("root.node", false)) {
                            this.rootNodes.add(jobName);
                        }
                        this.jobPropsMap.put(jobName, prop);
                        this.nodeMap.put(jobName, node);
                    }
                }
            }
            catch (IOException e) {
                this.errors.add("Error loading job file " + file.getName() + ":" + e.getMessage());
            }
            ++n;
        }
        File[] fileArray2 = subDirs = dir.listFiles((FileFilter)DIR_FILTER);
        int n4 = subDirs.length;
        n3 = 0;
        while (n3 < n4) {
            File file = fileArray2[n3];
            this.loadProjectFromDir(base, file, parent);
            ++n3;
        }
    }

    private void resolveEmbeddedFlows() {
        for (String flowId : this.flowDependencies.keySet()) {
            HashSet visited = new HashSet();
            this.resolveEmbeddedFlow(flowId, visited);
        }
    }

    private void resolveEmbeddedFlow(String flowId, Set<String> visited) {
        Set embeddedFlow = (Set)this.flowDependencies.get(flowId);
        if (embeddedFlow == null) {
            return;
        }
        visited.add(flowId);
        for (String embeddedFlowId : embeddedFlow) {
            if (visited.contains(embeddedFlowId)) {
                this.errors.add("Embedded flow cycle found in " + flowId + "->" + embeddedFlowId);
                return;
            }
            if (!this.flowMap.containsKey(embeddedFlowId)) {
                this.errors.add("Flow " + flowId + " depends on " + embeddedFlowId + " but can't be found.");
                return;
            }
            this.resolveEmbeddedFlow(embeddedFlowId, visited);
        }
        visited.remove(flowId);
    }

    private void resolveDependencies() {
        for (Node node : this.nodeMap.values()) {
            HashMap<String, Edge> dependencies;
            Props props = (Props)this.jobPropsMap.get(node.getId());
            if (props == null) {
                this.logger.error((Object)"Job props not found!! For some reason.");
                continue;
            }
            List dependencyList = props.getStringList("dependencies", null);
            if (dependencyList == null || (dependencies = (HashMap<String, Edge>)this.nodeDependencies.get(node.getId())) != null) continue;
            dependencies = new HashMap<String, Edge>();
            for (String dependencyName : dependencyList) {
                String string = dependencyName = dependencyName == null ? null : dependencyName.trim();
                if (dependencyName == null || dependencyName.isEmpty()) continue;
                Edge edge = new Edge(dependencyName, node.getId());
                Node dependencyNode = (Node)this.nodeMap.get(dependencyName);
                if (dependencyNode == null) {
                    if (this.duplicateJobs.contains(dependencyName)) {
                        edge.setError("Ambiguous Dependency. Duplicates found.");
                        dependencies.put(dependencyName, edge);
                        this.errors.add(String.valueOf(node.getId()) + " has ambiguous dependency " + dependencyName);
                        continue;
                    }
                    edge.setError("Dependency not found.");
                    dependencies.put(dependencyName, edge);
                    this.errors.add(String.valueOf(node.getId()) + " cannot find dependency " + dependencyName);
                    continue;
                }
                if (dependencyNode == node) {
                    edge.setError("Self cycle found.");
                    dependencies.put(dependencyName, edge);
                    this.errors.add(String.valueOf(node.getId()) + " has a self cycle");
                    continue;
                }
                dependencies.put(dependencyName, edge);
            }
            if (dependencies.isEmpty()) continue;
            this.nodeDependencies.put(node.getId(), dependencies);
        }
    }

    private void buildFlowsFromDependencies() {
        HashSet<String> nonRootNodes = new HashSet<String>();
        for (Map edges : this.nodeDependencies.values()) {
            for (String sourceId : edges.keySet()) {
                nonRootNodes.add(sourceId);
            }
        }
        HashSet visitedNodes = new HashSet();
        for (Node base : this.nodeMap.values()) {
            if (!this.rootNodes.contains(base.getId()) && nonRootNodes.contains(base.getId())) continue;
            this.rootNodes.add(base.getId());
            Flow flow = new Flow(base.getId());
            Props jobProp = (Props)this.jobPropsMap.get(base.getId());
            List successEmailList = jobProp.getStringList("success.emails", Collections.EMPTY_LIST);
            HashSet<String> successEmail = new HashSet<String>();
            for (String email : successEmailList) {
                successEmail.add(email.toLowerCase());
            }
            List failureEmailList = jobProp.getStringList("failure.emails", Collections.EMPTY_LIST);
            HashSet<String> failureEmail = new HashSet<String>();
            for (String email : failureEmailList) {
                failureEmail.add(email.toLowerCase());
            }
            List notifyEmailList = jobProp.getStringList("notify.emails", Collections.EMPTY_LIST);
            for (String email : notifyEmailList) {
                email = email.toLowerCase();
                successEmail.add(email);
                failureEmail.add(email);
            }
            flow.addFailureEmails(failureEmail);
            flow.addSuccessEmails(successEmail);
            flow.addAllFlowProperties((Collection)this.flowPropsList);
            this.constructFlow(flow, base, visitedNodes);
            flow.initialize();
            this.flowMap.put(base.getId(), flow);
        }
    }

    private void constructFlow(Flow flow, Node node, Set<String> visited) {
        Map dependencies;
        visited.add(node.getId());
        flow.addNode(node);
        if ("flow".equals(node.getType())) {
            Props props = (Props)this.jobPropsMap.get(node.getId());
            String embeddedFlow = props.get((Object)"flow.name");
            HashSet<String> embeddedFlows = (HashSet<String>)this.flowDependencies.get(flow.getId());
            if (embeddedFlows == null) {
                embeddedFlows = new HashSet<String>();
                this.flowDependencies.put(flow.getId(), embeddedFlows);
            }
            node.setEmbeddedFlowId(embeddedFlow);
            embeddedFlows.add(embeddedFlow);
        }
        if ((dependencies = (Map)this.nodeDependencies.get(node.getId())) != null) {
            for (Edge edge : dependencies.values()) {
                if (edge.hasError()) {
                    flow.addEdge(edge);
                    continue;
                }
                if (visited.contains(edge.getSourceId())) {
                    edge = new Edge(edge.getSourceId(), node.getId());
                    edge.setError("Cyclical dependencies found.");
                    this.errors.add("Cyclical dependency found at " + edge.getId());
                    flow.addEdge(edge);
                    continue;
                }
                flow.addEdge(edge);
                Node sourceNode = (Node)this.nodeMap.get(edge.getSourceId());
                this.constructFlow(flow, sourceNode, visited);
            }
        }
        visited.remove(node.getId());
    }

    private String getNameWithoutExtension(File file) {
        String filename = file.getName();
        int index = filename.lastIndexOf(46);
        return index < 0 ? filename : filename.substring(0, index);
    }

    private String getRelativeFilePath(String basePath, String filePath) {
        return filePath.substring(basePath.length() + 1);
    }
}

