/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client.rebalance.task;

import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import voldemort.client.protocol.admin.AdminClient;
import voldemort.client.rebalance.RebalanceClientConfig;
import voldemort.client.rebalance.RebalancePartitionsInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RebalanceTask
implements Runnable {
    protected final int taskId;
    protected Exception exception;
    protected final RebalanceClientConfig config;
    protected final AdminClient adminClient;
    protected final Semaphore donorPermit;
    protected final AtomicBoolean isComplete;
    protected final List<RebalancePartitionsInfo> stealInfos;
    protected static final int INVALID_REBALANCE_ID = -1;

    public RebalanceTask(int taskId, List<RebalancePartitionsInfo> stealInfos, RebalanceClientConfig config, Semaphore donorPermit, AdminClient adminClient) {
        this.stealInfos = stealInfos;
        this.taskId = taskId;
        this.config = config;
        this.adminClient = adminClient;
        this.donorPermit = donorPermit;
        this.exception = null;
        this.isComplete = new AtomicBoolean(false);
    }

    public List<RebalancePartitionsInfo> getStealInfos() {
        return this.stealInfos;
    }

    public boolean isComplete() {
        return this.isComplete.get();
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public Exception getError() {
        return this.exception;
    }

    public String toString() {
        return "Rebalance task : " + this.getStealInfos();
    }
}

