/*
 * Decompiled with CFR 0.152.
 */
package voldemort.cluster.failuredetector;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import voldemort.client.ClientConfig;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.StoreVerifier;
import voldemort.cluster.failuredetector.ThresholdFailureDetector;
import voldemort.server.VoldemortConfig;
import voldemort.utils.SystemTime;
import voldemort.utils.Time;
import voldemort.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailureDetectorConfig {
    public static final String DEFAULT_IMPLEMENTATION_CLASS_NAME = ThresholdFailureDetector.class.getName();
    public static final long DEFAULT_BANNAGE_PERIOD = 30000L;
    public static final long DEFAULT_THRESHOLD_INTERVAL = 300000L;
    public static final int DEFAULT_THRESHOLD = 95;
    public static final int DEFAULT_THRESHOLD_COUNT_MINIMUM = 30;
    public static final long DEFAULT_ASYNC_RECOVERY_INTERVAL = 10000L;
    public static final List<String> DEFAULT_CATASTROPHIC_ERROR_TYPES = ImmutableList.of((Object)ConnectException.class.getName(), (Object)UnknownHostException.class.getName(), (Object)NoRouteToHostException.class.getName());
    public static final long DEFAULT_REQUEST_LENGTH_THRESHOLD = 5000L;
    protected String implementationClassName = DEFAULT_IMPLEMENTATION_CLASS_NAME;
    protected long bannagePeriod = 30000L;
    protected int threshold = 95;
    protected int thresholdCountMinimum = 30;
    protected long thresholdInterval = 300000L;
    protected long asyncRecoveryInterval = 10000L;
    protected List<String> catastrophicErrorTypes = DEFAULT_CATASTROPHIC_ERROR_TYPES;
    protected long requestLengthThreshold = 5000L;
    protected Collection<Node> nodes;
    protected StoreVerifier storeVerifier;
    protected Time time = SystemTime.INSTANCE;

    public FailureDetectorConfig() {
    }

    public FailureDetectorConfig(VoldemortConfig config) {
        this.setImplementationClassName(config.getFailureDetectorImplementation());
        this.setBannagePeriod(config.getFailureDetectorBannagePeriod());
        this.setThreshold(config.getFailureDetectorThreshold());
        this.setThresholdCountMinimum(config.getFailureDetectorThresholdCountMinimum());
        this.setThresholdInterval(config.getFailureDetectorThresholdInterval());
        this.setAsyncRecoveryInterval(config.getFailureDetectorAsyncRecoveryInterval());
        this.setCatastrophicErrorTypes(config.getFailureDetectorCatastrophicErrorTypes());
        this.setRequestLengthThreshold(config.getFailureDetectorRequestLengthThreshold());
    }

    public FailureDetectorConfig(ClientConfig config) {
        this.setImplementationClassName(config.getFailureDetectorImplementation());
        this.setBannagePeriod(config.getFailureDetectorBannagePeriod());
        this.setThreshold(config.getFailureDetectorThreshold());
        this.setThresholdCountMinimum(config.getFailureDetectorThresholdCountMinimum());
        this.setThresholdInterval(config.getFailureDetectorThresholdInterval());
        this.setAsyncRecoveryInterval(config.getFailureDetectorAsyncRecoveryInterval());
        this.setCatastrophicErrorTypes(config.getFailureDetectorCatastrophicErrorTypes());
        this.setRequestLengthThreshold(config.getFailureDetectorRequestLengthThreshold());
    }

    public String getImplementationClassName() {
        return this.implementationClassName;
    }

    public FailureDetectorConfig setImplementationClassName(String implementationClassName) {
        this.implementationClassName = Utils.notNull(implementationClassName);
        return this;
    }

    public long getBannagePeriod() {
        return this.bannagePeriod;
    }

    public FailureDetectorConfig setBannagePeriod(long bannagePeriod) {
        this.bannagePeriod = bannagePeriod;
        return this;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public FailureDetectorConfig setThreshold(int threshold) {
        if (threshold < 0 || threshold > 100) {
            throw new IllegalArgumentException("threshold must be in the range (0..100)");
        }
        this.threshold = threshold;
        return this;
    }

    public int getThresholdCountMinimum() {
        return this.thresholdCountMinimum;
    }

    public FailureDetectorConfig setThresholdCountMinimum(int thresholdCountMinimum) {
        if (thresholdCountMinimum < 0) {
            throw new IllegalArgumentException("thresholdCountMinimum must be greater than or equal to 0");
        }
        this.thresholdCountMinimum = thresholdCountMinimum;
        return this;
    }

    public long getThresholdInterval() {
        return this.thresholdInterval;
    }

    public FailureDetectorConfig setThresholdInterval(long thresholdInterval) {
        if (thresholdInterval <= 0L) {
            throw new IllegalArgumentException("thresholdInterval must be greater than 0");
        }
        this.thresholdInterval = thresholdInterval;
        return this;
    }

    public long getAsyncRecoveryInterval() {
        return this.asyncRecoveryInterval;
    }

    public FailureDetectorConfig setAsyncRecoveryInterval(long asyncRecoveryInterval) {
        if (asyncRecoveryInterval <= 0L) {
            throw new IllegalArgumentException("asyncRecoveryInterval must be greater than 0");
        }
        this.asyncRecoveryInterval = asyncRecoveryInterval;
        return this;
    }

    public List<String> getCatastrophicErrorTypes() {
        return this.catastrophicErrorTypes;
    }

    public FailureDetectorConfig setCatastrophicErrorTypes(List<String> catastrophicErrorTypes) {
        this.catastrophicErrorTypes = Utils.notNull(catastrophicErrorTypes);
        return this;
    }

    public long getRequestLengthThreshold() {
        return this.requestLengthThreshold;
    }

    public FailureDetectorConfig setRequestLengthThreshold(long requestLengthThreshold) {
        if (requestLengthThreshold <= 0L) {
            throw new IllegalArgumentException("requestLengthThreshold must be positive");
        }
        this.requestLengthThreshold = requestLengthThreshold;
        return this;
    }

    public synchronized Collection<Node> getNodes() {
        return ImmutableSet.copyOf(this.nodes);
    }

    public synchronized FailureDetectorConfig setNodes(Collection<Node> nodes) {
        Utils.notNull(nodes);
        this.nodes = new HashSet<Node>(nodes);
        return this;
    }

    public synchronized void addNode(Node node) {
        Utils.notNull(node);
        this.nodes.add(node);
    }

    public synchronized void removeNode(Node node) {
        Utils.notNull(node);
        this.nodes.remove(node);
    }

    public StoreVerifier getStoreVerifier() {
        return this.storeVerifier;
    }

    public FailureDetectorConfig setStoreVerifier(StoreVerifier storeVerifier) {
        this.storeVerifier = Utils.notNull(storeVerifier);
        return this;
    }

    public Time getTime() {
        return this.time;
    }

    public FailureDetectorConfig setTime(Time time) {
        this.time = Utils.notNull(time);
        return this;
    }
}

