/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.protocol.admin;

import java.util.LinkedHashMap;
import java.util.Map;
import voldemort.server.protocol.admin.AsyncOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncOperationCache
extends LinkedHashMap<Integer, AsyncOperation> {
    private final int maxSize;
    private static final long serialVersionUID = 1L;

    public AsyncOperationCache(int maxSize) {
        super(maxSize, 0.75f, false);
        this.maxSize = maxSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<Integer, AsyncOperation> entry) {
        AsyncOperation operation = entry.getValue();
        return this.size() > this.maxSize() && operation.getStatus().isComplete();
    }

    public int maxSize() {
        return this.maxSize;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AsyncOperationCache(maxSize = ");
        builder.append(this.maxSize());
        builder.append(", size = ");
        builder.append(this.size());
        builder.append("[");
        for (AsyncOperation operation : this.values()) {
            builder.append(operation.toString());
            builder.append(",\n");
        }
        builder.append("])");
        return builder.toString();
    }
}

