/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.bdb;

import com.google.common.collect.Maps;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.StatsConfig;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.annotations.jmx.JmxOperation;
import voldemort.server.VoldemortConfig;
import voldemort.store.StorageConfiguration;
import voldemort.store.StorageEngine;
import voldemort.store.StorageInitializationException;
import voldemort.store.StoreDefinition;
import voldemort.store.bdb.BdbRuntimeConfig;
import voldemort.store.bdb.BdbStorageEngine;
import voldemort.utils.ByteArray;
import voldemort.utils.JmxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BdbStorageConfiguration
implements StorageConfiguration {
    public static final String TYPE_NAME = "bdb";
    private static final String SHARED_ENV_KEY = "shared";
    private static Logger logger = Logger.getLogger(BdbStorageConfiguration.class);
    private final Object lock = new Object();
    private final Map<String, Environment> environments = Maps.newHashMap();
    private final EnvironmentConfig environmentConfig;
    private final DatabaseConfig databaseConfig;
    private final String bdbMasterDir;
    private final boolean useOneEnvPerStore;
    private final VoldemortConfig voldemortConfig;
    private long reservedCacheSize = 0L;
    private Set<Environment> unreservedStores;

    public BdbStorageConfiguration(VoldemortConfig config) {
        this.voldemortConfig = config;
        this.environmentConfig = new EnvironmentConfig();
        this.environmentConfig.setTransactional(true);
        if (config.isBdbWriteTransactionsEnabled() && config.isBdbFlushTransactionsEnabled()) {
            this.environmentConfig.setDurability(Durability.COMMIT_SYNC);
        } else if (config.isBdbWriteTransactionsEnabled() && !config.isBdbFlushTransactionsEnabled()) {
            this.environmentConfig.setDurability(Durability.COMMIT_WRITE_NO_SYNC);
        } else {
            this.environmentConfig.setDurability(Durability.COMMIT_NO_SYNC);
        }
        this.environmentConfig.setAllowCreate(true);
        this.environmentConfig.setConfigParam("je.log.fileMax", Long.toString(config.getBdbMaxLogFileSize()));
        this.environmentConfig.setConfigParam("je.checkpointer.bytesInterval", Long.toString(config.getBdbCheckpointBytes()));
        this.environmentConfig.setConfigParam("je.checkpointer.wakeupInterval", Long.toString(config.getBdbCheckpointMs() * 1000L));
        this.environmentConfig.setConfigParam("je.cleaner.minFileUtilization", Integer.toString(config.getBdbCleanerMinFileUtilization()));
        this.environmentConfig.setConfigParam("je.cleaner.minUtilization", Integer.toString(config.getBdbCleanerMinUtilization()));
        this.environmentConfig.setConfigParam("je.cleaner.threads", Integer.toString(config.getBdbCleanerThreads()));
        this.environmentConfig.setConfigParam("je.cleaner.lookAheadCacheSize", Integer.toString(config.getBdbCleanerLookAheadCacheSize()));
        this.environmentConfig.setConfigParam("je.lock.nLockTables", Integer.toString(config.getBdbLockNLockTables()));
        this.environmentConfig.setConfigParam("je.env.fairLatches", Boolean.toString(config.getBdbFairLatches()));
        this.environmentConfig.setConfigParam("je.checkpointer.highPriority", Boolean.toString(config.getBdbCheckpointerHighPriority()));
        this.environmentConfig.setConfigParam("je.cleaner.maxBatchFiles", Integer.toString(config.getBdbCleanerMaxBatchFiles()));
        this.environmentConfig.setConfigParam("je.log.faultReadSize", Integer.toString(config.getBdbLogFaultReadSize()));
        this.environmentConfig.setConfigParam("je.log.iteratorReadSize", Integer.toString(config.getBdbLogIteratorReadSize()));
        this.environmentConfig.setLockTimeout(config.getBdbLockTimeoutMs(), TimeUnit.MILLISECONDS);
        this.databaseConfig = new DatabaseConfig();
        this.databaseConfig.setAllowCreate(true);
        this.databaseConfig.setSortedDuplicates(config.isBdbSortedDuplicatesEnabled());
        this.databaseConfig.setNodeMaxEntries(config.getBdbBtreeFanout());
        this.databaseConfig.setTransactional(true);
        this.bdbMasterDir = config.getBdbDataDirectory();
        this.useOneEnvPerStore = config.isBdbOneEnvPerStore();
        this.unreservedStores = new HashSet<Environment>();
    }

    @Override
    public StorageEngine<ByteArray, byte[], byte[]> getStore(StoreDefinition storeDef) {
        Object object = this.lock;
        synchronized (object) {
            try {
                String storeName = storeDef.getName();
                Environment environment = this.getEnvironment(storeDef);
                Database db = environment.openDatabase(null, storeName, this.databaseConfig);
                BdbRuntimeConfig runtimeConfig = new BdbRuntimeConfig(this.voldemortConfig);
                BdbStorageEngine engine = new BdbStorageEngine(storeName, environment, db, runtimeConfig);
                if (this.voldemortConfig.isJmxEnabled()) {
                    JmxUtils.registerMbean(storeName, engine.getBdbEnvironmentStats());
                }
                return engine;
            }
            catch (DatabaseException d) {
                throw new StorageInitializationException(d);
            }
        }
    }

    private void adjustCacheSizes() {
        long newSharedCacheSize = this.voldemortConfig.getBdbCacheSize() - this.reservedCacheSize;
        logger.info((Object)("Setting the shared cache size to " + newSharedCacheSize));
        for (Environment environment : this.unreservedStores) {
            EnvironmentMutableConfig mConfig = environment.getMutableConfig();
            mConfig.setCacheSize(newSharedCacheSize);
            environment.setMutableConfig(mConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Environment getEnvironment(StoreDefinition storeDef) throws DatabaseException {
        String storeName = storeDef.getName();
        Object object = this.lock;
        synchronized (object) {
            if (this.useOneEnvPerStore) {
                if (this.environments.containsKey(storeName)) {
                    return this.environments.get(storeName);
                }
                File bdbDir = new File(this.bdbMasterDir, storeName);
                this.createBdbDirIfNecessary(bdbDir);
                if (storeDef.hasMemoryFootprint()) {
                    long reservedBytes = storeDef.getMemoryFootprintMB() * 0x100000L;
                    long newReservedCacheSize = this.reservedCacheSize + reservedBytes;
                    if (this.voldemortConfig.getBdbCacheSize() - newReservedCacheSize < this.voldemortConfig.getBdbMinimumSharedCache()) {
                        throw new StorageInitializationException("Reservation of " + storeDef.getMemoryFootprintMB() + " MB for store " + storeName + " violates minimum shared cache size of " + this.voldemortConfig.getBdbMinimumSharedCache());
                    }
                    this.reservedCacheSize = newReservedCacheSize;
                    this.adjustCacheSizes();
                    this.environmentConfig.setSharedCache(false);
                    this.environmentConfig.setCacheSize(reservedBytes);
                } else {
                    this.environmentConfig.setSharedCache(true);
                    this.environmentConfig.setCacheSize(this.voldemortConfig.getBdbCacheSize() - this.reservedCacheSize);
                }
                Environment environment = new Environment(bdbDir, this.environmentConfig);
                logger.info((Object)("Creating environment for " + storeName + ": "));
                this.logEnvironmentConfig(environment.getConfig());
                this.environments.put(storeName, environment);
                if (!storeDef.hasMemoryFootprint()) {
                    this.unreservedStores.add(environment);
                }
                return environment;
            }
            if (!this.environments.isEmpty()) {
                return this.environments.get(SHARED_ENV_KEY);
            }
            File bdbDir = new File(this.bdbMasterDir);
            this.createBdbDirIfNecessary(bdbDir);
            Environment environment = new Environment(bdbDir, this.environmentConfig);
            logger.info((Object)"Creating shared BDB environment: ");
            this.logEnvironmentConfig(environment.getConfig());
            this.environments.put(SHARED_ENV_KEY, environment);
            return environment;
        }
    }

    private void createBdbDirIfNecessary(File bdbDir) {
        if (!bdbDir.exists()) {
            logger.info((Object)("Creating BDB data directory '" + bdbDir.getAbsolutePath() + "."));
            bdbDir.mkdirs();
        }
    }

    private void logEnvironmentConfig(EnvironmentConfig config) {
        logger.info((Object)("    BDB cache size = " + config.getCacheSize()));
        logger.info((Object)("    BDB je.cleaner.threads = " + config.getConfigParam("je.cleaner.threads")));
        logger.info((Object)("    BDB je.cleaner.minUtilization = " + config.getConfigParam("je.cleaner.minUtilization")));
        logger.info((Object)("    BDB je.cleaner.minFileUtilization = " + config.getConfigParam("je.cleaner.minFileUtilization")));
        logger.info((Object)("    BDB je.log.fileMax = " + config.getConfigParam("je.log.fileMax")));
        logger.info((Object)("    BDB " + config.toString().replace('\n', ',')));
    }

    @Override
    public String getType() {
        return TYPE_NAME;
    }

    public String getStats(String storeName, boolean fast) {
        try {
            if (this.environments.containsKey(storeName)) {
                StatsConfig config = new StatsConfig();
                config.setFast(fast);
                Environment env = this.environments.get(storeName);
                return env.getStats(config).toString();
            }
            return "";
        }
        catch (DatabaseException e) {
            throw new VoldemortException(e);
        }
    }

    @JmxOperation(description="A variety of quickly calculated stats about one BDB environment.")
    public String getEnvStatsAsString(String storeName) throws Exception {
        return this.getEnvStatsAsString(storeName, true);
    }

    @JmxOperation(description="A variety of stats about one BDB environment.")
    public String getEnvStatsAsString(String storeName, boolean fast) throws Exception {
        String envStats = this.getStats(storeName, fast);
        logger.debug((Object)("Bdb Environment stats:\n" + envStats));
        return envStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JmxOperation(description="Forceful start the cleaner threads")
    public void cleanLogs() {
        Object object = this.lock;
        synchronized (object) {
            try {
                for (Environment environment : this.environments.values()) {
                    environment.cleanLog();
                }
            }
            catch (DatabaseException e) {
                throw new VoldemortException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                for (Environment environment : this.environments.values()) {
                    environment.sync();
                    environment.close();
                }
            }
            catch (DatabaseException e) {
                throw new VoldemortException(e);
            }
        }
    }

    @Override
    public void update(StoreDefinition storeDef) {
        if (!this.useOneEnvPerStore) {
            throw new VoldemortException("Memory foot print can be set only when using different environments per store");
        }
        String storeName = storeDef.getName();
        Environment environment = this.environments.get(storeName);
        if (!this.unreservedStores.contains(environment) && storeDef.hasMemoryFootprint()) {
            long newCacheSize;
            EnvironmentMutableConfig mConfig = environment.getMutableConfig();
            long currentCacheSize = mConfig.getCacheSize();
            if (currentCacheSize != (newCacheSize = storeDef.getMemoryFootprintMB() * 0x100000L)) {
                long newReservedCacheSize = this.reservedCacheSize - currentCacheSize + newCacheSize;
                if (this.voldemortConfig.getBdbCacheSize() - newReservedCacheSize < this.voldemortConfig.getBdbMinimumSharedCache()) {
                    throw new StorageInitializationException("Reservation of " + storeDef.getMemoryFootprintMB() + " MB for store " + storeName + " violates minimum shared cache size of " + this.voldemortConfig.getBdbMinimumSharedCache());
                }
                this.reservedCacheSize = newReservedCacheSize;
                this.adjustCacheSizes();
                mConfig.setCacheSize(newCacheSize);
                environment.setMutableConfig(mConfig);
                logger.info((Object)("Setting private cache for store " + storeDef.getName() + " to " + newCacheSize));
            }
        } else {
            throw new VoldemortException("Cannot switch between shared and private cache dynamically");
        }
    }

    public long getReservedCacheSize() {
        return this.reservedCacheSize;
    }
}

