/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.invalidmetadata;

import java.util.List;
import java.util.Map;
import voldemort.VoldemortException;
import voldemort.cluster.Node;
import voldemort.routing.RoutingStrategy;
import voldemort.store.DelegatingStore;
import voldemort.store.Store;
import voldemort.store.StoreUtils;
import voldemort.store.metadata.MetadataStore;
import voldemort.utils.ByteArray;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvalidMetadataCheckingStore
extends DelegatingStore<ByteArray, byte[], byte[]> {
    private final int nodeId;
    private final MetadataStore metadata;

    public InvalidMetadataCheckingStore(int nodeId, Store<ByteArray, byte[], byte[]> innerStore, MetadataStore metadata) {
        super(innerStore);
        this.metadata = metadata;
        this.nodeId = nodeId;
    }

    @Override
    public boolean delete(ByteArray key, Version version) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        StoreUtils.assertValidMetadata(key, this.metadata.getRoutingStrategy(this.getName()), this.metadata.getCluster().getNodeById(this.nodeId));
        return this.getInnerStore().delete(key, version);
    }

    @Override
    public Map<ByteArray, List<Versioned<byte[]>>> getAll(Iterable<ByteArray> keys, Map<ByteArray, byte[]> transforms) throws VoldemortException {
        StoreUtils.assertValidKeys(keys);
        RoutingStrategy routingStrategy = this.metadata.getRoutingStrategy(this.getName());
        Node node = this.metadata.getCluster().getNodeById(this.nodeId);
        for (ByteArray key : keys) {
            StoreUtils.assertValidMetadata(key, routingStrategy, node);
        }
        return this.getInnerStore().getAll(keys, transforms);
    }

    @Override
    public void put(ByteArray key, Versioned<byte[]> value, byte[] transforms) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        StoreUtils.assertValidMetadata(key, this.metadata.getRoutingStrategy(this.getName()), this.metadata.getCluster().getNodeById(this.nodeId));
        this.getInnerStore().put(key, value, transforms);
    }

    @Override
    public List<Versioned<byte[]>> get(ByteArray key, byte[] transforms) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        StoreUtils.assertValidMetadata(key, this.metadata.getRoutingStrategy(this.getName()), this.metadata.getCluster().getNodeById(this.nodeId));
        return this.getInnerStore().get(key, transforms);
    }
}

