/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

public class NettyTransportCodec {

    public static class NettyFrameDecoder
    extends FrameDecoder {
        private boolean packHeaderRead = false;
        private int listSize;
        private NettyDataPack dataPack;

        protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
            if (!this.packHeaderRead) {
                if (this.decodePackHeader(ctx, channel, buffer)) {
                    this.packHeaderRead = true;
                }
                return null;
            }
            if (this.decodePackBody(ctx, channel, buffer)) {
                this.packHeaderRead = false;
                return this.dataPack;
            }
            return null;
        }

        private boolean decodePackHeader(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
            if (buffer.readableBytes() < 8) {
                return false;
            }
            int serial = buffer.readInt();
            this.listSize = buffer.readInt();
            this.dataPack = new NettyDataPack(serial, new ArrayList<ByteBuffer>(this.listSize));
            return true;
        }

        private boolean decodePackBody(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
            if (buffer.readableBytes() < 4) {
                return false;
            }
            buffer.markReaderIndex();
            int length = buffer.readInt();
            if (buffer.readableBytes() < length) {
                buffer.resetReaderIndex();
                return false;
            }
            ByteBuffer bb = ByteBuffer.allocate(length);
            buffer.readBytes(bb);
            bb.flip();
            this.dataPack.getDatas().add(bb);
            return this.dataPack.getDatas().size() == this.listSize;
        }
    }

    public static class NettyFrameEncoder
    extends OneToOneEncoder {
        protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
            NettyDataPack dataPack = (NettyDataPack)msg;
            List<ByteBuffer> origs = dataPack.getDatas();
            ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>(origs.size() * 2 + 1);
            bbs.add(this.getPackHeader(dataPack));
            for (ByteBuffer b : origs) {
                bbs.add(this.getLengthHeader(b));
                bbs.add(b);
            }
            return ChannelBuffers.wrappedBuffer((ByteBuffer[])bbs.toArray(new ByteBuffer[bbs.size()]));
        }

        private ByteBuffer getPackHeader(NettyDataPack dataPack) {
            ByteBuffer header = ByteBuffer.allocate(8);
            header.putInt(dataPack.getSerial());
            header.putInt(dataPack.getDatas().size());
            header.flip();
            return header;
        }

        private ByteBuffer getLengthHeader(ByteBuffer buf) {
            ByteBuffer header = ByteBuffer.allocate(4);
            header.putInt(buf.limit());
            header.flip();
            return header;
        }
    }

    public static class NettyDataPack {
        private int serial;
        private List<ByteBuffer> datas;

        public NettyDataPack() {
        }

        public NettyDataPack(int serial, List<ByteBuffer> datas) {
            this.serial = serial;
            this.datas = datas;
        }

        public void setSerial(int serial) {
            this.serial = serial;
        }

        public int getSerial() {
            return this.serial;
        }

        public void setDatas(List<ByteBuffer> datas) {
            this.datas = datas;
        }

        public List<ByteBuffer> getDatas() {
            return this.datas;
        }
    }
}

