/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.tool.Tool;
import org.apache.avro.tool.Util;

public class FromTextTool
implements Tool {
    private static final String TEXT_FILE_SCHEMA = "\"bytes\"";

    @Override
    public String getName() {
        return "fromtext";
    }

    @Override
    public String getShortDescription() {
        return "Imports a text file into an avro data file.";
    }

    @Override
    public int run(InputStream stdin, PrintStream out, PrintStream err, List<String> args) throws Exception {
        String line;
        OptionParser p = new OptionParser();
        ArgumentAcceptingOptionSpec level = p.accepts("level", "compression level").withOptionalArg().ofType(Integer.class);
        OptionSet opts = p.parse(args.toArray(new String[0]));
        if (opts.nonOptionArguments().size() != 2) {
            err.println("Expected 2 args: from_file to_file (local filenames, Hadoop URI's, or '-' for stdin/stdout");
            p.printHelpOn((OutputStream)err);
            return 1;
        }
        BufferedInputStream inStream = Util.fileOrStdin(args.get(0), stdin);
        BufferedOutputStream outStream = Util.fileOrStdout(args.get(1), out);
        int compressionLevel = 1;
        if (opts.hasArgument((OptionSpec)level)) {
            compressionLevel = (Integer)level.value(opts);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
        DataFileWriter<ByteBuffer> writer = new DataFileWriter<ByteBuffer>(new GenericDatumWriter());
        writer.setCodec(CodecFactory.deflateCodec(compressionLevel));
        writer.create(Schema.parse(TEXT_FILE_SCHEMA), outStream);
        while ((line = reader.readLine()) != null) {
            ByteBuffer buff = ByteBuffer.wrap(line.getBytes());
            writer.append(buff);
        }
        writer.flush();
        writer.close();
        inStream.close();
        return 0;
    }
}

