/*
 * Decompiled with CFR 0.152.
 */
package azkaban.webapp.servlet.admin;

import azkaban.utils.DataSourceUtils;
import azkaban.utils.Props;
import azkaban.utils.Utils;
import azkaban.webapp.AzkabanAdminServer;
import azkaban.webapp.servlet.AbstractAzkabanServlet;
import azkaban.webapp.servlet.MultipartParser;
import azkaban.webapp.servlet.Page;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class InitialSetupServlet
extends AbstractAzkabanServlet {
    private static final long serialVersionUID = -1L;
    private static final int DEFAULT_UPLOAD_DISK_SPOOL_SIZE = 0x1400000;
    private static final String DB_DIRECTORY = "db";
    private static Logger logger = Logger.getLogger(InitialSetupServlet.class);
    private File mysqlConnectorJar;
    private File propsFile;
    private String pluginLibDirectory;
    private MultipartParser multipartParser;
    private Props props;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        AzkabanAdminServer server = (AzkabanAdminServer)this.getApplication();
        this.pluginLibDirectory = server.getPluginLibDirectory();
        this.props = server.getServerProps();
        this.multipartParser = new MultipartParser(0x1400000);
        this.mysqlConnectorJar = this.getConnectorJar();
        this.propsFile = server.getPropFile();
    }

    private File getConnectorJar() {
        File[] listFiles;
        File pluginLibs = new File(this.pluginLibDirectory);
        File dbPluginDir = new File(pluginLibs, DB_DIRECTORY);
        if (dbPluginDir.exists() && (listFiles = dbPluginDir.listFiles(new PrefixSuffixFilter("mysql-connector", ".jar"))).length > 0) {
            return listFiles[0];
        }
        return null;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.hasParam(req, "dbsetup")) {
            Page page = this.newPage(req, resp, "azkaban/webapp/servlet/admin/velocity/setup-db.vm");
            String host = this.props.getString("mysql.host", "localhost");
            int port = this.props.getInt("mysql.port", 3306);
            String database = this.props.getString("mysql.database", "");
            String username = this.props.getString("mysql.username", "");
            String password = this.props.getString("mysql.password", "");
            page.add("host", host);
            page.add("port", port);
            page.add("database", database);
            page.add("username", username);
            page.add("password", password);
            if (this.mysqlConnectorJar != null) {
                page.add("installedJar", this.mysqlConnectorJar.getName());
                if (this.props.containsKey("mysql.host")) {
                    URL url = this.mysqlConnectorJar.toURI().toURL();
                    URL[] urls = new URL[]{url};
                    URLClassLoader mySQLLoader = new URLClassLoader(urls, InitialSetupServlet.class.getClassLoader());
                    try {
                        Utils.invokeStaticMethod(mySQLLoader, DataSourceUtils.class.getName(), "testMySQLConnection", host, port, database, username, password, 1);
                        page.add("message", "Able to connect to DB.");
                        page.add("verified", true);
                    }
                    catch (InvocationTargetException e) {
                        page.add("message", "");
                        page.add("verified", false);
                    }
                    catch (Exception e) {
                        page.add("message", "");
                        page.add("verified", false);
                    }
                }
            }
            page.render();
        } else if (this.hasParam(req, "usersetup")) {
            Page page = this.newPage(req, resp, "azkaban/webapp/servlet/admin/velocity/setup-usermanager.vm");
            page.render();
        } else {
            Page page = this.newPage(req, resp, "azkaban/webapp/servlet/admin/velocity/setup-initial.vm");
            page.render();
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap<String, Object> jsonResponse = new HashMap<String, Object>();
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
            String action;
            logger.info((Object)"Post is multipart");
            Map<String, Object> params = this.multipartParser.parseMultipart(req);
            if (params.containsKey("action") && (action = (String)params.get("action")).equals("upload")) {
                this.handleUpload(req, resp, params, jsonResponse);
            }
        } else if (this.hasParam(req, "ajax")) {
            try {
                String action = this.getParam(req, "ajax");
                if (action.equals("saveDbConnection")) {
                    this.handleSaveDBConnection(req, resp, jsonResponse);
                }
            }
            catch (InvocationTargetException e) {
                jsonResponse.put("error", e.getTargetException().getMessage());
            }
            catch (Exception e) {
                jsonResponse.put("error", e.getMessage());
            }
        }
        this.writeJSON(resp, jsonResponse);
    }

    private void handleSaveDBConnection(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> jsonResponse) throws Exception {
        if (this.mysqlConnectorJar == null) {
            jsonResponse.put("error", "No connector jar has been installed");
        } else {
            String host = this.getParam(req, "host");
            int port = this.getIntParam(req, "port");
            String database = this.getParam(req, "database");
            String username = this.getParam(req, "username");
            String password = this.getParam(req, "password");
            URL url = this.mysqlConnectorJar.toURI().toURL();
            URL[] urls = new URL[]{url};
            URLClassLoader mySQLLoader = new URLClassLoader(urls, InitialSetupServlet.class.getClassLoader());
            Utils.invokeStaticMethod(mySQLLoader, DataSourceUtils.class.getName(), "testMySQLConnection", host, port, database, username, password, 1);
            this.props.put("mysql.host", host);
            this.props.put("mysql.port", port);
            this.props.put("mysql.database", database);
            this.props.put("mysql.username", username);
            this.props.put("mysql.password", password);
            logger.info((Object)("Print file " + this.propsFile.getPath()));
            this.props.storeLocal(this.propsFile);
            jsonResponse.put("success", "Able to connect to DB.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUpload(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> multipart, Map<String, Object> jsonResponse) throws ServletException, IOException {
        FileItem item = (FileItem)multipart.get("file");
        String name = item.getName();
        File tempDir = Utils.createTempDir();
        OutputStream out = null;
        try {
            logger.info((Object)("Uploading file " + name));
            File archiveFile = new File(tempDir, name);
            out = new BufferedOutputStream(new FileOutputStream(archiveFile));
            IOUtils.copy((InputStream)item.getInputStream(), (OutputStream)out);
            out.close();
            File pluginLibs = new File(this.pluginLibDirectory);
            File dbPluginDir = new File(pluginLibs, DB_DIRECTORY);
            if (dbPluginDir.exists()) {
                // empty if block
            }
            if (!dbPluginDir.exists()) {
                dbPluginDir.mkdirs();
            } else {
                FileUtils.cleanDirectory((File)dbPluginDir);
            }
            File newName = new File(dbPluginDir, archiveFile.getName());
            archiveFile.renameTo(newName);
            this.mysqlConnectorJar = newName;
            jsonResponse.put("jarname", archiveFile.getName());
        }
        catch (Exception e) {
            jsonResponse.put("error", "Failed:" + e.getMessage());
        }
        finally {
            if (tempDir.exists()) {
                FileUtils.deleteDirectory((File)tempDir);
            }
            if (out != null) {
                out.close();
            }
        }
    }

    private static class PrefixSuffixFilter
    implements FileFilter {
        private String prefix;
        private String suffix;

        public PrefixSuffixFilter(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }

        @Override
        public boolean accept(File pathname) {
            String name = pathname.getName();
            if (!pathname.isFile() || pathname.isHidden()) {
                return false;
            }
            if (name.length() < this.prefix.length() || !name.startsWith(this.prefix)) {
                return false;
            }
            return name.length() >= this.suffix.length() && name.endsWith(this.suffix);
        }
    }
}

