/*
 * Decompiled with CFR 0.152.
 */
package azkaban.webapp.servlet;

import azkaban.utils.JSONUtils;
import azkaban.utils.Props;
import azkaban.utils.WebUtils;
import azkaban.webapp.AzkabanServer;
import azkaban.webapp.AzkabanWebServer;
import azkaban.webapp.servlet.HttpRequestUtils;
import azkaban.webapp.servlet.Page;
import azkaban.webapp.servlet.TriggerPlugin;
import azkaban.webapp.servlet.ViewerPlugin;
import azkaban.webapp.session.Session;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class AbstractAzkabanServlet
extends HttpServlet {
    private static final DateTimeFormatter ZONE_FORMATTER = DateTimeFormat.forPattern((String)"z");
    private static final String AZKABAN_SUCCESS_MESSAGE = "azkaban.success.message";
    private static final String AZKABAN_FAILURE_MESSAGE = "azkaban.failure.message";
    private static final long serialVersionUID = -1L;
    public static final String DEFAULT_LOG_URL_PREFIX = "predefined_log_url_prefix";
    public static final String LOG_URL_PREFIX = "log_url_prefix";
    public static final String HTML_TYPE = "text/html";
    public static final String XML_MIME_TYPE = "application/xhtml+xml";
    public static final String JSON_MIME_TYPE = "application/json";
    private static final WebUtils utils = new WebUtils();
    private AzkabanServer application;
    private String name;
    private String label;
    private String color;
    private List<ViewerPlugin> viewerPlugins;
    private List<TriggerPlugin> triggerPlugins;

    public AzkabanServer getApplication() {
        return this.application;
    }

    public void init(ServletConfig config) throws ServletException {
        this.application = (AzkabanServer)config.getServletContext().getAttribute("azkaban_app");
        if (this.application == null) {
            throw new IllegalStateException("No batch application is defined in the servlet context!");
        }
        Props props = this.application.getServerProps();
        this.name = props.getString("azkaban.name", "");
        this.label = props.getString("azkaban.label", "");
        this.color = props.getString("azkaban.color", "#FF0000");
        if (this.application instanceof AzkabanWebServer) {
            AzkabanWebServer server = (AzkabanWebServer)this.application;
            this.viewerPlugins = server.getViewerPlugins();
            this.triggerPlugins = new ArrayList<TriggerPlugin>(server.getTriggerPlugins().values());
        }
    }

    public boolean hasParam(HttpServletRequest request, String param) {
        return HttpRequestUtils.hasParam(request, param);
    }

    public String getParam(HttpServletRequest request, String name) throws ServletException {
        return HttpRequestUtils.getParam(request, name);
    }

    public String getParam(HttpServletRequest request, String name, String defaultVal) {
        return HttpRequestUtils.getParam(request, name, defaultVal);
    }

    public int getIntParam(HttpServletRequest request, String name) throws ServletException {
        return HttpRequestUtils.getIntParam(request, name);
    }

    public int getIntParam(HttpServletRequest request, String name, int defaultVal) {
        return HttpRequestUtils.getIntParam(request, name, defaultVal);
    }

    public long getLongParam(HttpServletRequest request, String name) throws ServletException {
        return HttpRequestUtils.getLongParam(request, name);
    }

    public long getLongParam(HttpServletRequest request, String name, long defaultVal) {
        return HttpRequestUtils.getLongParam(request, name, defaultVal);
    }

    public Map<String, String> getParamGroup(HttpServletRequest request, String groupName) throws ServletException {
        return HttpRequestUtils.getParamGroup(request, groupName);
    }

    protected void setSessionValue(HttpServletRequest request, String key, Object value) {
        request.getSession(true).setAttribute(key, value);
    }

    protected void addSessionValue(HttpServletRequest request, String key, Object value) {
        ArrayList<Object> l = (ArrayList<Object>)request.getSession(true).getAttribute(key);
        if (l == null) {
            l = new ArrayList<Object>();
        }
        l.add(value);
        request.getSession(true).setAttribute(key, l);
    }

    protected void setErrorMessageInCookie(HttpServletResponse response, String errorMsg) {
        Cookie cookie = new Cookie(AZKABAN_FAILURE_MESSAGE, errorMsg);
        cookie.setPath("/");
        response.addCookie(cookie);
    }

    protected void setSuccessMessageInCookie(HttpServletResponse response, String message) {
        Cookie cookie = new Cookie(AZKABAN_SUCCESS_MESSAGE, message);
        cookie.setPath("/");
        response.addCookie(cookie);
    }

    protected String getSuccessMessageFromCookie(HttpServletRequest request) {
        Cookie cookie = this.getCookieByName(request, AZKABAN_SUCCESS_MESSAGE);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    protected String getErrorMessageFromCookie(HttpServletRequest request) {
        Cookie cookie = this.getCookieByName(request, AZKABAN_FAILURE_MESSAGE);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    protected Cookie getCookieByName(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!name.equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    protected Page newPage(HttpServletRequest req, HttpServletResponse resp, Session session, String template) {
        Page page = new Page(req, resp, this.application.getVelocityEngine(), template);
        page.add("azkaban_name", this.name);
        page.add("azkaban_label", this.label);
        page.add("azkaban_color", this.color);
        page.add("utils", utils);
        page.add("timezone", ZONE_FORMATTER.print(System.currentTimeMillis()));
        page.add("currentTime", new DateTime().getMillis());
        if (session != null && session.getUser() != null) {
            page.add("user_id", session.getUser().getUserId());
        }
        page.add("context", req.getContextPath());
        String errorMsg = this.getErrorMessageFromCookie(req);
        page.add("error_message", errorMsg == null || errorMsg.isEmpty() ? "null" : errorMsg);
        this.setErrorMessageInCookie(resp, null);
        String successMsg = this.getSuccessMessageFromCookie(req);
        page.add("success_message", successMsg == null || successMsg.isEmpty() ? "null" : successMsg);
        this.setSuccessMessageInCookie(resp, null);
        if (this.viewerPlugins != null && !this.viewerPlugins.isEmpty()) {
            page.add("viewers", this.viewerPlugins);
        }
        if (this.triggerPlugins != null && !this.triggerPlugins.isEmpty()) {
            page.add("triggerPlugins", this.triggerPlugins);
        }
        return page;
    }

    protected Page newPage(HttpServletRequest req, HttpServletResponse resp, String template) {
        Page page = new Page(req, resp, this.application.getVelocityEngine(), template);
        page.add("azkaban_name", this.name);
        page.add("azkaban_label", this.label);
        page.add("azkaban_color", this.color);
        page.add("timezone", ZONE_FORMATTER.print(System.currentTimeMillis()));
        page.add("currentTime", new DateTime().getMillis());
        page.add("context", req.getContextPath());
        if (this.viewerPlugins != null && !this.viewerPlugins.isEmpty()) {
            page.add("viewers", this.viewerPlugins);
            ViewerPlugin plugin = this.viewerPlugins.get(0);
            page.add("viewerName", plugin.getPluginName());
            page.add("viewerPath", plugin.getPluginPath());
        }
        if (this.triggerPlugins != null && !this.triggerPlugins.isEmpty()) {
            page.add("triggers", this.triggerPlugins);
        }
        return page;
    }

    protected void writeJSON(HttpServletResponse resp, Object obj) throws IOException {
        this.writeJSON(resp, obj, false);
    }

    protected void writeJSON(HttpServletResponse resp, Object obj, boolean pretty) throws IOException {
        resp.setContentType(JSON_MIME_TYPE);
        JSONUtils.toJSON(obj, (OutputStream)resp.getOutputStream(), true);
    }

    public static AzkabanWebServer getApp(ServletConfig config) {
        AzkabanWebServer app = (AzkabanWebServer)config.getServletContext().getAttribute("azkaban_app");
        if (app == null) {
            throw new IllegalStateException("No batch application is defined in the servlet context!");
        }
        return app;
    }

    public static String createJsonResponse(String status, String message, String action, Map<String, Object> params) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("status", status);
        if (message != null) {
            response.put("message", message);
        }
        if (action != null) {
            response.put("action", action);
        }
        if (params != null) {
            response.putAll(params);
        }
        return JSONUtils.toJSON(response);
    }
}

