/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExecutionOptions {
    public static final String CONCURRENT_OPTION_SKIP = "skip";
    public static final String CONCURRENT_OPTION_PIPELINE = "pipeline";
    public static final String CONCURRENT_OPTION_IGNORE = "ignore";
    private boolean notifyOnFirstFailure = true;
    private boolean notifyOnLastFailure = false;
    private boolean failureEmailsOverride = false;
    private boolean successEmailsOverride = false;
    private ArrayList<String> failureEmails = new ArrayList();
    private ArrayList<String> successEmails = new ArrayList();
    private Integer pipelineLevel = null;
    private Integer pipelineExecId = null;
    private Integer queueLevel = 0;
    private String concurrentOption = "ignore";
    private Map<String, String> flowParameters = new HashMap<String, String>();
    private FailureAction failureAction = FailureAction.FINISH_CURRENTLY_RUNNING;
    private Set<String> initiallyDisabledJobs = new HashSet<String>();

    public void setFlowParameters(Map<String, String> flowParam) {
        this.flowParameters.putAll(flowParam);
    }

    public Map<String, String> getFlowParameters() {
        return this.flowParameters;
    }

    public void setFailureEmails(Collection<String> emails) {
        this.failureEmails = new ArrayList<String>(emails);
    }

    public boolean isFailureEmailsOverridden() {
        return this.failureEmailsOverride;
    }

    public boolean isSuccessEmailsOverridden() {
        return this.successEmailsOverride;
    }

    public void setSuccessEmailsOverridden(boolean override) {
        this.successEmailsOverride = override;
    }

    public void setFailureEmailsOverridden(boolean override) {
        this.failureEmailsOverride = override;
    }

    public List<String> getFailureEmails() {
        return this.failureEmails;
    }

    public void setSuccessEmails(Collection<String> emails) {
        this.successEmails = new ArrayList<String>(emails);
    }

    public List<String> getSuccessEmails() {
        return this.successEmails;
    }

    public boolean getNotifyOnFirstFailure() {
        return this.notifyOnFirstFailure;
    }

    public boolean getNotifyOnLastFailure() {
        return this.notifyOnLastFailure;
    }

    public void setNotifyOnFirstFailure(boolean notify) {
        this.notifyOnFirstFailure = notify;
    }

    public void setNotifyOnLastFailure(boolean notify) {
        this.notifyOnLastFailure = notify;
    }

    public FailureAction getFailureAction() {
        return this.failureAction;
    }

    public void setFailureAction(FailureAction action) {
        this.failureAction = action;
    }

    public void setConcurrentOption(String concurrentOption) {
        this.concurrentOption = concurrentOption;
    }

    public String getConcurrentOption() {
        return this.concurrentOption;
    }

    public Integer getPipelineLevel() {
        return this.pipelineLevel;
    }

    public Integer getPipelineExecutionId() {
        return this.pipelineExecId;
    }

    public void setPipelineLevel(Integer level) {
        this.pipelineLevel = level;
    }

    public void setPipelineExecutionId(Integer id) {
        this.pipelineExecId = id;
    }

    public Integer getQueueLevel() {
        return this.queueLevel;
    }

    public List<String> getDisabledJobs() {
        return new ArrayList<String>(this.initiallyDisabledJobs);
    }

    public void setDisabledJobs(List<String> disabledJobs) {
        this.initiallyDisabledJobs = new HashSet<String>(disabledJobs);
    }

    public Map<String, Object> toObject() {
        HashMap<String, Object> flowOptionObj = new HashMap<String, Object>();
        flowOptionObj.put("flowParameters", this.flowParameters);
        flowOptionObj.put("notifyOnFirstFailure", this.notifyOnFirstFailure);
        flowOptionObj.put("notifyOnLastFailure", this.notifyOnLastFailure);
        flowOptionObj.put("successEmails", this.successEmails);
        flowOptionObj.put("failureEmails", this.failureEmails);
        flowOptionObj.put("failureAction", this.failureAction.toString());
        flowOptionObj.put("pipelineLevel", this.pipelineLevel);
        flowOptionObj.put("pipelineExecId", this.pipelineExecId);
        flowOptionObj.put("queueLevel", this.queueLevel);
        flowOptionObj.put("concurrentOption", this.concurrentOption);
        flowOptionObj.put("disabled", this.initiallyDisabledJobs);
        flowOptionObj.put("failureEmailsOverride", this.failureEmailsOverride);
        flowOptionObj.put("successEmailsOverride", this.successEmailsOverride);
        return flowOptionObj;
    }

    public static ExecutionOptions createFromObject(Object obj) {
        if (obj == null || !(obj instanceof Map)) {
            return null;
        }
        Map optionsMap = (Map)obj;
        ExecutionOptions options = new ExecutionOptions();
        if (optionsMap.containsKey("flowParameters")) {
            options.flowParameters = new HashMap<String, String>((Map)optionsMap.get("flowParameters"));
        }
        if (optionsMap.containsKey("notifyOnFirstFailure")) {
            options.notifyOnFirstFailure = (Boolean)optionsMap.get("notifyOnFirstFailure");
        }
        if (optionsMap.containsKey("notifyOnLastFailure")) {
            options.notifyOnLastFailure = (Boolean)optionsMap.get("notifyOnLastFailure");
        }
        if (optionsMap.containsKey("concurrentOption")) {
            options.concurrentOption = (String)optionsMap.get("concurrentOption");
        }
        if (optionsMap.containsKey("disabled")) {
            options.initiallyDisabledJobs = new HashSet<String>((List)optionsMap.get("disabled"));
        }
        if (optionsMap.containsKey("failureAction")) {
            options.failureAction = FailureAction.valueOf((String)optionsMap.get("failureAction"));
        }
        options.pipelineLevel = (Integer)optionsMap.get("pipelineLevel");
        options.pipelineExecId = (Integer)optionsMap.get("pipelineExecId");
        options.queueLevel = (Integer)optionsMap.get("queueLevel");
        if (optionsMap.containsKey("successEmails")) {
            options.setSuccessEmails((List)optionsMap.get("successEmails"));
        }
        if (optionsMap.containsKey("failureEmails")) {
            options.setFailureEmails((List)optionsMap.get("failureEmails"));
        }
        if (optionsMap.containsKey("successEmailsOverride")) {
            options.setSuccessEmailsOverridden((Boolean)optionsMap.get("successEmailsOverride"));
        }
        if (optionsMap.containsKey("failureEmailsOverride")) {
            options.setFailureEmailsOverridden((Boolean)optionsMap.get("failureEmailsOverride"));
        }
        return options;
    }

    public static enum FailureAction {
        FINISH_CURRENTLY_RUNNING,
        CANCEL_ALL,
        FINISH_ALL_POSSIBLE;

    }
}

