/*
 * Decompiled with CFR 0.152.
 */
package azkaban.schedule2File;

import azkaban.executor.ExecutionOptions;
import azkaban.scheduler.JdbcScheduleLoader;
import azkaban.scheduler.Schedule;
import azkaban.sla.SLA;
import azkaban.sla.SlaOptions;
import azkaban.utils.JSONUtils;
import azkaban.utils.Props;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.joda.time.ReadablePeriod;

public class Schedule2File {
    private static final Logger logger = Logger.getLogger(Schedule2File.class);

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            Schedule2File.printUsage();
        }
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            logger.info((Object)arg);
            ++n2;
        }
        File confFile = new File(args[0]);
        logger.info((Object)("Trying to load config from " + confFile.toString()));
        if (!(confFile.exists() && confFile.isFile() && confFile.canRead())) {
            logger.error((Object)"Cannot read conf file!");
            return;
        }
        File outputDir = new File(args[1]);
        if (!(outputDir.exists() && outputDir.isDirectory() && outputDir.canWrite())) {
            logger.error((Object)"Output directory is not ready!");
            return;
        }
        Props props = Schedule2File.loadAzkabanConfig(confFile);
        JdbcScheduleLoader scheduleLoader = new JdbcScheduleLoader(props);
        List schedules = scheduleLoader.loadSchedules();
        for (Schedule sched : schedules) {
            Schedule2File.writeScheduleFile(sched, outputDir);
        }
    }

    private static Props loadAzkabanConfig(File confFile) throws IOException {
        return new Props(null, confFile);
    }

    private static void printUsage() {
        System.out.println("Usage: schedule2File PATH_TO_CONFIG_FILE PATH_TO_OUTPUT_DIR");
    }

    private static void writeScheduleFile(Schedule sched, File outputDir) throws IOException {
        SlaOptions slaOptions;
        String scheduleFileName = String.valueOf(sched.getProjectName()) + "-" + sched.getFlowName();
        File outputFile = new File(outputDir, scheduleFileName);
        outputFile.createNewFile();
        Props props = new Props();
        props.put("flowName", sched.getFlowName());
        props.put("projectName", sched.getProjectName());
        props.put("projectId", String.valueOf(sched.getProjectId()));
        props.put("period", Schedule.createPeriodString((ReadablePeriod)sched.getPeriod()));
        props.put("firstScheduleTimeLong", Long.valueOf(sched.getFirstSchedTime()));
        props.put("timezone", sched.getTimezone().getID());
        props.put("submitUser", sched.getSubmitUser());
        props.put("submitTimeLong", Long.valueOf(sched.getSubmitTime()));
        props.put("nextExecTimeLong", Long.valueOf(sched.getNextExecTime()));
        ExecutionOptions executionOptions = sched.getExecutionOptions();
        if (executionOptions != null) {
            props.put("executionOptionsObj", JSONUtils.toJSON((Object)executionOptions.toObject()));
        }
        if ((slaOptions = sched.getSlaOptions()) != null) {
            ArrayList settingsObj = new ArrayList();
            List settings = slaOptions.getSettings();
            for (SLA.SlaSetting set : settings) {
                HashMap<String, Object> setObj = new HashMap<String, Object>();
                String setId = set.getId();
                SLA.SlaRule rule = set.getRule();
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("Duration", Schedule.createPeriodString((ReadablePeriod)set.getDuration()));
                info.put("EmailList", slaOptions.getSlaEmails());
                ArrayList<String> actionsList = new ArrayList<String>();
                for (SLA.SlaAction act : set.getActions()) {
                    if (act.equals((Object)SLA.SlaAction.EMAIL)) {
                        actionsList.add("SlaAlert");
                        info.put("SlaAlertType", "email");
                        continue;
                    }
                    if (!act.equals((Object)SLA.SlaAction.KILL)) continue;
                    actionsList.add("SlaCancelFlow");
                }
                setObj.put("actions", actionsList);
                if (setId.equals("")) {
                    info.put("FlowName", sched.getFlowName());
                    if (rule.equals((Object)SLA.SlaRule.FINISH)) {
                        setObj.put("type", "FlowFinish");
                    } else if (rule.equals((Object)SLA.SlaRule.SUCCESS)) {
                        setObj.put("type", "FlowSucceed");
                    }
                } else {
                    info.put("JobName", setId);
                    if (rule.equals((Object)SLA.SlaRule.FINISH)) {
                        setObj.put("type", "JobFinish");
                    } else if (rule.equals((Object)SLA.SlaRule.SUCCESS)) {
                        setObj.put("type", "JobSucceed");
                    }
                }
                setObj.put("info", info);
                settingsObj.add(setObj);
            }
            props.put("slaOptionsObj", JSONUtils.toJSON(settingsObj));
        }
        props.storeLocal(outputFile);
    }
}

