/*
 * Decompiled with CFR 0.152.
 */
package azkaban.sla;

import azkaban.sla.SLA;
import azkaban.utils.EmailMessage;
import azkaban.utils.Props;
import azkaban.utils.Utils;
import java.util.List;
import javax.mail.MessagingException;
import org.apache.log4j.Logger;

public class SlaMailer {
    private static Logger logger = Logger.getLogger(SlaMailer.class);
    private boolean testMode = false;
    private String clientHostname;
    private String clientPortNumber;
    private String mailHost;
    private String mailUser;
    private String mailPassword;
    private String mailSender;
    private String azkabanName;

    public SlaMailer(Props props) {
        this.azkabanName = props.getString("azkaban.name", "azkaban");
        this.mailHost = props.getString("mail.host", "localhost");
        this.mailUser = props.getString("mail.user", "");
        this.mailPassword = props.getString("mail.password", "");
        this.mailSender = props.getString("mail.sender", "");
        this.clientHostname = props.getString("jetty.hostname", "localhost");
        this.clientPortNumber = Utils.nonNull(props.getString("jetty.ssl.port"));
        this.testMode = props.getBoolean("test.mode", false);
    }

    public void sendSlaEmail(SLA s, String ... extraReasons) {
        List<String> emailList = s.getEmails();
        if (emailList != null && !emailList.isEmpty()) {
            EmailMessage message = new EmailMessage(this.mailHost, this.mailUser, this.mailPassword);
            message.setFromAddress(this.mailSender);
            message.addAllToAddress(emailList);
            message.setMimeType("text/html");
            message.setSubject("SLA violation on " + this.azkabanName);
            for (String reasons : extraReasons) {
                message.println("<li>" + reasons + "</li>");
            }
            message.println("</ul>");
            if (!this.testMode) {
                try {
                    message.sendEmail();
                }
                catch (MessagingException e) {
                    logger.error((Object)"Email message send failed", (Throwable)e);
                }
            }
        }
    }
}

