/*
 * Decompiled with CFR 0.152.
 */
package azkaban.webapp;

import azkaban.user.UserManager;
import azkaban.user.XmlUserManager;
import azkaban.utils.Props;
import azkaban.utils.Utils;
import azkaban.webapp.AzkabanServer;
import azkaban.webapp.servlet.admin.InitialSetupServlet;
import azkaban.webapp.session.SessionCache;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import javax.servlet.Servlet;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.log4j.Logger;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.log.Log4JLogChute;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.jetty.servlet.ServletHolder;

public class AzkabanAdminServer
implements AzkabanServer {
    private static final Logger logger = Logger.getLogger(AzkabanAdminServer.class);
    private static AzkabanAdminServer app;
    private static final String AZKABAN_DEFAULT_ADMIN_DIR = "admin";
    private static final String AZKABAN_DEFAULT_ADMIN_PROPERTIES = "admin.properties";
    private static final String AZKABAN_DEFAULT_WEB_DIR = "web";
    private static final String AZKABAN_DEFAULT_PLUGIN_DIR = "pluginlib";
    private static final int AZKABAN_DEFAULT_ADMIN_PORT = 12233;
    private static final String USER_MANAGER_CLASS_PARAM = "user.manager.class";
    private final VelocityEngine velocityEngine;
    private final SessionCache sessionCache;
    private static Server server;
    private String pluginLibDirectory;
    private File adminPropertiesFile;
    private Props props;

    public AzkabanAdminServer(Props props, File propFile, boolean initialSetup) throws Exception {
        this.props = props;
        this.velocityEngine = this.configureVelocityEngine(true);
        this.sessionCache = initialSetup ? null : new SessionCache(props);
        this.adminPropertiesFile = propFile;
        this.pluginLibDirectory = props.get("pluginLibDirectory");
    }

    public File getPropFile() {
        return this.adminPropertiesFile;
    }

    private VelocityEngine configureVelocityEngine(boolean devMode) {
        VelocityEngine engine = new VelocityEngine();
        engine.setProperty("resource.loader", (Object)"classpath");
        engine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        engine.setProperty("classpath.resource.loader.cache", (Object)(!devMode ? 1 : 0));
        engine.setProperty("classpath.resource.loader.modificationCheckInterval", (Object)5L);
        engine.setProperty("resource.manager.logwhenfound", (Object)false);
        engine.setProperty("input.encoding", (Object)"UTF-8");
        engine.setProperty("output.encoding", (Object)"UTF-8");
        engine.setProperty("directive.set.null.allowed", (Object)true);
        engine.setProperty("resource.manager.logwhenfound", (Object)false);
        engine.setProperty("velocimacro.permissions.allow.inline", (Object)true);
        engine.setProperty("velocimacro.library.autoreload", (Object)devMode);
        engine.setProperty("velocimacro.library", (Object)"/azkaban/webapp/servlet/velocity/macros.vm");
        engine.setProperty("velocimacro.permissions.allow.inline.to.replace.global", (Object)true);
        engine.setProperty("velocimacro.arguments.strict", (Object)true);
        engine.setProperty("runtime.log.invalid.references", (Object)devMode);
        engine.setProperty("runtime.log.logsystem.class", Log4JLogChute.class);
        engine.setProperty("runtime.log.logsystem.log4j.logger", (Object)Logger.getLogger((String)"org.apache.velocity.Logger"));
        engine.setProperty("parser.pool.size", (Object)3);
        return engine;
    }

    public static void main(String[] args) throws Exception {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec portArg = parser.acceptsAll(Arrays.asList("p", "port"), "The port for azkaban.").withRequiredArg().describedAs("port").ofType(Integer.class);
        ArgumentAcceptingOptionSpec adminDirectory = parser.acceptsAll(Arrays.asList("d", "dir"), "The admin directory").withRequiredArg().describedAs("dir").ofType(String.class);
        ArgumentAcceptingOptionSpec webDirectory = parser.acceptsAll(Arrays.asList("w", AZKABAN_DEFAULT_WEB_DIR), "The web resource directory").withRequiredArg().describedAs(AZKABAN_DEFAULT_WEB_DIR).ofType(String.class);
        ArgumentAcceptingOptionSpec pluginLibDirectory = parser.acceptsAll(Arrays.asList("l", AZKABAN_DEFAULT_PLUGIN_DIR), "The plugin lib directory").withRequiredArg().describedAs("plugin").ofType(String.class);
        OptionSet options = parser.parse(args);
        String adminDir = options.has((OptionSpec)adminDirectory) ? (String)options.valueOf((OptionSpec)adminDirectory) : AZKABAN_DEFAULT_ADMIN_DIR;
        int port = options.has((OptionSpec)portArg) ? (Integer)options.valueOf((OptionSpec)portArg) : 12233;
        String webDir = options.has((OptionSpec)webDirectory) ? (String)options.valueOf((OptionSpec)webDirectory) : AZKABAN_DEFAULT_WEB_DIR;
        String pluginLib = options.has((OptionSpec)pluginLibDirectory) ? (String)options.valueOf((OptionSpec)pluginLibDirectory) : AZKABAN_DEFAULT_PLUGIN_DIR;
        Props props = null;
        server = new Server();
        File adminDirFile = new File(adminDir);
        if (!adminDirFile.exists()) {
            adminDirFile.mkdirs();
        }
        File adminPropertiesFile = new File(adminDirFile, AZKABAN_DEFAULT_ADMIN_PROPERTIES);
        boolean secureMode = false;
        if (adminPropertiesFile.exists()) {
            props = new Props(null, adminPropertiesFile);
            if (props.containsKey("mysql.host") && props.containsKey(USER_MANAGER_CLASS_PARAM)) {
                secureMode = true;
            }
        } else {
            props = new Props();
        }
        if (secureMode) {
            app = new AzkabanAdminServer(props, adminPropertiesFile, false);
            SslSocketConnector secureConnector = new SslSocketConnector();
            secureConnector.setPort(port);
            server.addConnector((Connector)secureConnector);
        } else {
            logger.info((Object)"Server settings not found. Running setup wizard.");
            props.put("pluginLibDirectory", pluginLib);
            app = new AzkabanAdminServer(props, adminPropertiesFile, true);
            SocketConnector connector = new SocketConnector();
            connector.setPort(port);
            server.addConnector((Connector)connector);
        }
        Context root = new Context((HandlerContainer)server, "/", 1);
        String staticDir = webDir;
        root.setResourceBase(staticDir);
        root.setAttribute("azkaban_app", (Object)app);
        ServletHolder executorHolder = new ServletHolder((Servlet)new InitialSetupServlet());
        root.addServlet(executorHolder, "/");
        ServletHolder staticServlet = new ServletHolder((Servlet)new DefaultServlet());
        root.addServlet(staticServlet, "/css/*");
        root.addServlet(staticServlet, "/js/*");
        root.addServlet(staticServlet, "/images/*");
        root.addServlet(staticServlet, "/favicon.ico");
        try {
            server.start();
        }
        catch (Exception e) {
            logger.warn((Object)e);
            Utils.croak(e.getMessage(), 1);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                logger.info((Object)"Shutting down http server...");
                try {
                    app.stopServer();
                }
                catch (Exception e) {
                    logger.error((Object)"Error while shutting down http server.", (Throwable)e);
                }
                logger.info((Object)"kk thx bye.");
            }
        });
    }

    public void stopServer() throws Exception {
        server.stop();
        server.destroy();
    }

    @Override
    public Props getServerProps() {
        return this.props;
    }

    @Override
    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    @Override
    public SessionCache getSessionCache() {
        return null;
    }

    @Override
    public UserManager getUserManager() {
        return null;
    }

    public String getPluginLibDirectory() {
        return this.pluginLibDirectory;
    }

    private UserManager loadUserManager(Props props) {
        Class<?> userManagerClass = props.getClass(USER_MANAGER_CLASS_PARAM, null);
        logger.info((Object)("Loading user manager class " + userManagerClass.getName()));
        UserManager manager = null;
        if (userManagerClass != null && userManagerClass.getConstructors().length > 0) {
            try {
                Constructor<?> userManagerConstructor = userManagerClass.getConstructor(Props.class);
                manager = (UserManager)userManagerConstructor.newInstance(props);
            }
            catch (Exception e) {
                logger.error((Object)("Could not instantiate UserManager " + userManagerClass.getName()));
                throw new RuntimeException(e);
            }
        } else {
            manager = new XmlUserManager(props);
        }
        return manager;
    }
}

