/*
 * Decompiled with CFR 0.152.
 */
package azkaban.jobtype.examples.java;

import azkaban.jobtype.javautils.AbstractHadoopJob;
import azkaban.utils.Props;
import java.io.IOException;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.log4j.Logger;

public class WordCount
extends AbstractHadoopJob {
    private static final Logger logger = Logger.getLogger(WordCount.class);
    private final String inputPath;
    private final String outputPath;
    private boolean forceOutputOverrite;

    public WordCount(String name, Props props) {
        super(name, props);
        this.inputPath = props.getString("input.path");
        this.outputPath = props.getString("output.path");
        this.forceOutputOverrite = props.getBoolean("force.output.overwrite", false);
    }

    public void run() throws Exception {
        logger.info((Object)String.format("Starting %s", ((Object)((Object)this)).getClass().getSimpleName()));
        JobConf jobconf = this.getJobConf();
        jobconf.setJarByClass(WordCount.class);
        jobconf.setOutputKeyClass(Text.class);
        jobconf.setOutputValueClass(IntWritable.class);
        jobconf.setMapperClass(Map.class);
        jobconf.setReducerClass(Reduce.class);
        jobconf.setInputFormat(TextInputFormat.class);
        jobconf.setOutputFormat(TextOutputFormat.class);
        FileInputFormat.addInputPath((JobConf)jobconf, (Path)new Path(this.inputPath));
        FileOutputFormat.setOutputPath((JobConf)jobconf, (Path)new Path(this.outputPath));
        if (this.forceOutputOverrite) {
            FileSystem fs = FileOutputFormat.getOutputPath((JobConf)jobconf).getFileSystem((Configuration)jobconf);
            fs.delete(FileOutputFormat.getOutputPath((JobConf)jobconf), true);
        }
        super.run();
    }

    public static class Map
    extends MapReduceBase
    implements Mapper<LongWritable, Text, Text, IntWritable> {
        private static final IntWritable one = new IntWritable(1);
        private Text word = new Text();
        private long numRecords = 0L;

        public void map(LongWritable key, Text value, OutputCollector<Text, IntWritable> output, Reporter reporter) throws IOException {
            String line = value.toString();
            StringTokenizer tokenizer = new StringTokenizer(line);
            while (tokenizer.hasMoreTokens()) {
                this.word.set(tokenizer.nextToken());
                output.collect((Object)this.word, (Object)one);
                reporter.incrCounter((Enum)Counters.INPUT_WORDS, 1L);
            }
            if (++this.numRecords % 100L == 0L) {
                reporter.setStatus("Finished processing " + this.numRecords + " records " + "from the input file");
            }
        }

        static enum Counters {
            INPUT_WORDS;

        }
    }

    public static class Reduce
    extends MapReduceBase
    implements Reducer<Text, IntWritable, Text, IntWritable> {
        public void reduce(Text key, Iterator<IntWritable> values, OutputCollector<Text, IntWritable> output, Reporter reporter) throws IOException {
            int sum = 0;
            while (values.hasNext()) {
                sum += values.next().get();
            }
            output.collect((Object)key, (Object)new IntWritable(sum));
        }
    }
}

