/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.executor;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Map;
import java.util.Properties;

public class SleepJavaJob {
    private boolean fail;
    private String seconds;
    private int attempts;
    private int currentAttempt;

    public SleepJavaJob(String id, Properties props) {
        this.setup(props);
    }

    public SleepJavaJob(String id, Map<String, String> parameters) {
        Properties properties = new Properties();
        properties.putAll(parameters);
        this.setup(properties);
    }

    private void setup(Properties props) {
        String failStr = (String)props.get("fail");
        this.fail = failStr != null && !failStr.equals("false");
        this.currentAttempt = props.containsKey("azkaban.job.attempt") ? Integer.parseInt((String)props.get("azkaban.job.attempt")) : 0;
        String attemptString = (String)props.get("passRetry");
        this.attempts = attemptString == null ? -1 : Integer.valueOf(attemptString);
        this.seconds = (String)props.get("seconds");
        if (this.fail) {
            System.out.println("Planning to fail after " + this.seconds + " seconds. Attempts left " + this.currentAttempt + " of " + this.attempts);
        } else {
            System.out.println("Planning to succeed after " + this.seconds + " seconds.");
        }
    }

    public static void main(String[] args) throws Exception {
        String propsFile = System.getenv("JOB_PROP_FILE");
        Properties prop = new Properties();
        prop.load(new BufferedReader(new FileReader(propsFile)));
        String jobName = System.getenv("JOB_NAME");
        SleepJavaJob job = new SleepJavaJob(jobName, prop);
        job.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        if (this.seconds == null) {
            throw new RuntimeException("Seconds not set");
        }
        int sec = Integer.parseInt(this.seconds);
        System.out.println("Sec " + sec);
        SleepJavaJob sleepJavaJob = this;
        synchronized (sleepJavaJob) {
            try {
                this.wait(sec * 1000);
            }
            catch (InterruptedException e) {
                System.out.println("Interrupted " + this.fail);
            }
        }
        if (this.fail && (this.attempts <= 0 || this.currentAttempt <= this.attempts)) {
            throw new Exception("I failed because I had to.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws Exception {
        System.out.println("Cancelled called on Sleep job");
        this.fail = true;
        SleepJavaJob sleepJavaJob = this;
        synchronized (sleepJavaJob) {
            this.notifyAll();
        }
    }
}

