/*
 * Decompiled with CFR 0.152.
 */
package azkaban.trigger;

import azkaban.trigger.TriggerAction;
import azkaban.trigger.TriggerException;
import azkaban.trigger.builtin.ExecuteFlowAction;
import azkaban.utils.Props;
import azkaban.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ActionTypeLoader {
    private static Logger logger = Logger.getLogger(ActionTypeLoader.class);
    public static final String DEFAULT_TRIGGER_ACTION_PLUGIN_DIR = "plugins/triggeractions";
    private static final String ACTIONTYPECONFFILE = "plugin.properties";
    private static final String COMMONCONFFILE = "common.properties";
    protected static Map<String, Class<? extends TriggerAction>> actionToClass = new HashMap<String, Class<? extends TriggerAction>>();

    public void init(Props props) throws TriggerException {
        this.loadBuiltinActions();
        this.loadPluginActions(props);
    }

    public synchronized void registerActionType(String type, Class<? extends TriggerAction> actionClass) {
        logger.info((Object)("Registering action " + type));
        if (!actionToClass.containsKey(type)) {
            actionToClass.put(type, actionClass);
        }
    }

    private void loadPluginActions(Props props) throws TriggerException {
        String checkerDir = props.getString("azkaban.trigger.action.plugin.dir", DEFAULT_TRIGGER_ACTION_PLUGIN_DIR);
        File pluginDir = new File(checkerDir);
        if (!(pluginDir.exists() && pluginDir.isDirectory() && pluginDir.canRead())) {
            logger.info((Object)"No trigger action plugins to load.");
            return;
        }
        logger.info((Object)("Loading plugin trigger actions from " + pluginDir));
        ClassLoader parentCl = this.getClass().getClassLoader();
        Props globalActionConf = null;
        File confFile = Utils.findFilefromDir(pluginDir, COMMONCONFFILE);
        try {
            globalActionConf = confFile != null ? new Props(null, confFile) : new Props();
        }
        catch (IOException e) {
            throw new TriggerException("Failed to get global properties." + e);
        }
        for (File dir : pluginDir.listFiles()) {
            if (!dir.isDirectory() || !dir.canRead()) continue;
            try {
                this.loadPluginTypes(globalActionConf, pluginDir, parentCl);
            }
            catch (Exception e) {
                logger.info((Object)("Plugin actions failed to load. " + e.getCause()));
                throw new TriggerException("Failed to load all trigger actions!", e);
            }
        }
    }

    private void loadPluginTypes(Props globalConf, File dir, ClassLoader parentCl) throws TriggerException {
        Props actionConf = null;
        File confFile = Utils.findFilefromDir(dir, ACTIONTYPECONFFILE);
        if (confFile == null) {
            logger.info((Object)("No action type found in " + dir.getAbsolutePath()));
            return;
        }
        try {
            actionConf = new Props(globalConf, confFile);
        }
        catch (IOException e) {
            throw new TriggerException("Failed to load config for the action type", e);
        }
        String actionName = dir.getName();
        String actionClass = actionConf.getString("action.class");
        ArrayList<URL> resources = new ArrayList<URL>();
        for (File f : dir.listFiles()) {
            try {
                if (!f.getName().endsWith(".jar")) continue;
                resources.add(f.toURI().toURL());
                logger.info((Object)("adding to classpath " + f.toURI().toURL()));
            }
            catch (MalformedURLException e) {
                throw new TriggerException(e);
            }
        }
        URLClassLoader actionCl = new URLClassLoader(resources.toArray(new URL[resources.size()]), parentCl);
        Class<?> clazz = null;
        try {
            clazz = actionCl.loadClass(actionClass);
            actionToClass.put(actionName, clazz);
        }
        catch (ClassNotFoundException e) {
            throw new TriggerException(e);
        }
        if (actionConf.getBoolean("need.init")) {
            try {
                Utils.invokeStaticMethod(actionCl, actionClass, "init", actionConf);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)("Failed to init the action type " + actionName));
                throw new TriggerException(e);
            }
        }
        logger.info((Object)("Loaded action type " + actionName + " " + actionClass));
    }

    private void loadBuiltinActions() {
        actionToClass.put("ExecuteFlowAction", ExecuteFlowAction.class);
        logger.info((Object)"Loaded ExecuteFlowAction type.");
    }

    public static void registerBuiltinActions(Map<String, Class<? extends TriggerAction>> builtinActions) {
        actionToClass.putAll(builtinActions);
        for (String type : builtinActions.keySet()) {
            logger.info((Object)("Loaded " + type + " action."));
        }
    }

    public TriggerAction createActionFromJson(String type, Object obj) throws Exception {
        TriggerAction action = null;
        Class<? extends TriggerAction> actionClass = actionToClass.get(type);
        if (actionClass == null) {
            throw new Exception("Action Type " + type + " not supported!");
        }
        action = (TriggerAction)Utils.invokeStaticMethod(actionClass.getClassLoader(), actionClass.getName(), "createFromJson", obj);
        return action;
    }

    public TriggerAction createAction(String type, Object ... args) {
        TriggerAction action = null;
        Class<? extends TriggerAction> actionClass = actionToClass.get(type);
        action = (TriggerAction)Utils.callConstructor(actionClass, args);
        return action;
    }

    public Set<String> getSupportedActions() {
        return actionToClass.keySet();
    }
}

