/*
 * Decompiled with CFR 0.152.
 */
package azkaban.webapp.session;

import azkaban.utils.Props;
import azkaban.webapp.session.Session;
import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;

public class SessionCache {
    private static final int MAX_NUM_SESSIONS = 10000;
    private static final int SESSION_TIME_TO_LIVE = 86400;
    private CacheManager manager = CacheManager.create();
    private Cache cache;

    public SessionCache(Props props) {
        System.setProperty("net.sf.ehcache.skipUpdateCheck", "true");
        CacheConfiguration config = new CacheConfiguration();
        config.setName("sessionCache");
        config.setMaxEntriesLocalHeap((long)props.getInt("max.num.sessions", 10000));
        config.setTimeToLiveSeconds((long)props.getInt("session.time.to.live", 86400));
        config.eternal(false);
        config.diskPersistent(false);
        config.memoryStoreEvictionPolicy(MemoryStoreEvictionPolicy.LRU);
        this.cache = new Cache(config);
        this.manager.addCache(this.cache);
    }

    public Session getSession(String sessionId) {
        Element elem = this.cache.get((Serializable)((Object)sessionId));
        if (elem == null) {
            return null;
        }
        return (Session)elem.getObjectValue();
    }

    public void addSession(Session session) {
        Element elem = new Element((Object)session.getSessionId(), (Object)session);
        this.cache.put(elem);
    }

    public boolean removeSession(String id) {
        return this.cache.remove((Serializable)((Object)id));
    }
}

