/*
 * Decompiled with CFR 0.152.
 */
package azkaban.execapp;

import azkaban.execapp.event.BlockingStatus;
import azkaban.execapp.event.Event;
import azkaban.execapp.event.EventHandler;
import azkaban.execapp.event.FlowWatcher;
import azkaban.executor.ExecutableFlowBase;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import azkaban.jobExecutor.Job;
import azkaban.jobtype.JobTypeManager;
import azkaban.jobtype.JobTypeManagerException;
import azkaban.utils.Props;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Appender;
import org.apache.log4j.EnhancedPatternLayout;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.RollingFileAppender;

/*
 * Exception performing whole class analysis ignored.
 */
public class JobRunner
extends EventHandler
implements Runnable {
    private final Layout DEFAULT_LAYOUT = new EnhancedPatternLayout("%d{dd-MM-yyyy HH:mm:ss z} %c{1} %p - %m\n");
    private ExecutorLoader loader;
    private Props props;
    private ExecutableNode node;
    private File workingDir;
    private Logger logger = null;
    private Layout loggerLayout = this.DEFAULT_LAYOUT;
    private Logger flowLogger = null;
    private Appender jobAppender;
    private File logFile;
    private String attachmentFileName;
    private Job job;
    private int executionId = -1;
    private String jobId;
    private static final Object logCreatorLock = new Object();
    private Object syncObject = new Object();
    private final JobTypeManager jobtypeManager;
    private Integer pipelineLevel = null;
    private FlowWatcher watcher = null;
    private Set<String> pipelineJobs = new HashSet();
    private Set<String> proxyUsers = null;
    private String jobLogChunkSize;
    private int jobLogBackupIndex;
    private long delayStartMs = 0L;
    private boolean killed = false;
    private BlockingStatus currentBlockStatus = null;

    public JobRunner(ExecutableNode node, File workingDir, ExecutorLoader loader, JobTypeManager jobtypeManager) {
        this.props = node.getInputProps();
        this.node = node;
        this.workingDir = workingDir;
        this.executionId = node.getParentFlow().getExecutionId();
        this.jobId = node.getId();
        this.loader = loader;
        this.jobtypeManager = jobtypeManager;
    }

    public void setValidatedProxyUsers(Set<String> proxyUsers) {
        this.proxyUsers = proxyUsers;
    }

    public void setLogSettings(Logger flowLogger, String logFileChuckSize, int numLogBackup) {
        this.flowLogger = flowLogger;
        this.jobLogChunkSize = logFileChuckSize;
        this.jobLogBackupIndex = numLogBackup;
    }

    public Props getProps() {
        return this.props;
    }

    public void setPipeline(FlowWatcher watcher, int pipelineLevel) {
        block5: {
            ExecutableFlowBase parentFlow;
            block6: {
                block4: {
                    this.watcher = watcher;
                    this.pipelineLevel = pipelineLevel;
                    if (this.pipelineLevel != 1) break block4;
                    this.pipelineJobs.add(this.node.getNestedId());
                    break block5;
                }
                if (this.pipelineLevel != 2) break block5;
                this.pipelineJobs.add(this.node.getNestedId());
                parentFlow = this.node.getParentFlow();
                if (!parentFlow.getEndNodes().contains(this.node.getId())) break block6;
                if (parentFlow.getOutNodes().isEmpty()) break block5;
                ExecutableFlowBase grandParentFlow = parentFlow.getParentFlow();
                for (String outNode : parentFlow.getOutNodes()) {
                    ExecutableNode nextNode = grandParentFlow.getExecutableNode(outNode);
                    if (nextNode instanceof ExecutableFlowBase) {
                        ExecutableFlowBase nextFlow = (ExecutableFlowBase)nextNode;
                        this.findAllStartingNodes(nextFlow, this.pipelineJobs);
                        continue;
                    }
                    this.pipelineJobs.add(nextNode.getNestedId());
                }
                break block5;
            }
            for (String outNode : this.node.getOutNodes()) {
                ExecutableNode nextNode = parentFlow.getExecutableNode(outNode);
                if (nextNode instanceof ExecutableFlowBase) {
                    ExecutableFlowBase nextFlow = (ExecutableFlowBase)nextNode;
                    this.findAllStartingNodes(nextFlow, this.pipelineJobs);
                    continue;
                }
                this.pipelineJobs.add(nextNode.getNestedId());
            }
        }
    }

    private void findAllStartingNodes(ExecutableFlowBase flow, Set<String> pipelineJobs) {
        for (String startingNode : flow.getStartNodes()) {
            ExecutableNode node = flow.getExecutableNode(startingNode);
            if (node instanceof ExecutableFlowBase) {
                this.findAllStartingNodes((ExecutableFlowBase)node, pipelineJobs);
                continue;
            }
            pipelineJobs.add(node.getNestedId());
        }
    }

    public Set<String> getPipelineWatchedJobs() {
        return this.pipelineJobs;
    }

    public void setDelayStart(long delayMS) {
        this.delayStartMs = delayMS;
    }

    public long getDelayStart() {
        return this.delayStartMs;
    }

    public ExecutableNode getNode() {
        return this.node;
    }

    public String getLogFilePath() {
        return this.logFile == null ? null : this.logFile.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLogger() {
        Object object = logCreatorLock;
        synchronized (object) {
            String loggerName = String.valueOf(System.currentTimeMillis()) + "." + this.executionId + "." + this.jobId;
            this.logger = Logger.getLogger((String)loggerName);
            String logName = JobRunner.createLogFileName((ExecutableNode)this.node);
            this.logFile = new File(this.workingDir, logName);
            String absolutePath = this.logFile.getAbsolutePath();
            this.jobAppender = null;
            try {
                RollingFileAppender fileAppender = new RollingFileAppender(this.loggerLayout, absolutePath, true);
                fileAppender.setMaxBackupIndex(this.jobLogBackupIndex);
                fileAppender.setMaxFileSize(this.jobLogChunkSize);
                this.jobAppender = fileAppender;
                this.logger.addAppender(this.jobAppender);
                this.logger.setAdditivity(false);
            }
            catch (IOException e) {
                this.flowLogger.error((Object)("Could not open log file in " + this.workingDir + " for job " + this.jobId), (Throwable)e);
            }
        }
    }

    private void createAttachmentFile() {
        String fileName = JobRunner.createAttachmentFileName((ExecutableNode)this.node);
        File file = new File(this.workingDir, fileName);
        this.attachmentFileName = file.getAbsolutePath();
    }

    private void closeLogger() {
        if (this.jobAppender != null) {
            this.logger.removeAppender(this.jobAppender);
            this.jobAppender.close();
        }
    }

    private void writeStatus() {
        try {
            this.node.setUpdateTime(System.currentTimeMillis());
            this.loader.updateExecutableNode(this.node);
        }
        catch (ExecutorManagerException e) {
            this.flowLogger.error((Object)("Could not update job properties in db for " + this.jobId), (Throwable)e);
        }
    }

    private boolean handleNonReadyStatus() {
        Status nodeStatus = this.node.getStatus();
        boolean quickFinish = false;
        long time = System.currentTimeMillis();
        if (Status.isStatusFinished((Status)nodeStatus)) {
            quickFinish = true;
        } else if (nodeStatus == Status.DISABLED) {
            this.changeStatus(Status.SKIPPED, time);
            quickFinish = true;
        } else if (this.isKilled()) {
            this.changeStatus(Status.KILLED, time);
            quickFinish = true;
        }
        if (quickFinish) {
            this.node.setStartTime(time);
            this.fireEvent(Event.create((Object)this, (Event.Type)Event.Type.JOB_STARTED, null, (boolean)false));
            this.node.setEndTime(time);
            this.fireEvent(Event.create((Object)this, (Event.Type)Event.Type.JOB_FINISHED));
            return true;
        }
        return false;
    }

    private boolean blockOnPipeLine() {
        if (this.isKilled()) {
            return true;
        }
        if (!this.pipelineJobs.isEmpty()) {
            String blockedList = "";
            ArrayList<BlockingStatus> blockingStatus = new ArrayList<BlockingStatus>();
            for (String waitingJobId : this.pipelineJobs) {
                Status status = this.watcher.peekStatus(waitingJobId);
                if (status == null || Status.isStatusFinished((Status)status)) continue;
                BlockingStatus block = this.watcher.getBlockingStatus(waitingJobId);
                blockingStatus.add(block);
                blockedList = String.valueOf(blockedList) + waitingJobId + ",";
            }
            if (!blockingStatus.isEmpty()) {
                this.logger.info((Object)("Pipeline job " + this.jobId + " waiting on " + blockedList + " in execution " + this.watcher.getExecId()));
                for (BlockingStatus bStatus : blockingStatus) {
                    this.logger.info((Object)("Waiting on pipelined job " + bStatus.getJobId()));
                    this.currentBlockStatus = bStatus;
                    bStatus.blockOnFinishedStatus();
                    if (this.isKilled()) {
                        this.logger.info((Object)"Job was killed while waiting on pipeline. Quiting.");
                        return true;
                    }
                    this.logger.info((Object)("Pipelined job " + bStatus.getJobId() + " finished."));
                }
            }
        }
        this.currentBlockStatus = null;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean delayExecution() {
        if (this.isKilled()) {
            return true;
        }
        long currentTime = System.currentTimeMillis();
        if (this.delayStartMs > 0L) {
            this.logger.info((Object)("Delaying start of execution for " + this.delayStartMs + " milliseconds."));
            JobRunner jobRunner = this;
            synchronized (jobRunner) {
                try {
                    this.wait(this.delayStartMs);
                    this.logger.info((Object)("Execution has been delayed for " + this.delayStartMs + " ms. Continuing with execution."));
                }
                catch (InterruptedException e) {
                    this.logger.error((Object)("Job " + this.jobId + " was to be delayed for " + this.delayStartMs + ". Interrupted after " + (System.currentTimeMillis() - currentTime)));
                }
            }
            if (this.isKilled()) {
                this.logger.info((Object)"Job was killed while in delay. Quiting.");
                return true;
            }
        }
        return false;
    }

    private void finalizeLogFile() {
        this.closeLogger();
        if (this.logFile == null) {
            this.flowLogger.info((Object)("Log file for job " + this.jobId + " is null"));
            return;
        }
        try {
            File[] files = this.logFile.getParentFile().listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
            Arrays.sort(files, Collections.reverseOrder());
            this.loader.uploadLogFile(this.executionId, this.node.getNestedId(), this.node.getAttempt(), files);
        }
        catch (ExecutorManagerException e) {
            this.flowLogger.error((Object)("Error writing out logs for job " + this.node.getNestedId()), (Throwable)e);
        }
    }

    private void finalizeAttachmentFile() {
        if (this.attachmentFileName == null) {
            this.flowLogger.info((Object)("Attachment file for job " + this.jobId + " is null"));
            return;
        }
        try {
            File file = new File(this.attachmentFileName);
            if (!file.exists()) {
                this.flowLogger.info((Object)("No attachment file for job " + this.jobId + " written."));
                return;
            }
            this.loader.uploadAttachmentFile(this.node, file);
        }
        catch (ExecutorManagerException e) {
            this.flowLogger.error((Object)("Error writing out attachment for job " + this.node.getNestedId()), (Throwable)e);
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setName("JobRunner-" + this.jobId + "-" + this.executionId);
        if (this.handleNonReadyStatus()) {
            return;
        }
        this.createAttachmentFile();
        this.createLogger();
        boolean errorFound = false;
        errorFound |= this.delayExecution();
        this.node.setStartTime(System.currentTimeMillis());
        if (!(errorFound |= this.blockOnPipeLine()) && !this.isKilled()) {
            this.fireEvent(Event.create((Object)this, (Event.Type)Event.Type.JOB_STARTED, null, (boolean)false));
            try {
                this.loader.uploadExecutableNode(this.node, this.props);
            }
            catch (ExecutorManagerException e1) {
                this.logger.error((Object)"Error writing initial node properties");
            }
            if (this.prepareJob()) {
                this.writeStatus();
                this.fireEvent(Event.create((Object)this, (Event.Type)Event.Type.JOB_STATUS_CHANGED), false);
                this.runJob();
            } else {
                this.changeStatus(Status.FAILED);
                this.logError("Job run failed preparing the job.");
            }
        }
        this.node.setEndTime(System.currentTimeMillis());
        if (this.isKilled()) {
            this.changeStatus(Status.KILLED);
        }
        this.logInfo("Finishing job " + this.jobId + " at " + this.node.getEndTime() + " with status " + this.node.getStatus());
        this.fireEvent(Event.create((Object)this, (Event.Type)Event.Type.JOB_FINISHED), false);
        this.finalizeLogFile();
        this.finalizeAttachmentFile();
        this.writeStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareJob() throws RuntimeException {
        if (this.props == null || this.isKilled()) {
            this.logError("Failing job. The job properties don't exist");
            return false;
        }
        Object object = this.syncObject;
        synchronized (object) {
            block14: {
                block13: {
                    if (this.node.getStatus() != Status.FAILED && !this.isKilled()) break block13;
                    return false;
                }
                if (this.node.getAttempt() > 0) {
                    this.logInfo("Starting job " + this.jobId + " attempt " + this.node.getAttempt() + " at " + this.node.getStartTime());
                } else {
                    this.logInfo("Starting job " + this.jobId + " at " + this.node.getStartTime());
                }
                if (this.node.getExecutableFlow() != this.node.getParentFlow()) {
                    String subFlow = this.node.getPrintableId(":");
                    this.props.put("azkaban.flow.nested.path", subFlow);
                }
                this.props.put("azkaban.job.attempt", Integer.valueOf(this.node.getAttempt()));
                this.props.put("azkaban.job.metadata.file", JobRunner.createMetaDataFileName((ExecutableNode)this.node));
                this.props.put("azkaban.job.attachment.file", this.attachmentFileName);
                this.changeStatus(Status.RUNNING);
                if (!this.props.containsKey((Object)"working.dir")) {
                    this.props.put("working.dir", this.workingDir.getAbsolutePath());
                }
                if (!this.props.containsKey((Object)"user.to.proxy")) break block14;
                String jobProxyUser = this.props.getString("user.to.proxy");
                if (this.proxyUsers == null || this.proxyUsers.contains(jobProxyUser)) break block14;
                this.logger.error((Object)("User " + jobProxyUser + " has no permission to execute this job " + this.jobId + "!"));
                return false;
            }
            try {
                this.job = this.jobtypeManager.buildJobExecutor(this.jobId, this.props, this.logger);
            }
            catch (JobTypeManagerException e) {
                this.logger.error((Object)"Failed to build job type");
                return false;
            }
        }
        return true;
    }

    private void runJob() {
        try {
            this.job.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.props.getBoolean("job.succeed.on.failure", false)) {
                this.changeStatus(Status.FAILED_SUCCEEDED);
                this.logError("Job run failed, but will treat it like success.");
                this.logError(String.valueOf(e.getMessage()) + e.getCause());
            }
            this.changeStatus(Status.FAILED);
            this.logError("Job run failed!");
            this.logError(String.valueOf(e.getMessage()) + e.getCause());
        }
        if (this.job != null) {
            this.node.setOutputProps(this.job.getJobGeneratedProperties());
        }
        if (!Status.isStatusFinished((Status)this.node.getStatus())) {
            this.changeStatus(Status.SUCCEEDED);
        }
    }

    private void changeStatus(Status status) {
        this.changeStatus(status, System.currentTimeMillis());
    }

    private void changeStatus(Status status, long time) {
        this.node.setStatus(status);
        this.node.setUpdateTime(time);
    }

    private void fireEvent(Event event) {
        this.fireEvent(event, true);
    }

    private void fireEvent(Event event, boolean updateTime) {
        if (updateTime) {
            this.node.setUpdateTime(System.currentTimeMillis());
        }
        this.fireEventListeners(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        Object object = this.syncObject;
        synchronized (object) {
            if (Status.isStatusFinished((Status)this.node.getStatus())) {
                return;
            }
            this.logError("Kill has been called.");
            this.killed = true;
            BlockingStatus status = this.currentBlockStatus;
            if (status != null) {
                status.unblock();
            }
            if (this.job == null) {
                this.logError("Job hasn't started yet.");
                JobRunner jobRunner = this;
                synchronized (jobRunner) {
                    this.notify();
                }
                return;
            }
            try {
                this.job.cancel();
            }
            catch (Exception e) {
                this.logError(e.getMessage());
                this.logError("Failed trying to cancel job. Maybe it hasn't started running yet or just finished.");
            }
            this.changeStatus(Status.KILLED);
        }
    }

    public boolean isKilled() {
        return this.killed;
    }

    public Status getStatus() {
        return this.node.getStatus();
    }

    private void logError(String message) {
        if (this.logger != null) {
            this.logger.error((Object)message);
        }
    }

    private void logInfo(String message) {
        if (this.logger != null) {
            this.logger.info((Object)message);
        }
    }

    public File getLogFile() {
        return this.logFile;
    }

    public static String createLogFileName(ExecutableNode node, int attempt) {
        int executionId = node.getExecutableFlow().getExecutionId();
        String jobId = node.getId();
        if (node.getExecutableFlow() != node.getParentFlow()) {
            jobId = node.getPrintableId("._.");
        }
        return attempt > 0 ? "_job." + executionId + "." + attempt + "." + jobId + ".log" : "_job." + executionId + "." + jobId + ".log";
    }

    public static String createLogFileName(ExecutableNode node) {
        return JobRunner.createLogFileName((ExecutableNode)node, (int)node.getAttempt());
    }

    public static String createMetaDataFileName(ExecutableNode node, int attempt) {
        int executionId = node.getExecutableFlow().getExecutionId();
        String jobId = node.getId();
        if (node.getExecutableFlow() != node.getParentFlow()) {
            jobId = node.getPrintableId("._.");
        }
        return attempt > 0 ? "_job." + executionId + "." + attempt + "." + jobId + ".meta" : "_job." + executionId + "." + jobId + ".meta";
    }

    public static String createMetaDataFileName(ExecutableNode node) {
        return JobRunner.createMetaDataFileName((ExecutableNode)node, (int)node.getAttempt());
    }

    public static String createAttachmentFileName(ExecutableNode node) {
        return JobRunner.createAttachmentFileName((ExecutableNode)node, (int)node.getAttempt());
    }

    public static String createAttachmentFileName(ExecutableNode node, int attempt) {
        int executionId = node.getExecutableFlow().getExecutionId();
        String jobId = node.getId();
        if (node.getExecutableFlow() != node.getParentFlow()) {
            jobId = node.getPrintableId("._.");
        }
        return attempt > 0 ? "_job." + executionId + "." + attempt + "." + jobId + ".attach" : "_job." + executionId + "." + jobId + ".attach";
    }

    static /* synthetic */ File access$0(JobRunner jobRunner) {
        return jobRunner.logFile;
    }
}

