/*
 * Decompiled with CFR 0.152.
 */
package azkaban.scheduler;

import azkaban.database.AbstractJdbcLoader;
import azkaban.scheduler.Schedule;
import azkaban.scheduler.ScheduleLoader;
import azkaban.scheduler.ScheduleManagerException;
import azkaban.utils.GZIPUtils;
import azkaban.utils.JSONUtils;
import azkaban.utils.Props;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.log4j.Logger;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePeriod;

public class JdbcScheduleLoader
extends AbstractJdbcLoader
implements ScheduleLoader {
    private static Logger logger = Logger.getLogger(JdbcScheduleLoader.class);
    private AbstractJdbcLoader.EncodingType defaultEncodingType = AbstractJdbcLoader.EncodingType.GZIP;
    private static final String scheduleTableName = "schedules";
    private static String SELECT_ALL_SCHEDULES = "SELECT schedule_id, project_id, project_name, flow_name, status, first_sched_time, timezone, period, last_modify_time, next_exec_time, submit_time, submit_user, enc_type, schedule_options FROM schedules";
    private static String INSERT_SCHEDULE = "INSERT INTO schedules ( project_id, project_name, flow_name, status, first_sched_time, timezone, period, last_modify_time, next_exec_time, submit_time, submit_user, enc_type, schedule_options) values (?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static String REMOVE_SCHEDULE_BY_KEY = "DELETE FROM schedules WHERE schedule_id=?";
    private static String UPDATE_SCHEDULE_BY_KEY = "UPDATE schedules SET status=?, first_sched_time=?, timezone=?, period=?, last_modify_time=?, next_exec_time=?, submit_time=?, submit_user=?, enc_type=?, schedule_options=? WHERE schedule_id=?";
    private static String UPDATE_NEXT_EXEC_TIME = "UPDATE schedules SET next_exec_time=? WHERE schedule_id=?";

    public AbstractJdbcLoader.EncodingType getDefaultEncodingType() {
        return this.defaultEncodingType;
    }

    public void setDefaultEncodingType(AbstractJdbcLoader.EncodingType defaultEncodingType) {
        this.defaultEncodingType = defaultEncodingType;
    }

    public JdbcScheduleLoader(Props props) {
        super(props);
    }

    @Override
    public List<Schedule> loadSchedules() throws ScheduleManagerException {
        List schedules;
        logger.info((Object)"Loading all schedules from db.");
        Connection connection = this.getConnection();
        QueryRunner runner = new QueryRunner();
        ScheduleResultHandler handler = new ScheduleResultHandler();
        try {
            schedules = (List)runner.query(connection, SELECT_ALL_SCHEDULES, (ResultSetHandler)handler);
        }
        catch (SQLException e) {
            logger.error((Object)(SELECT_ALL_SCHEDULES + " failed."));
            throw new ScheduleManagerException("Loading schedules from db failed. ", e);
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
        logger.info((Object)"Now trying to update the schedules");
        for (Schedule sched : schedules) {
            if (!sched.updateTime()) {
                logger.info((Object)("Schedule " + sched.getScheduleName() + " was scheduled before azkaban start, skipping it."));
                schedules.remove(sched);
                this.removeSchedule(sched);
                continue;
            }
            logger.info((Object)"Recurring schedule, need to update next exec time");
            try {
                this.updateNextExecTime(sched);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ScheduleManagerException("Update next execution time failed.", e);
            }
            logger.info((Object)("Schedule " + sched.getScheduleName() + " loaded and updated."));
        }
        logger.info((Object)("Loaded " + schedules.size() + " schedules."));
        return schedules;
    }

    @Override
    public void removeSchedule(Schedule s) throws ScheduleManagerException {
        logger.info((Object)("Removing schedule " + s.getScheduleName() + " from db."));
        QueryRunner runner = this.createQueryRunner();
        try {
            int removes = runner.update(REMOVE_SCHEDULE_BY_KEY, (Object)s.getScheduleId());
            if (removes == 0) {
                throw new ScheduleManagerException("No schedule has been removed.");
            }
        }
        catch (SQLException e) {
            logger.error((Object)(REMOVE_SCHEDULE_BY_KEY + " failed."));
            throw new ScheduleManagerException("Remove schedule " + s.getScheduleName() + " from db failed. ", e);
        }
    }

    @Override
    public void insertSchedule(Schedule s) throws ScheduleManagerException {
        logger.info((Object)("Inserting schedule " + s.getScheduleName() + " into db."));
        this.insertSchedule(s, this.defaultEncodingType);
    }

    public void insertSchedule(Schedule s, AbstractJdbcLoader.EncodingType encType) throws ScheduleManagerException {
        String json = JSONUtils.toJSON(s.optionsToObject());
        byte[] data = null;
        try {
            byte[] stringData;
            data = stringData = json.getBytes("UTF-8");
            if (encType == AbstractJdbcLoader.EncodingType.GZIP) {
                data = GZIPUtils.gzipBytes(stringData);
            }
            logger.debug((Object)("NumChars: " + json.length() + " UTF-8:" + stringData.length + " Gzip:" + data.length));
        }
        catch (IOException e) {
            throw new ScheduleManagerException("Error encoding the schedule options. " + s.getScheduleName());
        }
        QueryRunner runner = this.createQueryRunner();
        try {
            int inserts = runner.update(INSERT_SCHEDULE, new Object[]{s.getProjectId(), s.getProjectName(), s.getFlowName(), s.getStatus(), s.getFirstSchedTime(), s.getTimezone().getID(), Schedule.createPeriodString(s.getPeriod()), s.getLastModifyTime(), s.getNextExecTime(), s.getSubmitTime(), s.getSubmitUser(), encType.getNumVal(), data});
            long id = (Long)runner.query(LastInsertID.LAST_INSERT_ID, (ResultSetHandler)new LastInsertID());
            if (id == -1L) {
                throw new ScheduleManagerException("Execution id is not properly created.");
            }
            logger.info((Object)("Schedule given " + s.getScheduleIdentityPair() + " given id " + id));
            s.setScheduleId((int)id);
            if (inserts == 0) {
                throw new ScheduleManagerException("No schedule has been inserted.");
            }
        }
        catch (SQLException e) {
            logger.error((Object)(INSERT_SCHEDULE + " failed."));
            throw new ScheduleManagerException("Insert schedule " + s.getScheduleName() + " into db failed. ", e);
        }
    }

    @Override
    public void updateNextExecTime(Schedule s) throws ScheduleManagerException {
        logger.info((Object)("Update schedule " + s.getScheduleName() + " into db. "));
        Connection connection = this.getConnection();
        QueryRunner runner = new QueryRunner();
        try {
            runner.update(connection, UPDATE_NEXT_EXEC_TIME, new Object[]{s.getNextExecTime(), s.getScheduleId()});
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)(UPDATE_NEXT_EXEC_TIME + " failed."), (Throwable)e);
            throw new ScheduleManagerException("Update schedule " + s.getScheduleName() + " into db failed. ", e);
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
    }

    @Override
    public void updateSchedule(Schedule s) throws ScheduleManagerException {
        logger.info((Object)("Updating schedule " + s.getScheduleName() + " into db."));
        this.updateSchedule(s, this.defaultEncodingType);
    }

    public void updateSchedule(Schedule s, AbstractJdbcLoader.EncodingType encType) throws ScheduleManagerException {
        String json = JSONUtils.toJSON(s.optionsToObject());
        byte[] data = null;
        try {
            byte[] stringData;
            data = stringData = json.getBytes("UTF-8");
            if (encType == AbstractJdbcLoader.EncodingType.GZIP) {
                data = GZIPUtils.gzipBytes(stringData);
            }
            logger.debug((Object)("NumChars: " + json.length() + " UTF-8:" + stringData.length + " Gzip:" + data.length));
        }
        catch (IOException e) {
            throw new ScheduleManagerException("Error encoding the schedule options " + s.getScheduleName());
        }
        QueryRunner runner = this.createQueryRunner();
        try {
            int updates = runner.update(UPDATE_SCHEDULE_BY_KEY, new Object[]{s.getStatus(), s.getFirstSchedTime(), s.getTimezone().getID(), Schedule.createPeriodString(s.getPeriod()), s.getLastModifyTime(), s.getNextExecTime(), s.getSubmitTime(), s.getSubmitUser(), encType.getNumVal(), data, s.getScheduleId()});
            if (updates == 0) {
                throw new ScheduleManagerException("No schedule has been updated.");
            }
        }
        catch (SQLException e) {
            logger.error((Object)(UPDATE_SCHEDULE_BY_KEY + " failed."));
            throw new ScheduleManagerException("Update schedule " + s.getScheduleName() + " into db failed. ", e);
        }
    }

    private Connection getConnection() throws ScheduleManagerException {
        Connection connection = null;
        try {
            connection = super.getDBConnection(false);
        }
        catch (Exception e) {
            DbUtils.closeQuietly((Connection)connection);
            throw new ScheduleManagerException("Error getting DB connection.", e);
        }
        return connection;
    }

    @Override
    public List<Schedule> loadUpdatedSchedules() throws ScheduleManagerException {
        throw new ScheduleManagerException("Should never be called when using local schedule runner");
    }

    public class ScheduleResultHandler
    implements ResultSetHandler<List<Schedule>> {
        public List<Schedule> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            ArrayList<Schedule> schedules = new ArrayList<Schedule>();
            do {
                int scheduleId = rs.getInt(1);
                int projectId = rs.getInt(2);
                String projectName = rs.getString(3);
                String flowName = rs.getString(4);
                String status = rs.getString(5);
                long firstSchedTime = rs.getLong(6);
                DateTimeZone timezone = DateTimeZone.forID((String)rs.getString(7));
                ReadablePeriod period = Schedule.parsePeriodString(rs.getString(8));
                long lastModifyTime = rs.getLong(9);
                long nextExecTime = rs.getLong(10);
                long submitTime = rs.getLong(11);
                String submitUser = rs.getString(12);
                int encodingType = rs.getInt(13);
                byte[] data = rs.getBytes(14);
                Object optsObj = null;
                if (data != null) {
                    AbstractJdbcLoader.EncodingType encType = AbstractJdbcLoader.EncodingType.fromInteger(encodingType);
                    try {
                        String jsonString;
                        if (encType == AbstractJdbcLoader.EncodingType.GZIP) {
                            jsonString = GZIPUtils.unGzipString(data, "UTF-8");
                            optsObj = JSONUtils.parseJSONFromString(jsonString);
                        } else {
                            jsonString = new String(data, "UTF-8");
                            optsObj = JSONUtils.parseJSONFromString(jsonString);
                        }
                    }
                    catch (IOException e) {
                        throw new SQLException("Error reconstructing schedule options " + projectName + "." + flowName);
                    }
                }
                Schedule s = new Schedule(scheduleId, projectId, projectName, flowName, status, firstSchedTime, timezone, period, lastModifyTime, nextExecTime, submitTime, submitUser);
                if (optsObj != null) {
                    s.createAndSetScheduleOptions(optsObj);
                }
                schedules.add(s);
            } while (rs.next());
            return schedules;
        }
    }

    private static class LastInsertID
    implements ResultSetHandler<Long> {
        private static String LAST_INSERT_ID = "SELECT LAST_INSERT_ID()";

        private LastInsertID() {
        }

        public Long handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return -1L;
            }
            long id = rs.getLong(1);
            return id;
        }
    }
}

