/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.ehcache.Element;
import net.sf.ehcache.transaction.ReadCommittedSoftLockImpl;
import net.sf.ehcache.transaction.SoftLock;
import net.sf.ehcache.transaction.SoftLockFactory;
import net.sf.ehcache.transaction.TransactionID;
import net.sf.ehcache.transaction.local.LocalTransactionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadCommittedSoftLockFactoryImpl
implements SoftLockFactory {
    private static final Object MARKER = new Object();
    private final String cacheManagerName;
    private final String cacheName;
    private final ConcurrentMap<ReadCommittedSoftLockImpl, Object> newKeyLocks = new ConcurrentHashMap<ReadCommittedSoftLockImpl, Object>();
    private final ConcurrentMap<ReadCommittedSoftLockImpl, Object> allLocks = new ConcurrentHashMap<ReadCommittedSoftLockImpl, Object>();

    public ReadCommittedSoftLockFactoryImpl(String cacheManagerName, String cacheName) {
        this.cacheManagerName = cacheManagerName;
        this.cacheName = cacheName;
    }

    String getCacheManagerName() {
        return this.cacheManagerName;
    }

    String getCacheName() {
        return this.cacheName;
    }

    @Override
    public SoftLock createSoftLock(TransactionID transactionID, Object key, Element newElement, Element oldElement, boolean pinned) {
        ReadCommittedSoftLockImpl softLock = new ReadCommittedSoftLockImpl(this, transactionID, key, newElement, oldElement, pinned);
        this.allLocks.put(softLock, MARKER);
        if (oldElement == null) {
            this.newKeyLocks.put(softLock, MARKER);
        }
        return softLock;
    }

    ReadCommittedSoftLockImpl getLock(TransactionID transactionId, Object key) {
        for (ReadCommittedSoftLockImpl readCommittedSoftLock : this.allLocks.keySet()) {
            if (!readCommittedSoftLock.getTransactionID().equals(transactionId) || !readCommittedSoftLock.getKey().equals(key)) continue;
            return readCommittedSoftLock;
        }
        return null;
    }

    @Override
    public Set<Object> getKeysInvisibleInContext(LocalTransactionContext currentTransactionContext) {
        HashSet<Object> invisibleKeys = new HashSet<Object>();
        invisibleKeys.addAll(this.getNewKeys());
        List<SoftLock> currentTransactionContextSoftLocks = currentTransactionContext.getSoftLocksForCache(this.cacheName);
        for (SoftLock softLock : currentTransactionContextSoftLocks) {
            if (softLock.getElement(currentTransactionContext.getTransactionId()) == null) {
                invisibleKeys.add(softLock.getKey());
                continue;
            }
            invisibleKeys.remove(softLock.getKey());
        }
        return invisibleKeys;
    }

    @Override
    public Set<TransactionID> collectExpiredTransactionIDs() {
        HashSet<TransactionID> result = new HashSet<TransactionID>();
        for (ReadCommittedSoftLockImpl softLock : this.allLocks.keySet()) {
            if (!softLock.isExpired()) continue;
            result.add(softLock.getTransactionID());
        }
        return result;
    }

    @Override
    public Set<SoftLock> collectAllSoftLocksForTransactionID(TransactionID transactionID) {
        HashSet<SoftLock> result = new HashSet<SoftLock>();
        for (ReadCommittedSoftLockImpl softLock : this.allLocks.keySet()) {
            if (!softLock.getTransactionID().equals(transactionID)) continue;
            result.add(softLock);
        }
        return result;
    }

    void clearSoftLock(ReadCommittedSoftLockImpl softLock) {
        this.newKeyLocks.remove(softLock);
        this.allLocks.remove(softLock);
    }

    private Set<Object> getNewKeys() {
        HashSet<Object> result = new HashSet<Object>();
        for (ReadCommittedSoftLockImpl softLock : this.newKeyLocks.keySet()) {
            result.add(softLock.getKey());
        }
        return result;
    }
}

