/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators;

import org.apache.pig.PigWarning;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.BinaryExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Divide
extends BinaryExpressionOperator {
    private static final long serialVersionUID = 1L;

    public Divide(OperatorKey k) {
        super(k);
    }

    public Divide(OperatorKey k, int rp) {
        super(k, rp);
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitDivide(this);
    }

    @Override
    public String name() {
        return "Divide[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    protected <T extends Number> T divide(T a, T b, byte dataType) throws ExecException {
        switch (dataType) {
            case 25: {
                return (T)Double.valueOf((Double)a / (Double)b);
            }
            case 10: {
                return (T)Integer.valueOf((Integer)a / (Integer)b);
            }
            case 15: {
                return (T)Long.valueOf((Long)a / (Long)b);
            }
            case 20: {
                return (T)Float.valueOf(((Float)a).floatValue() / ((Float)b).floatValue());
            }
        }
        throw new ExecException("called on unsupported Number class " + DataType.findTypeName(dataType));
    }

    protected <T extends Number> boolean equalsZero(T a, byte dataType) throws ExecException {
        switch (dataType) {
            case 25: {
                return ((Double)a).equals(0.0);
            }
            case 10: {
                return ((Integer)a).equals(0);
            }
            case 15: {
                return ((Long)a).equals(0L);
            }
            case 20: {
                return ((Float)a).equals(Float.valueOf(0.0f));
            }
        }
        throw new ExecException("Called on unsupported Number class " + DataType.findTypeName(dataType));
    }

    protected <T extends Number> Result genericGetNext(T number, byte dataType) throws ExecException {
        Result r = this.accumChild(null, number, dataType);
        if (r != null) {
            return r;
        }
        Number left = null;
        Number right = null;
        Result res = this.lhs.getNext(left, dataType);
        byte status = res.returnStatus;
        if (status != 0 || res.result == null) {
            return res;
        }
        left = (Number)res.result;
        res = this.rhs.getNext(right, dataType);
        status = res.returnStatus;
        if (status != 0 || res.result == null) {
            return res;
        }
        right = (Number)res.result;
        if (this.equalsZero(right, dataType)) {
            if (pigLogger != null) {
                pigLogger.warn(this, "Divide by zero. Converting it to NULL.", PigWarning.DIVIDE_BY_ZERO);
            }
            res.result = null;
        } else {
            res.result = this.divide(left, right, dataType);
        }
        return res;
    }

    @Override
    public Result getNext(Double d) throws ExecException {
        return this.genericGetNext(d, (byte)25);
    }

    @Override
    public Result getNext(Float f) throws ExecException {
        return this.genericGetNext(f, (byte)20);
    }

    @Override
    public Result getNext(Integer i) throws ExecException {
        return this.genericGetNext(i, (byte)10);
    }

    @Override
    public Result getNext(Long l) throws ExecException {
        return this.genericGetNext(l, (byte)15);
    }

    @Override
    public Divide clone() throws CloneNotSupportedException {
        Divide clone = new Divide(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)));
        clone.cloneHelper(this);
        return clone;
    }
}

