/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.util.Arrays;
import org.apache.hadoop.util.RunJar;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.JobCreationException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.RunJarSecurityManager;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROpPlanVisitor;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.PigStatsUtil;

public class NativeMapReduceOper
extends MapReduceOper {
    private static final long serialVersionUID = 1L;
    private static int countJobs = 0;
    private String nativeMRJar;
    private String[] params;

    public NativeMapReduceOper(OperatorKey k, String mrJar, String[] parameters) {
        super(k);
        this.nativeMRJar = mrJar;
        this.params = parameters;
    }

    public static int getJobNumber() {
        return ++countJobs;
    }

    public String getJobId() {
        return this.nativeMRJar + "_";
    }

    public String getCommandString() {
        StringBuilder sb = new StringBuilder("hadoop jar ");
        sb.append(this.nativeMRJar);
        for (String pr : this.params) {
            sb.append(" ");
            sb.append(pr);
        }
        return sb.toString();
    }

    private String[] getNativeMRParams() {
        String[] paramArr = new String[this.params.length + 1];
        paramArr[0] = this.nativeMRJar;
        for (int i = 0; i < this.params.length; ++i) {
            paramArr[i + 1] = this.params[i];
        }
        return paramArr;
    }

    public void visit(MROpPlanVisitor v) throws VisitorException {
        v.visitMROp(this);
    }

    public void runJob() throws JobCreationException {
        RunJarSecurityManager secMan = new RunJarSecurityManager();
        try {
            RunJar.main((String[])this.getNativeMRParams());
            PigStatsUtil.addNativeJobStats(PigStats.get(), this, true);
        }
        catch (SecurityException se) {
            if (secMan.getExitInvoked()) {
                if (secMan.getExitCode() != 0) {
                    throw new JobCreationException("Native job returned with non-zero return code");
                }
                PigStatsUtil.addNativeJobStats(PigStats.get(), this, true);
            }
        }
        catch (Throwable t) {
            JobCreationException e = new JobCreationException("Cannot run native mapreduce job " + t.getMessage(), t);
            PigStatsUtil.addNativeJobStats(PigStats.get(), this, false, e);
            throw e;
        }
        finally {
            secMan.retire();
        }
    }

    public String name() {
        return "MapReduce - " + this.mKey.toString() + "\n" + " Native MapReduce - jar : " + this.nativeMRJar + ", params: " + Arrays.toString(this.params);
    }
}

