/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class SplitterOutputStream
extends OutputStream {
    List<OutputStream> outputs;

    public SplitterOutputStream(OutputStream ... outputs) {
        this.outputs = new ArrayList(outputs.length);
        OutputStream[] outputStreamArray = outputs;
        int n = outputs.length;
        int n2 = 0;
        while (n2 < n) {
            OutputStream output = outputStreamArray[n2];
            this.outputs.add(output);
            ++n2;
        }
    }

    @Override
    public void write(int b) throws IOException {
        for (OutputStream output : this.outputs) {
            output.write(b);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        for (OutputStream output : this.outputs) {
            output.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (OutputStream output : this.outputs) {
            output.write(b, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        IOException exception = null;
        for (OutputStream output : this.outputs) {
            try {
                output.flush();
            }
            catch (IOException e) {
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public void close() throws IOException {
        IOException exception = null;
        for (OutputStream output : this.outputs) {
            try {
                output.close();
            }
            catch (IOException e) {
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

