/*
 * Decompiled with CFR 0.152.
 */
package azkaban.webapp.servlet;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutionOptions;
import azkaban.executor.ExecutorManager;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import azkaban.flow.Flow;
import azkaban.project.Project;
import azkaban.project.ProjectManager;
import azkaban.scheduler.Schedule;
import azkaban.scheduler.ScheduleManager;
import azkaban.user.Permission;
import azkaban.user.User;
import azkaban.utils.FileIOUtils;
import azkaban.webapp.AzkabanWebServer;
import azkaban.webapp.servlet.HttpRequestUtils;
import azkaban.webapp.servlet.LoginAbstractAzkabanServlet;
import azkaban.webapp.servlet.Page;
import azkaban.webapp.session.Session;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExecutorServlet
extends LoginAbstractAzkabanServlet {
    private static final long serialVersionUID = 1L;
    private ProjectManager projectManager;
    private ExecutorManager executorManager;
    private ScheduleManager scheduleManager;
    private ExecutorVelocityHelper velocityHelper;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        AzkabanWebServer server = (AzkabanWebServer)this.getApplication();
        this.projectManager = server.getProjectManager();
        this.executorManager = server.getExecutorManager();
        this.scheduleManager = server.getScheduleManager();
        this.velocityHelper = new ExecutorVelocityHelper();
    }

    @Override
    protected void handleGet(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        if (this.hasParam(req, "ajax")) {
            this.handleAJAXAction(req, resp, session);
        } else if (this.hasParam(req, "execid")) {
            if (this.hasParam(req, "job")) {
                this.handleExecutionJobPage(req, resp, session);
            } else {
                this.handleExecutionFlowPage(req, resp, session);
            }
        } else {
            this.handleExecutionsPage(req, resp, session);
        }
    }

    private void handleExecutionJobPage(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        Page page = this.newPage(req, resp, session, "azkaban/webapp/servlet/velocity/joblogpage.vm");
        User user = session.getUser();
        int execId = this.getIntParam(req, "execid");
        String jobId = this.getParam(req, "job");
        int attempt = this.getIntParam(req, "attempt", 0);
        page.add("execid", execId);
        page.add("jobid", jobId);
        page.add("attempt", attempt);
        ExecutableFlow flow = null;
        try {
            flow = this.executorManager.getExecutableFlow(execId);
            if (flow == null) {
                page.add("errorMsg", "Error loading executing flow " + execId + " not found.");
                page.render();
                return;
            }
        }
        catch (ExecutorManagerException e) {
            page.add("errorMsg", "Error loading executing flow: " + e.getMessage());
            page.render();
            return;
        }
        int projectId = flow.getProjectId();
        Project project = this.getProjectPageByPermission(page, projectId, user, Permission.Type.READ);
        if (project == null) {
            page.render();
            return;
        }
        page.add("projectName", project.getName());
        page.add("flowid", flow.getFlowId());
        page.render();
    }

    private void handleExecutionsPage(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        Page page = this.newPage(req, resp, session, "azkaban/webapp/servlet/velocity/executionspage.vm");
        List<ExecutableFlow> runningFlows = this.executorManager.getRunningFlows();
        page.add("runningFlows", runningFlows.isEmpty() ? null : runningFlows);
        List<ExecutableFlow> finishedFlows = this.executorManager.getRecentlyFinishedFlows();
        page.add("recentlyFinished", finishedFlows.isEmpty() ? null : finishedFlows);
        page.add("vmutils", this.velocityHelper);
        page.render();
    }

    private void handleExecutionFlowPage(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        Page page = this.newPage(req, resp, session, "azkaban/webapp/servlet/velocity/executingflowpage.vm");
        User user = session.getUser();
        int execId = this.getIntParam(req, "execid");
        page.add("execid", execId);
        ExecutableFlow flow = null;
        try {
            flow = this.executorManager.getExecutableFlow(execId);
            if (flow == null) {
                page.add("errorMsg", "Error loading executing flow " + execId + " not found.");
                page.render();
                return;
            }
        }
        catch (ExecutorManagerException e) {
            page.add("errorMsg", "Error loading executing flow: " + e.getMessage());
            page.render();
            return;
        }
        int projectId = flow.getProjectId();
        Project project = this.getProjectPageByPermission(page, projectId, user, Permission.Type.READ);
        if (project == null) {
            page.render();
            return;
        }
        page.add("projectId", project.getId());
        page.add("projectName", project.getName());
        page.add("flowid", flow.getFlowId());
        page.render();
    }

    protected Project getProjectPageByPermission(Page page, int projectId, User user, Permission.Type type) {
        Project project = this.projectManager.getProject(projectId);
        if (project == null) {
            page.add("errorMsg", "Project " + project + " not found.");
        } else if (!this.hasPermission(project, user, type)) {
            page.add("errorMsg", "User " + user.getUserId() + " doesn't have " + type.name() + " permissions on " + project.getName());
        } else {
            return project;
        }
        return null;
    }

    protected Project getProjectAjaxByPermission(Map<String, Object> ret, String projectName, User user, Permission.Type type) {
        Project project = this.projectManager.getProject(projectName);
        if (project == null) {
            ret.put("error", "Project '" + project + "' not found.");
        } else if (!this.hasPermission(project, user, type)) {
            ret.put("error", "User '" + user.getUserId() + "' doesn't have " + type.name() + " permissions on " + project.getName());
        } else {
            return project;
        }
        return null;
    }

    protected Project getProjectAjaxByPermission(Map<String, Object> ret, int projectId, User user, Permission.Type type) {
        Project project = this.projectManager.getProject(projectId);
        if (project == null) {
            ret.put("error", "Project '" + project + "' not found.");
        } else if (!this.hasPermission(project, user, type)) {
            ret.put("error", "User '" + user.getUserId() + "' doesn't have " + type.name() + " permissions on " + project.getName());
        } else {
            return project;
        }
        return null;
    }

    @Override
    protected void handlePost(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        if (this.hasParam(req, "ajax")) {
            this.handleAJAXAction(req, resp, session);
        }
    }

    private void handleAJAXAction(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String ajaxName = this.getParam(req, "ajax");
        if (this.hasParam(req, "execid")) {
            int execid = this.getIntParam(req, "execid");
            ExecutableFlow exFlow = null;
            try {
                exFlow = this.executorManager.getExecutableFlow(execid);
            }
            catch (ExecutorManagerException e) {
                ret.put("error", "Error fetching execution '" + execid + "': " + e.getMessage());
            }
            if (exFlow == null) {
                ret.put("error", "Cannot find execution '" + execid + "'");
            } else if (ajaxName.equals("fetchexecflow")) {
                this.ajaxFetchExecutableFlow(req, resp, ret, session.getUser(), exFlow);
            } else if (ajaxName.equals("fetchexecflowupdate")) {
                this.ajaxFetchExecutableFlowUpdate(req, resp, ret, session.getUser(), exFlow);
            } else if (ajaxName.equals("cancelFlow")) {
                this.ajaxCancelFlow(req, resp, ret, session.getUser(), exFlow);
            } else if (ajaxName.equals("restartFlow")) {
                this.ajaxRestartFlow(req, resp, ret, session.getUser(), exFlow);
            } else if (ajaxName.equals("pauseFlow")) {
                this.ajaxPauseFlow(req, resp, ret, session.getUser(), exFlow);
            } else if (ajaxName.equals("resumeFlow")) {
                this.ajaxResumeFlow(req, resp, ret, session.getUser(), exFlow);
            } else if (ajaxName.equals("fetchExecFlowLogs")) {
                this.ajaxFetchExecFlowLogs(req, resp, ret, session.getUser(), exFlow);
            } else if (ajaxName.equals("fetchExecJobLogs")) {
                this.ajaxFetchJobLogs(req, resp, ret, session.getUser(), exFlow);
            } else if (ajaxName.equals("retryFailedJobs")) {
                this.ajaxRestartFailed(req, resp, ret, session.getUser(), exFlow);
            } else if (ajaxName.equals("flowInfo")) {
                this.ajaxFetchExecutableFlowInfo(req, resp, ret, session.getUser(), exFlow);
            }
        } else if (ajaxName.equals("getRunning")) {
            String projectName = this.getParam(req, "project");
            String flowName = this.getParam(req, "flow");
            this.ajaxGetFlowRunning(req, resp, ret, session.getUser(), projectName, flowName);
        } else if (ajaxName.equals("flowInfo")) {
            String projectName = this.getParam(req, "project");
            String flowName = this.getParam(req, "flow");
            this.ajaxFetchFlowInfo(req, resp, ret, session.getUser(), projectName, flowName);
        } else {
            String projectName = this.getParam(req, "project");
            ret.put("project", projectName);
            if (ajaxName.equals("executeFlow")) {
                this.ajaxAttemptExecuteFlow(req, resp, ret, session.getUser());
            }
        }
        if (ret != null) {
            this.writeJSON(resp, ret);
        }
    }

    private void ajaxRestartFailed(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user, ExecutableFlow exFlow) throws ServletException {
        Project project = this.getProjectAjaxByPermission(ret, exFlow.getProjectId(), user, Permission.Type.EXECUTE);
        if (project == null) {
            return;
        }
        if (exFlow.getStatus() == Status.FAILED || exFlow.getStatus() == Status.SUCCEEDED) {
            ret.put("error", "Flow has already finished. Please re-execute.");
            return;
        }
        try {
            this.executorManager.retryFailures(exFlow, user.getUserId());
        }
        catch (ExecutorManagerException e) {
            ret.put("error", e.getMessage());
        }
    }

    private void ajaxFetchExecFlowLogs(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user, ExecutableFlow exFlow) throws ServletException {
        Project project = this.getProjectAjaxByPermission(ret, exFlow.getProjectId(), user, Permission.Type.READ);
        if (project == null) {
            return;
        }
        int offset = this.getIntParam(req, "offset");
        int length = this.getIntParam(req, "length");
        resp.setCharacterEncoding("utf-8");
        try {
            FileIOUtils.LogData data = this.executorManager.getExecutableFlowLog(exFlow, offset, length);
            if (data == null) {
                ret.put("length", 0);
                ret.put("offset", offset);
                ret.put("data", "");
            } else {
                ret.put("length", data.getLength());
                ret.put("offset", data.getOffset());
                ret.put("data", data.getData());
            }
        }
        catch (ExecutorManagerException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void ajaxFetchJobLogs(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user, ExecutableFlow exFlow) throws ServletException {
        Project project = this.getProjectAjaxByPermission(ret, exFlow.getProjectId(), user, Permission.Type.READ);
        if (project == null) {
            return;
        }
        int offset = this.getIntParam(req, "offset");
        int length = this.getIntParam(req, "length");
        String jobId = this.getParam(req, "jobId");
        resp.setCharacterEncoding("utf-8");
        try {
            ExecutableNode node = exFlow.getExecutableNode(jobId);
            if (node == null) {
                ret.put("error", "Job " + jobId + " doesn't exist in " + exFlow.getExecutionId());
                return;
            }
            int attempt = this.getIntParam(req, "attempt", node.getAttempt());
            FileIOUtils.LogData data = this.executorManager.getExecutionJobLog(exFlow, jobId, offset, length, attempt);
            if (data == null) {
                ret.put("length", 0);
                ret.put("offset", offset);
                ret.put("data", "");
            } else {
                ret.put("length", data.getLength());
                ret.put("offset", data.getOffset());
                ret.put("data", data.getData());
            }
        }
        catch (ExecutorManagerException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void ajaxFetchFlowInfo(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user, String projectName, String flowId) throws ServletException {
        Project project = this.getProjectAjaxByPermission(ret, projectName, user, Permission.Type.READ);
        if (project == null) {
            return;
        }
        Flow flow = project.getFlow(flowId);
        if (flow == null) {
            ret.put("error", "Error loading flow. Flow " + flowId + " doesn't exist in " + projectName);
            return;
        }
        ret.put("successEmails", flow.getSuccessEmails());
        ret.put("failureEmails", flow.getFailureEmails());
        Schedule sflow = null;
        for (Schedule sched : this.scheduleManager.getSchedules()) {
            if (sched.getProjectId() != project.getId() || !sched.getFlowName().equals(flowId)) continue;
            sflow = sched;
            break;
        }
        if (sflow != null) {
            ret.put("scheduled", sflow.getNextExecTime());
        }
    }

    private void ajaxFetchExecutableFlowInfo(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user, ExecutableFlow exflow) throws ServletException {
        Project project = this.getProjectAjaxByPermission(ret, exflow.getProjectId(), user, Permission.Type.READ);
        if (project == null) {
            return;
        }
        Flow flow = project.getFlow(exflow.getFlowId());
        if (flow == null) {
            ret.put("error", "Error loading flow. Flow " + exflow.getFlowId() + " doesn't exist in " + exflow.getProjectId());
            return;
        }
        ExecutionOptions options = exflow.getExecutionOptions();
        ret.put("successEmails", options.getSuccessEmails());
        ret.put("failureEmails", options.getFailureEmails());
        ret.put("flowParam", options.getFlowParameters());
        ExecutionOptions.FailureAction action = options.getFailureAction();
        String failureAction = null;
        switch (action) {
            case FINISH_CURRENTLY_RUNNING: {
                failureAction = "finishCurrent";
                break;
            }
            case CANCEL_ALL: {
                failureAction = "cancelImmediately";
                break;
            }
            case FINISH_ALL_POSSIBLE: {
                failureAction = "finishPossible";
            }
        }
        ret.put("failureAction", failureAction);
        ret.put("notifyFailureFirst", options.getNotifyOnFirstFailure());
        ret.put("notifyFailureLast", options.getNotifyOnLastFailure());
        ret.put("failureEmailsOverride", options.isFailureEmailsOverridden());
        ret.put("successEmailsOverride", options.isSuccessEmailsOverridden());
        ret.put("concurrentOptions", options.getConcurrentOption());
        ret.put("pipelineLevel", options.getPipelineLevel());
        ret.put("pipelineExecution", options.getPipelineExecutionId());
        ret.put("queueLevel", options.getQueueLevel());
        HashMap<String, String> nodeStatus = new HashMap<String, String>();
        for (ExecutableNode node : exflow.getExecutableNodes()) {
            nodeStatus.put(node.getJobId(), node.getStatus().toString());
        }
        ret.put("nodeStatus", nodeStatus);
        ret.put("disabled", options.getDisabledJobs());
        Schedule sflow = this.scheduleManager.getSchedule(project.getId(), exflow.getFlowId());
        for (Schedule sched : this.scheduleManager.getSchedules()) {
            if (sched.getProjectId() != project.getId() || !sched.getFlowName().equals(exflow.getFlowId())) continue;
            sflow = sched;
            break;
        }
        if (sflow != null) {
            ret.put("scheduled", sflow.getNextExecTime());
        }
    }

    private void ajaxCancelFlow(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user, ExecutableFlow exFlow) throws ServletException {
        Project project = this.getProjectAjaxByPermission(ret, exFlow.getProjectId(), user, Permission.Type.EXECUTE);
        if (project == null) {
            return;
        }
        try {
            this.executorManager.cancelFlow(exFlow, user.getUserId());
        }
        catch (ExecutorManagerException e) {
            ret.put("error", e.getMessage());
        }
    }

    private void ajaxGetFlowRunning(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user, String projectId, String flowId) throws ServletException {
        Project project = this.getProjectAjaxByPermission(ret, projectId, user, Permission.Type.EXECUTE);
        if (project == null) {
            return;
        }
        List<Integer> refs = this.executorManager.getRunningFlows(project.getId(), flowId);
        if (!refs.isEmpty()) {
            ret.put("execIds", refs);
        }
    }

    private void ajaxRestartFlow(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user, ExecutableFlow exFlow) throws ServletException {
        Project project = this.getProjectAjaxByPermission(ret, exFlow.getProjectId(), user, Permission.Type.EXECUTE);
        if (project == null) {
            return;
        }
    }

    private void ajaxPauseFlow(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user, ExecutableFlow exFlow) throws ServletException {
        Project project = this.getProjectAjaxByPermission(ret, exFlow.getProjectId(), user, Permission.Type.EXECUTE);
        if (project == null) {
            return;
        }
        try {
            this.executorManager.pauseFlow(exFlow, user.getUserId());
        }
        catch (ExecutorManagerException e) {
            ret.put("error", e.getMessage());
        }
    }

    private void ajaxResumeFlow(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user, ExecutableFlow exFlow) throws ServletException {
        Project project = this.getProjectAjaxByPermission(ret, exFlow.getProjectId(), user, Permission.Type.EXECUTE);
        if (project == null) {
            return;
        }
        try {
            this.executorManager.resumeFlow(exFlow, user.getUserId());
        }
        catch (ExecutorManagerException e) {
            ret.put("resume", e.getMessage());
        }
    }

    private void ajaxFetchExecutableFlowUpdate(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user, ExecutableFlow exFlow) throws ServletException {
        Long lastUpdateTime = Long.parseLong(this.getParam(req, "lastUpdateTime"));
        System.out.println("Fetching " + exFlow.getExecutionId());
        Project project = this.getProjectAjaxByPermission(ret, exFlow.getProjectId(), user, Permission.Type.READ);
        if (project == null) {
            return;
        }
        ArrayList nodeList = new ArrayList();
        for (ExecutableNode node : exFlow.getExecutableNodes()) {
            if (node.getUpdateTime() <= lastUpdateTime) continue;
            HashMap<String, Object> nodeObj = new HashMap<String, Object>();
            nodeObj.put("id", node.getJobId());
            nodeObj.put("status", (Object)node.getStatus());
            nodeObj.put("startTime", node.getStartTime());
            nodeObj.put("endTime", node.getEndTime());
            nodeObj.put("attempt", node.getAttempt());
            if (node.getAttempt() > 0) {
                nodeObj.put("pastAttempts", node.getAttemptObjects());
            }
            nodeList.add(nodeObj);
        }
        ret.put("nodes", nodeList);
        ret.put("status", exFlow.getStatus().toString());
        ret.put("startTime", exFlow.getStartTime());
        ret.put("endTime", exFlow.getEndTime());
        ret.put("submitTime", exFlow.getSubmitTime());
        ret.put("updateTime", exFlow.getUpdateTime());
    }

    private void ajaxFetchExecutableFlow(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user, ExecutableFlow exFlow) throws ServletException {
        System.out.println("Fetching " + exFlow.getExecutionId());
        Project project = this.getProjectAjaxByPermission(ret, exFlow.getProjectId(), user, Permission.Type.READ);
        if (project == null) {
            return;
        }
        ArrayList nodeList = new ArrayList();
        ArrayList edgeList = new ArrayList();
        for (ExecutableNode node : exFlow.getExecutableNodes()) {
            HashMap<String, Object> nodeObj = new HashMap<String, Object>();
            nodeObj.put("id", node.getJobId());
            nodeObj.put("level", node.getLevel());
            nodeObj.put("status", (Object)node.getStatus());
            nodeObj.put("startTime", node.getStartTime());
            nodeObj.put("endTime", node.getEndTime());
            if (node.getPastAttemptList() != null) {
                ArrayList<Map<String, Object>> pastAttempts = new ArrayList<Map<String, Object>>();
                for (ExecutableNode.Attempt attempt : node.getPastAttemptList()) {
                    pastAttempts.add(attempt.toObject());
                }
                nodeObj.put("pastAttempts", pastAttempts);
            }
            nodeList.add(nodeObj);
            for (String out : node.getOutNodes()) {
                HashMap<String, String> edgeObj = new HashMap<String, String>();
                edgeObj.put("from", node.getJobId());
                edgeObj.put("target", out);
                edgeList.add(edgeObj);
            }
        }
        ret.put("nodes", nodeList);
        ret.put("edges", edgeList);
        ret.put("status", exFlow.getStatus().toString());
        ret.put("startTime", exFlow.getStartTime());
        ret.put("endTime", exFlow.getEndTime());
        ret.put("submitTime", exFlow.getSubmitTime());
        ret.put("submitUser", exFlow.getSubmitUser());
    }

    private void ajaxAttemptExecuteFlow(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user) throws ServletException {
        String projectName = this.getParam(req, "project");
        String flowId = this.getParam(req, "flow");
        Project project = this.getProjectAjaxByPermission(ret, projectName, user, Permission.Type.EXECUTE);
        if (project == null) {
            ret.put("error", "Project '" + projectName + "' doesn't exist.");
            return;
        }
        ret.put("flow", flowId);
        Flow flow = project.getFlow(flowId);
        if (flow == null) {
            ret.put("error", "Flow '" + flowId + "' cannot be found in project " + project);
            return;
        }
        this.ajaxExecuteFlow(req, resp, ret, user);
    }

    private void ajaxExecuteFlow(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user) throws ServletException {
        String projectName = this.getParam(req, "project");
        String flowId = this.getParam(req, "flow");
        Project project = this.getProjectAjaxByPermission(ret, projectName, user, Permission.Type.EXECUTE);
        if (project == null) {
            ret.put("error", "Project '" + projectName + "' doesn't exist.");
            return;
        }
        ret.put("flow", flowId);
        Flow flow = project.getFlow(flowId);
        if (flow == null) {
            ret.put("error", "Flow '" + flowId + "' cannot be found in project " + project);
            return;
        }
        ExecutableFlow exflow = new ExecutableFlow(flow);
        exflow.setSubmitUser(user.getUserId());
        exflow.setProxyUsers(project.getProxyUsers());
        ExecutionOptions options = HttpRequestUtils.parseFlowOptions(req);
        exflow.setExecutionOptions(options);
        if (!options.isFailureEmailsOverridden()) {
            options.setFailureEmails(flow.getFailureEmails());
        }
        if (!options.isSuccessEmailsOverridden()) {
            options.setSuccessEmails(flow.getSuccessEmails());
        }
        try {
            String message = this.executorManager.submitExecutableFlow(exflow);
            ret.put("message", message);
        }
        catch (ExecutorManagerException e) {
            e.printStackTrace();
            ret.put("error", "Error submitting flow " + exflow.getFlowId() + ". " + e.getMessage());
        }
        ret.put("execid", exflow.getExecutionId());
    }

    public class ExecutorVelocityHelper {
        public String getProjectName(int id) {
            Project project = ExecutorServlet.this.projectManager.getProject(id);
            if (project == null) {
                return String.valueOf(id);
            }
            return project.getName();
        }
    }
}

