/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.alert.Alerter;
import azkaban.execapp.event.Event;
import azkaban.execapp.event.EventHandler;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableFlowBase;
import azkaban.executor.ExecutableJobInfo;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutionOptions;
import azkaban.executor.ExecutionReference;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.ExecutorManager;
import azkaban.executor.ExecutorManagerAdapter;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import azkaban.project.Project;
import azkaban.utils.FileIOUtils;
import azkaban.utils.JSONUtils;
import azkaban.utils.Pair;
import azkaban.utils.Props;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExecutorManager
extends EventHandler
implements ExecutorManagerAdapter {
    private static Logger logger = Logger.getLogger(ExecutorManager.class);
    private ExecutorLoader executorLoader;
    private String executorHost;
    private int executorPort;
    private CleanerThread cleanerThread;
    private ConcurrentHashMap<Integer, Pair<ExecutionReference, ExecutableFlow>> runningFlows = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, ExecutableFlow> recentlyFinished = new ConcurrentHashMap();
    private ExecutingManagerUpdaterThread executingManager;
    private static final long DEFAULT_EXECUTION_LOGS_RETENTION_MS = 7257600000L;
    private long lastCleanerThreadCheckTime = -1L;
    private long lastThreadCheckTime = -1L;
    private String updaterStage = "not started";
    private Map<String, Alerter> alerters;
    File cacheDir;
    private static /* synthetic */ int[] $SWITCH_TABLE$azkaban$executor$Status;

    public ExecutorManager(Props props, ExecutorLoader loader, Map<String, Alerter> alters) throws ExecutorManagerException {
        this.executorLoader = loader;
        this.loadRunningFlows();
        this.executorHost = props.getString("executor.host", "localhost");
        this.executorPort = props.getInt("executor.port");
        this.alerters = alters;
        this.cacheDir = new File(props.getString("cache.directory", "cache"));
        this.executingManager = new ExecutingManagerUpdaterThread(this);
        this.executingManager.start();
        long executionLogsRetentionMs = props.getLong("execution.logs.retention.ms", 7257600000L);
        this.cleanerThread = new CleanerThread(this, executionLogsRetentionMs);
        this.cleanerThread.start();
    }

    public Thread.State getExecutorManagerThreadState() {
        return this.executingManager.getState();
    }

    public String getExecutorThreadStage() {
        return this.updaterStage;
    }

    public boolean isExecutorManagerThreadActive() {
        return this.executingManager.isAlive();
    }

    public long getLastExecutorManagerThreadCheckTime() {
        return this.lastThreadCheckTime;
    }

    public long getLastCleanerThreadCheckTime() {
        return this.lastCleanerThreadCheckTime;
    }

    public Set<String> getPrimaryServerHosts() {
        HashSet<String> ports = new HashSet<String>();
        ports.add(String.valueOf(this.executorHost) + ":" + this.executorPort);
        return ports;
    }

    public Set<String> getAllActiveExecutorServerHosts() {
        HashSet<String> ports = new HashSet<String>();
        ports.add(String.valueOf(this.executorHost) + ":" + this.executorPort);
        for (Pair running : this.runningFlows.values()) {
            ExecutionReference ref = (ExecutionReference)running.getFirst();
            ports.add(String.valueOf(ref.getHost()) + ":" + ref.getPort());
        }
        return ports;
    }

    private void loadRunningFlows() throws ExecutorManagerException {
        this.runningFlows.putAll(this.executorLoader.fetchActiveFlows());
    }

    public List<Integer> getRunningFlows(int projectId, String flowId) {
        ArrayList<Integer> executionIds = new ArrayList<Integer>();
        for (Pair ref : this.runningFlows.values()) {
            if (!((ExecutableFlow)ref.getSecond()).getFlowId().equals(flowId) || ((ExecutableFlow)ref.getSecond()).getProjectId() != projectId) continue;
            executionIds.add(((ExecutionReference)ref.getFirst()).getExecId());
        }
        return executionIds;
    }

    public boolean isFlowRunning(int projectId, String flowId) {
        for (Pair ref : this.runningFlows.values()) {
            if (((ExecutableFlow)ref.getSecond()).getProjectId() != projectId || !((ExecutableFlow)ref.getSecond()).getFlowId().equals(flowId)) continue;
            return true;
        }
        return false;
    }

    public ExecutableFlow getExecutableFlow(int execId) throws ExecutorManagerException {
        Pair active = (Pair)this.runningFlows.get(execId);
        if (active == null) {
            return this.executorLoader.fetchExecutableFlow(execId);
        }
        return (ExecutableFlow)active.getSecond();
    }

    public List<ExecutableFlow> getRunningFlows() {
        ArrayList<ExecutableFlow> flows = new ArrayList<ExecutableFlow>();
        for (Pair ref : this.runningFlows.values()) {
            flows.add((ExecutableFlow)ref.getSecond());
        }
        return flows;
    }

    public String getRunningFlowIds() {
        ArrayList<Integer> allIds = new ArrayList<Integer>();
        for (Pair ref : this.runningFlows.values()) {
            allIds.add(((ExecutableFlow)ref.getSecond()).getExecutionId());
        }
        Collections.sort(allIds);
        return ((Object)allIds).toString();
    }

    public List<ExecutableFlow> getRecentlyFinishedFlows() {
        return new ArrayList<ExecutableFlow>(this.recentlyFinished.values());
    }

    public List<ExecutableFlow> getExecutableFlows(Project project, String flowId, int skip, int size) throws ExecutorManagerException {
        List flows = this.executorLoader.fetchFlowHistory(project.getId(), flowId, skip, size);
        return flows;
    }

    public List<ExecutableFlow> getExecutableFlows(int skip, int size) throws ExecutorManagerException {
        List flows = this.executorLoader.fetchFlowHistory(skip, size);
        return flows;
    }

    public List<ExecutableFlow> getExecutableFlows(String flowIdContains, int skip, int size) throws ExecutorManagerException {
        List flows = this.executorLoader.fetchFlowHistory(null, String.valueOf('%') + flowIdContains + '%', null, 0, -1L, -1L, skip, size);
        return flows;
    }

    public List<ExecutableFlow> getExecutableFlows(String projContain, String flowContain, String userContain, int status, long begin, long end, int skip, int size) throws ExecutorManagerException {
        List flows = this.executorLoader.fetchFlowHistory(projContain, flowContain, userContain, status, begin, end, skip, size);
        return flows;
    }

    public List<ExecutableJobInfo> getExecutableJobs(Project project, String jobId, int skip, int size) throws ExecutorManagerException {
        List nodes = this.executorLoader.fetchJobHistory(project.getId(), jobId, skip, size);
        return nodes;
    }

    public int getNumberOfJobExecutions(Project project, String jobId) throws ExecutorManagerException {
        return this.executorLoader.fetchNumExecutableNodes(project.getId(), jobId);
    }

    public int getNumberOfExecutions(Project project, String flowId) throws ExecutorManagerException {
        return this.executorLoader.fetchNumExecutableFlows(project.getId(), flowId);
    }

    public FileIOUtils.LogData getExecutableFlowLog(ExecutableFlow exFlow, int offset, int length) throws ExecutorManagerException {
        Pair pair = (Pair)this.runningFlows.get(exFlow.getExecutionId());
        if (pair != null) {
            Pair typeParam = new Pair((Object)"type", (Object)"flow");
            Pair offsetParam = new Pair((Object)"offset", (Object)String.valueOf(offset));
            Pair lengthParam = new Pair((Object)"length", (Object)String.valueOf(length));
            Map result = this.callExecutorServer((ExecutionReference)pair.getFirst(), "log", new Pair[]{typeParam, offsetParam, lengthParam});
            return FileIOUtils.LogData.createLogDataFromObject((Map)result);
        }
        FileIOUtils.LogData value = this.executorLoader.fetchLogs(exFlow.getExecutionId(), "", 0, offset, length);
        return value;
    }

    public FileIOUtils.LogData getExecutionJobLog(ExecutableFlow exFlow, String jobId, int offset, int length, int attempt) throws ExecutorManagerException {
        Pair pair = (Pair)this.runningFlows.get(exFlow.getExecutionId());
        if (pair != null) {
            Pair typeParam = new Pair((Object)"type", (Object)"job");
            Pair jobIdParam = new Pair((Object)"jobId", (Object)jobId);
            Pair offsetParam = new Pair((Object)"offset", (Object)String.valueOf(offset));
            Pair lengthParam = new Pair((Object)"length", (Object)String.valueOf(length));
            Pair attemptParam = new Pair((Object)"attempt", (Object)String.valueOf(attempt));
            Map result = this.callExecutorServer((ExecutionReference)pair.getFirst(), "log", new Pair[]{typeParam, jobIdParam, offsetParam, lengthParam, attemptParam});
            return FileIOUtils.LogData.createLogDataFromObject((Map)result);
        }
        FileIOUtils.LogData value = this.executorLoader.fetchLogs(exFlow.getExecutionId(), jobId, attempt, offset, length);
        return value;
    }

    public List<Object> getExecutionJobStats(ExecutableFlow exFlow, String jobId, int attempt) throws ExecutorManagerException {
        Pair pair = (Pair)this.runningFlows.get(exFlow.getExecutionId());
        if (pair == null) {
            return this.executorLoader.fetchAttachments(exFlow.getExecutionId(), jobId, attempt);
        }
        Pair jobIdParam = new Pair((Object)"jobId", (Object)jobId);
        Pair attemptParam = new Pair((Object)"attempt", (Object)String.valueOf(attempt));
        Map result = this.callExecutorServer((ExecutionReference)pair.getFirst(), "attachments", new Pair[]{jobIdParam, attemptParam});
        List jobStats = (List)result.get("attachments");
        return jobStats;
    }

    public FileIOUtils.JobMetaData getExecutionJobMetaData(ExecutableFlow exFlow, String jobId, int offset, int length, int attempt) throws ExecutorManagerException {
        Pair pair = (Pair)this.runningFlows.get(exFlow.getExecutionId());
        if (pair != null) {
            Pair typeParam = new Pair((Object)"type", (Object)"job");
            Pair jobIdParam = new Pair((Object)"jobId", (Object)jobId);
            Pair offsetParam = new Pair((Object)"offset", (Object)String.valueOf(offset));
            Pair lengthParam = new Pair((Object)"length", (Object)String.valueOf(length));
            Pair attemptParam = new Pair((Object)"attempt", (Object)String.valueOf(attempt));
            Map result = this.callExecutorServer((ExecutionReference)pair.getFirst(), "metadata", new Pair[]{typeParam, jobIdParam, offsetParam, lengthParam, attemptParam});
            return FileIOUtils.JobMetaData.createJobMetaDataFromObject((Map)result);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelFlow(ExecutableFlow exFlow, String userId) throws ExecutorManagerException {
        ExecutableFlow executableFlow = exFlow;
        synchronized (executableFlow) {
            Pair pair = (Pair)this.runningFlows.get(exFlow.getExecutionId());
            if (pair == null) {
                throw new ExecutorManagerException("Execution " + exFlow.getExecutionId() + " of flow " + exFlow.getFlowId() + " isn't running.");
            }
            this.callExecutorServer((ExecutionReference)pair.getFirst(), "cancel", userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeFlow(ExecutableFlow exFlow, String userId) throws ExecutorManagerException {
        ExecutableFlow executableFlow = exFlow;
        synchronized (executableFlow) {
            Pair pair = (Pair)this.runningFlows.get(exFlow.getExecutionId());
            if (pair == null) {
                throw new ExecutorManagerException("Execution " + exFlow.getExecutionId() + " of flow " + exFlow.getFlowId() + " isn't running.");
            }
            this.callExecutorServer((ExecutionReference)pair.getFirst(), "resume", userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseFlow(ExecutableFlow exFlow, String userId) throws ExecutorManagerException {
        ExecutableFlow executableFlow = exFlow;
        synchronized (executableFlow) {
            Pair pair = (Pair)this.runningFlows.get(exFlow.getExecutionId());
            if (pair == null) {
                throw new ExecutorManagerException("Execution " + exFlow.getExecutionId() + " of flow " + exFlow.getFlowId() + " isn't running.");
            }
            this.callExecutorServer((ExecutionReference)pair.getFirst(), "pause", userId);
        }
    }

    public void pauseExecutingJobs(ExecutableFlow exFlow, String userId, String ... jobIds) throws ExecutorManagerException {
        this.modifyExecutingJobs(exFlow, "pauseJobs", userId, jobIds);
    }

    public void resumeExecutingJobs(ExecutableFlow exFlow, String userId, String ... jobIds) throws ExecutorManagerException {
        this.modifyExecutingJobs(exFlow, "resumeJobs", userId, jobIds);
    }

    public void retryFailures(ExecutableFlow exFlow, String userId) throws ExecutorManagerException {
        this.modifyExecutingJobs(exFlow, "retryFailures", userId, new String[0]);
    }

    public void retryExecutingJobs(ExecutableFlow exFlow, String userId, String ... jobIds) throws ExecutorManagerException {
        this.modifyExecutingJobs(exFlow, "retryJobs", userId, jobIds);
    }

    public void disableExecutingJobs(ExecutableFlow exFlow, String userId, String ... jobIds) throws ExecutorManagerException {
        this.modifyExecutingJobs(exFlow, "skipJobs", userId, jobIds);
    }

    public void enableExecutingJobs(ExecutableFlow exFlow, String userId, String ... jobIds) throws ExecutorManagerException {
        this.modifyExecutingJobs(exFlow, "enableJobs", userId, jobIds);
    }

    public void cancelExecutingJobs(ExecutableFlow exFlow, String userId, String ... jobIds) throws ExecutorManagerException {
        this.modifyExecutingJobs(exFlow, "cancelJobs", userId, jobIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> modifyExecutingJobs(ExecutableFlow exFlow, String command, String userId, String ... jobIds) throws ExecutorManagerException {
        ExecutableFlow executableFlow = exFlow;
        synchronized (executableFlow) {
            Pair pair = (Pair)this.runningFlows.get(exFlow.getExecutionId());
            if (pair == null) {
                throw new ExecutorManagerException("Execution " + exFlow.getExecutionId() + " of flow " + exFlow.getFlowId() + " isn't running.");
            }
            Map response = null;
            if (jobIds != null && jobIds.length > 0) {
                String[] stringArray = jobIds;
                int n = jobIds.length;
                int n2 = 0;
                while (n2 < n) {
                    ExecutableNode node;
                    String jobId = stringArray[n2];
                    if (!jobId.isEmpty() && (node = exFlow.getExecutableNode(jobId)) == null) {
                        throw new ExecutorManagerException("Job " + jobId + " doesn't exist in execution " + exFlow.getExecutionId() + ".");
                    }
                    ++n2;
                }
                String ids = StringUtils.join((Object[])jobIds, (char)',');
                response = this.callExecutorServer((ExecutionReference)pair.getFirst(), "modifyExecution", userId, new Pair[]{new Pair((Object)"modifyType", (Object)command), new Pair((Object)"jobIds", (Object)ids)});
            } else {
                response = this.callExecutorServer((ExecutionReference)pair.getFirst(), "modifyExecution", userId, new Pair[]{new Pair((Object)"modifyType", (Object)command)});
            }
            return response;
        }
    }

    private void applyDisabledJobs(List<Object> disabledJobs, ExecutableFlowBase exflow) {
        for (Object disabled : disabledJobs) {
            if (disabled instanceof String) {
                String nodeName = (String)disabled;
                ExecutableNode node = exflow.getExecutableNode(nodeName);
                if (node == null) continue;
                node.setStatus(Status.DISABLED);
                continue;
            }
            if (!(disabled instanceof Map)) continue;
            Map nestedDisabled = (Map)disabled;
            String nodeName = (String)nestedDisabled.get("id");
            List subDisabledJobs = (List)nestedDisabled.get("children");
            if (nodeName == null || subDisabledJobs == null) {
                return;
            }
            ExecutableNode node = exflow.getExecutableNode(nodeName);
            if (node == null || !(node instanceof ExecutableFlowBase)) continue;
            this.applyDisabledJobs(subDisabledJobs, (ExecutableFlowBase)node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String submitExecutableFlow(ExecutableFlow exflow, String userId) throws ExecutorManagerException {
        ExecutableFlow executableFlow = exflow;
        synchronized (executableFlow) {
            logger.info((Object)("Submitting execution flow " + exflow.getFlowId() + " by " + userId));
            int projectId = exflow.getProjectId();
            String flowId = exflow.getFlowId();
            exflow.setSubmitUser(userId);
            exflow.setSubmitTime(System.currentTimeMillis());
            List running = this.getRunningFlows(projectId, flowId);
            ExecutionOptions options = exflow.getExecutionOptions();
            if (options == null) {
                options = new ExecutionOptions();
            }
            String message = "";
            if (options.getDisabledJobs() != null) {
                this.applyDisabledJobs(options.getDisabledJobs(), (ExecutableFlowBase)exflow);
            }
            if (!running.isEmpty()) {
                if (options.getConcurrentOption().equals("pipeline")) {
                    Collections.sort(running);
                    Integer runningExecId = (Integer)running.get(running.size() - 1);
                    options.setPipelineExecutionId(runningExecId);
                    message = "Flow " + flowId + " is already running with exec id " + runningExecId + ". Pipelining level " + options.getPipelineLevel() + ". \n";
                } else {
                    if (options.getConcurrentOption().equals("skip")) {
                        throw new ExecutorManagerException("Flow " + flowId + " is already running. Skipping execution.", ExecutorManagerException.Reason.SkippedExecution);
                    }
                    message = "Flow " + flowId + " is already running with exec id " + StringUtils.join((Collection)running, (String)",") + ". Will execute concurrently. \n";
                }
            }
            this.executorLoader.uploadExecutableFlow(exflow);
            ExecutionReference reference = new ExecutionReference(exflow.getExecutionId(), this.executorHost, this.executorPort);
            this.executorLoader.addActiveExecutableReference(reference);
            try {
                this.callExecutorServer(reference, "execute");
                this.runningFlows.put(exflow.getExecutionId(), new Pair((Object)reference, (Object)exflow));
                message = String.valueOf(message) + "Execution submitted successfully with exec id " + exflow.getExecutionId();
            }
            catch (ExecutorManagerException e) {
                this.executorLoader.removeActiveExecutableReference(reference.getExecId());
                throw e;
            }
            return message;
        }
    }

    private void cleanOldExecutionLogs(long millis) {
        try {
            int count = this.executorLoader.removeExecutionLogsByTime(millis);
            logger.info((Object)("Cleaned up " + count + " log entries."));
        }
        catch (ExecutorManagerException e) {
            e.printStackTrace();
        }
    }

    private Map<String, Object> callExecutorServer(ExecutionReference ref, String action) throws ExecutorManagerException {
        try {
            return this.callExecutorServer(ref.getHost(), ref.getPort(), action, Integer.valueOf(ref.getExecId()), null, null);
        }
        catch (IOException e) {
            throw new ExecutorManagerException((Exception)e);
        }
    }

    private Map<String, Object> callExecutorServer(ExecutionReference ref, String action, String user) throws ExecutorManagerException {
        try {
            return this.callExecutorServer(ref.getHost(), ref.getPort(), action, Integer.valueOf(ref.getExecId()), user, null);
        }
        catch (IOException e) {
            throw new ExecutorManagerException((Exception)e);
        }
    }

    private Map<String, Object> callExecutorServer(ExecutionReference ref, String action, Pair<String, String> ... params) throws ExecutorManagerException {
        try {
            return this.callExecutorServer(ref.getHost(), ref.getPort(), action, Integer.valueOf(ref.getExecId()), null, params);
        }
        catch (IOException e) {
            throw new ExecutorManagerException((Exception)e);
        }
    }

    private Map<String, Object> callExecutorServer(ExecutionReference ref, String action, String user, Pair<String, String> ... params) throws ExecutorManagerException {
        try {
            return this.callExecutorServer(ref.getHost(), ref.getPort(), action, Integer.valueOf(ref.getExecId()), user, params);
        }
        catch (IOException e) {
            throw new ExecutorManagerException((Exception)e);
        }
    }

    private Map<String, Object> callExecutorServer(String host, int port, String action, Integer executionId, String user, Pair<String, String> ... params) throws IOException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme("http").setHost(host).setPort(port).setPath("/executor");
        builder.setParameter("action", action);
        if (executionId != null) {
            builder.setParameter("execid", String.valueOf(executionId));
        }
        if (user != null) {
            builder.setParameter("user", user);
        }
        if (params != null) {
            Pair<String, String>[] pairArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                Pair<String, String> pair = pairArray[n2];
                builder.setParameter((String)pair.getFirst(), (String)pair.getSecond());
                ++n2;
            }
        }
        URI uri = null;
        try {
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpGet httpget = new HttpGet(uri);
        String response = null;
        try {
            response = (String)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)responseHandler);
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        Map jsonResponse = (Map)JSONUtils.parseJSONFromString((String)response);
        String error = (String)jsonResponse.get("error");
        if (error != null) {
            throw new IOException(error);
        }
        return jsonResponse;
    }

    public Map<String, Object> callExecutorJMX(String hostPort, String action, String mBean) throws IOException {
        URIBuilder builder = new URIBuilder();
        String[] hostPortSplit = hostPort.split(":");
        builder.setScheme("http").setHost(hostPortSplit[0]).setPort(Integer.parseInt(hostPortSplit[1])).setPath("/jmx");
        builder.setParameter(action, "");
        if (mBean != null) {
            builder.setParameter("mBean", mBean);
        }
        URI uri = null;
        try {
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpGet httpget = new HttpGet(uri);
        String response = null;
        try {
            response = (String)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)responseHandler);
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        Map jsonResponse = (Map)JSONUtils.parseJSONFromString((String)response);
        String error = (String)jsonResponse.get("error");
        if (error != null) {
            throw new IOException(error);
        }
        return jsonResponse;
    }

    public void shutdown() {
        ExecutingManagerUpdaterThread.access$0((ExecutingManagerUpdaterThread)this.executingManager);
    }

    private void finalizeFlows(ExecutableFlow flow) {
        int execId = flow.getExecutionId();
        this.updaterStage = "finalizing flow " + execId;
        try {
            ExecutableFlow dsFlow;
            if (this.isFinished(flow)) {
                dsFlow = flow;
            } else {
                this.updaterStage = "finalizing flow " + execId + " loading from db";
                dsFlow = this.executorLoader.fetchExecutableFlow(execId);
                if (!this.isFinished(dsFlow)) {
                    this.updaterStage = "finalizing flow " + execId + " failing the flow";
                    this.failEverything(dsFlow);
                    this.executorLoader.updateExecutableFlow(dsFlow);
                }
            }
            this.updaterStage = "finalizing flow " + execId + " deleting active reference";
            if (flow.getEndTime() == -1L) {
                flow.setEndTime(System.currentTimeMillis());
                this.executorLoader.updateExecutableFlow(dsFlow);
            }
            this.executorLoader.removeActiveExecutableReference(execId);
            this.updaterStage = "finalizing flow " + execId + " cleaning from memory";
            this.runningFlows.remove(execId);
            this.fireEventListeners(Event.create((Object)dsFlow, (Event.Type)Event.Type.FLOW_FINISHED));
            this.recentlyFinished.put(execId, dsFlow);
        }
        catch (ExecutorManagerException e) {
            logger.error((Object)e);
        }
        this.updaterStage = "finalizing flow " + execId + " alerting and emailing";
        ExecutionOptions options = flow.getExecutionOptions();
        Alerter mailAlerter = (Alerter)this.alerters.get("email");
        if (flow.getStatus() == Status.FAILED || flow.getStatus() == Status.KILLED) {
            if (options.getFailureEmails() != null && !options.getFailureEmails().isEmpty()) {
                try {
                    mailAlerter.alertOnError(flow, new String[]{"Executor no longer seems to be running this execution. Most likely due to executor bounce."});
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            if (options.getFlowParameters().containsKey("alert.type")) {
                String alertType = (String)options.getFlowParameters().get("alert.type");
                Alerter alerter = (Alerter)this.alerters.get(alertType);
                if (alerter != null) {
                    try {
                        alerter.alertOnError(flow, new String[]{"Executor no longer seems to be running this execution. Most likely due to executor bounce."});
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error((Object)("Failed to alert by " + alertType));
                    }
                } else {
                    logger.error((Object)("Alerter type " + alertType + " doesn't exist. Failed to alert."));
                }
            }
        } else {
            if (options.getSuccessEmails() != null && !options.getSuccessEmails().isEmpty()) {
                try {
                    mailAlerter.alertOnSuccess(flow);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            if (options.getFlowParameters().containsKey("alert.type")) {
                String alertType = (String)options.getFlowParameters().get("alert.type");
                Alerter alerter = (Alerter)this.alerters.get(alertType);
                if (alerter != null) {
                    try {
                        alerter.alertOnSuccess(flow);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error((Object)("Failed to alert by " + alertType));
                    }
                } else {
                    logger.error((Object)("Alerter type " + alertType + " doesn't exist. Failed to alert."));
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void failEverything(ExecutableFlow exFlow) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void evictOldRecentlyFinished(long ageMs) {
        ArrayList recentlyFinishedKeys = new ArrayList(this.recentlyFinished.keySet());
        long oldAgeThreshold = System.currentTimeMillis() - ageMs;
        for (Integer key : recentlyFinishedKeys) {
            ExecutableFlow flow = (ExecutableFlow)this.recentlyFinished.get(key);
            if (flow.getEndTime() >= oldAgeThreshold) continue;
            this.recentlyFinished.remove(key);
        }
    }

    private ExecutableFlow updateExecution(Map<String, Object> updateData) throws ExecutorManagerException {
        Integer execId = (Integer)updateData.get("executionId");
        if (execId == null) {
            throw new ExecutorManagerException("Response is malformed. Need exec id to update.");
        }
        Pair refPair = (Pair)this.runningFlows.get(execId);
        if (refPair == null) {
            throw new ExecutorManagerException("No running flow found with the execution id. Removing " + execId);
        }
        ExecutionReference ref = (ExecutionReference)refPair.getFirst();
        ExecutableFlow flow = (ExecutableFlow)refPair.getSecond();
        if (updateData.containsKey("error")) {
            throw new ExecutorManagerException((String)updateData.get("error"), flow);
        }
        ref.setNextCheckTime(0L);
        ref.setNumErrors(0);
        Status oldStatus = flow.getStatus();
        flow.applyUpdateObject(updateData);
        Status newStatus = flow.getStatus();
        ExecutionOptions options = flow.getExecutionOptions();
        if (oldStatus != newStatus && newStatus.equals((Object)Status.FAILED_FINISHING)) {
            if (options.getNotifyOnFirstFailure()) {
                Alerter mailAlerter = (Alerter)this.alerters.get("email");
                try {
                    mailAlerter.alertOnFirstError(flow);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error((Object)("Failed to send first error email." + e.getMessage()));
                }
            }
            if (options.getFlowParameters().containsKey("alert.type")) {
                String alertType = (String)options.getFlowParameters().get("alert.type");
                Alerter alerter = (Alerter)this.alerters.get(alertType);
                if (alerter != null) {
                    try {
                        alerter.alertOnFirstError(flow);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error((Object)("Failed to alert by " + alertType));
                    }
                } else {
                    logger.error((Object)("Alerter type " + alertType + " doesn't exist. Failed to alert."));
                }
            }
        }
        return flow;
    }

    /*
     * Exception decompiling
     */
    public boolean isFinished(ExecutableFlow flow) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void fillUpdateTimeAndExecId(List<ExecutableFlow> flows, List<Integer> executionIds, List<Long> updateTimes) {
        for (ExecutableFlow flow : flows) {
            executionIds.add(flow.getExecutionId());
            updateTimes.add(flow.getUpdateTime());
        }
    }

    private Map<ConnectionInfo, List<ExecutableFlow>> getFlowToExecutorMap() {
        HashMap<ConnectionInfo, List<ExecutableFlow>> exFlowMap = new HashMap<ConnectionInfo, List<ExecutableFlow>>();
        ConnectionInfo lastPort = new ConnectionInfo(this.executorHost, this.executorPort);
        for (Pair runningFlow : this.runningFlows.values()) {
            List<ExecutableFlow> flows;
            ExecutionReference ref = (ExecutionReference)runningFlow.getFirst();
            ExecutableFlow flow = (ExecutableFlow)runningFlow.getSecond();
            if (ref.getNextCheckTime() >= System.currentTimeMillis()) continue;
            if (!lastPort.isEqual(ref.getHost(), ref.getPort())) {
                lastPort = new ConnectionInfo(ref.getHost(), ref.getPort());
            }
            if ((flows = exFlowMap.get(lastPort)) == null) {
                flows = new ArrayList<ExecutableFlow>();
                exFlowMap.put(lastPort, flows);
            }
            flows.add(flow);
        }
        return exFlowMap;
    }

    public int getExecutableFlows(int projectId, String flowId, int from, int length, List<ExecutableFlow> outputList) throws ExecutorManagerException {
        List flows = this.executorLoader.fetchFlowHistory(projectId, flowId, from, length);
        outputList.addAll(flows);
        return this.executorLoader.fetchNumExecutableFlows(projectId, flowId);
    }

    public List<ExecutableFlow> getExecutableFlows(int projectId, String flowId, int from, int length, Status status) throws ExecutorManagerException {
        return this.executorLoader.fetchFlowHistory(projectId, flowId, from, length, status);
    }

    static /* synthetic */ void access$0(ExecutorManager executorManager, long l) {
        executorManager.lastThreadCheckTime = l;
    }

    static /* synthetic */ void access$1(ExecutorManager executorManager, String string) {
        executorManager.updaterStage = string;
    }

    static /* synthetic */ Map access$2(ExecutorManager executorManager) {
        return executorManager.getFlowToExecutorMap();
    }

    static /* synthetic */ void access$3(ExecutorManager executorManager, List list, List list2, List list3) {
        executorManager.fillUpdateTimeAndExecId(list, list2, list3);
    }

    static /* synthetic */ Map access$4(ExecutorManager executorManager, String string, int n, String string2, Integer n2, String string3, Pair[] pairArray) throws IOException {
        return executorManager.callExecutorServer(string, n, string2, n2, string3, pairArray);
    }

    static /* synthetic */ Logger access$5() {
        return logger;
    }

    static /* synthetic */ ConcurrentHashMap access$6(ExecutorManager executorManager) {
        return executorManager.runningFlows;
    }

    static /* synthetic */ ExecutableFlow access$7(ExecutorManager executorManager, Map map) throws ExecutorManagerException {
        return executorManager.updateExecution(map);
    }

    static /* synthetic */ void access$8(ExecutorManager executorManager, long l) {
        executorManager.evictOldRecentlyFinished(l);
    }

    static /* synthetic */ ConcurrentHashMap access$9(ExecutorManager executorManager) {
        return executorManager.recentlyFinished;
    }

    static /* synthetic */ void access$10(ExecutorManager executorManager, ExecutableFlow executableFlow) {
        executorManager.finalizeFlows(executableFlow);
    }

    static /* synthetic */ void access$11(ExecutorManager executorManager, long l) {
        executorManager.lastCleanerThreadCheckTime = l;
    }

    static /* synthetic */ void access$12(ExecutorManager executorManager, long l) {
        executorManager.cleanOldExecutionLogs(l);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$azkaban$executor$Status() {
        if ($SWITCH_TABLE$azkaban$executor$Status != null) {
            return $SWITCH_TABLE$azkaban$executor$Status;
        }
        int[] nArray = new int[Status.values().length];
        try {
            nArray[Status.CANCELLED.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.DISABLED.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.FAILED.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.FAILED_FINISHING.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.FAILED_SUCCEEDED.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.KILLED.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.PAUSED.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.PREPARING.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.QUEUED.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.READY.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.RUNNING.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.SKIPPED.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.SUCCEEDED.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$azkaban$executor$Status = nArray;
        return nArray;
    }
}

