/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.project;

import azkaban.database.AbstractJdbcLoader;
import azkaban.database.AzkabanDataSource;
import azkaban.database.DataSourceUtils;
import azkaban.flow.Edge;
import azkaban.flow.Flow;
import azkaban.flow.Node;
import azkaban.project.JdbcProjectLoader;
import azkaban.project.Project;
import azkaban.project.ProjectFileHandler;
import azkaban.project.ProjectLoader;
import azkaban.project.ProjectLogEvent;
import azkaban.project.ProjectManagerException;
import azkaban.test.project.JdbcProjectLoaderTest;
import azkaban.user.Permission;
import azkaban.user.User;
import azkaban.utils.Pair;
import azkaban.utils.Props;
import azkaban.utils.PropsUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class JdbcProjectLoaderTest {
    private static boolean testDBExists;
    private static final String host = "localhost";
    private static final int port = 3306;
    private static final String database = "test";
    private static final String user = "azkaban";
    private static final String password = "azkaban";
    private static final int numConnections = 10;

    @BeforeClass
    public static void setupDB() {
        AzkabanDataSource dataSource = DataSourceUtils.getMySQLDataSource((String)"localhost", (Integer)3306, (String)"test", (String)"azkaban", (String)"azkaban", (Integer)10);
        testDBExists = true;
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        CountHandler countHandler = new CountHandler();
        QueryRunner runner = new QueryRunner();
        try {
            runner.query(connection, "SELECT COUNT(1) FROM projects", (ResultSetHandler)countHandler);
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        try {
            runner.query(connection, "SELECT COUNT(1) FROM project_events", (ResultSetHandler)countHandler);
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        try {
            runner.query(connection, "SELECT COUNT(1) FROM project_permissions", (ResultSetHandler)countHandler);
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        try {
            runner.query(connection, "SELECT COUNT(1) FROM project_files", (ResultSetHandler)countHandler);
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        try {
            runner.query(connection, "SELECT COUNT(1) FROM project_flows", (ResultSetHandler)countHandler);
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        try {
            runner.query(connection, "SELECT COUNT(1) FROM project_properties", (ResultSetHandler)countHandler);
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        DbUtils.closeQuietly((Connection)connection);
        JdbcProjectLoaderTest.clearDB();
    }

    private static void clearDB() {
        if (!testDBExists) {
            return;
        }
        AzkabanDataSource dataSource = DataSourceUtils.getMySQLDataSource((String)"localhost", (Integer)3306, (String)"test", (String)"azkaban", (String)"azkaban", (Integer)10);
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        QueryRunner runner = new QueryRunner();
        try {
            runner.update(connection, "DELETE FROM projects");
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        try {
            runner.update(connection, "DELETE FROM project_events");
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        try {
            runner.update(connection, "DELETE FROM project_permissions");
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        try {
            runner.update(connection, "DELETE FROM project_files");
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        try {
            runner.update(connection, "DELETE FROM project_flows");
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        try {
            runner.update(connection, "DELETE FROM project_properties");
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        DbUtils.closeQuietly((Connection)connection);
    }

    @Test
    public void testCreateProject() throws ProjectManagerException {
        User user;
        String projectDescription;
        String projectName;
        if (!this.isTestSetup()) {
            return;
        }
        ProjectLoader loader = this.createLoader();
        Project project = loader.createNewProject(projectName = "mytestProject", projectDescription = "This is my new project", user = new User("testUser"));
        Assert.assertTrue((String)"Project Id set", (project.getId() > -1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Project name", (Object)projectName, (Object)project.getName());
        Assert.assertEquals((String)"Project description", (Object)projectDescription, (Object)project.getDescription());
        System.out.println("Test true");
        Project project2 = loader.fetchProjectById(project.getId());
        this.assertProjectMemberEquals(project, project2);
    }

    @Test
    public void testRemoveProject() throws ProjectManagerException {
        User user;
        String projectDescription;
        String projectName;
        if (!this.isTestSetup()) {
            return;
        }
        ProjectLoader loader = this.createLoader();
        Project project = loader.createNewProject(projectName = "testRemoveProject", projectDescription = "This is my new project", user = new User("testUser"));
        Assert.assertTrue((String)"Project Id set", (project.getId() > -1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Project name", (Object)projectName, (Object)project.getName());
        Assert.assertEquals((String)"Project description", (Object)projectDescription, (Object)project.getDescription());
        Project project2 = loader.fetchProjectById(project.getId());
        this.assertProjectMemberEquals(project, project2);
        loader.removeProject(project, user.getUserId());
        Project project3 = loader.fetchProjectById(project.getId());
        Assert.assertFalse((boolean)project3.isActive());
        List projList = loader.fetchAllActiveProjects();
        for (Project proj : projList) {
            Assert.assertTrue((proj.getId() != project.getId() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testAddRemovePermissions() throws ProjectManagerException {
        User user;
        String projectDescription;
        String projectName;
        if (!this.isTestSetup()) {
            return;
        }
        ProjectLoader loader = this.createLoader();
        Project project = loader.createNewProject(projectName = "mytestProject1", projectDescription = "This is my new project", user = new User("testUser"));
        Assert.assertTrue((String)"Project Id set", (project.getId() > -1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Project name", (Object)projectName, (Object)project.getName());
        Assert.assertEquals((String)"Project description", (Object)projectDescription, (Object)project.getDescription());
        Permission perm = new Permission(2);
        loader.updatePermission(project, user.getUserId(), new Permission(2), false);
        loader.updatePermission(project, "group1", new Permission(2), true);
        Assert.assertEquals((Object)perm, (Object)project.getUserPermission(user.getUserId()));
        Permission permOverride = new Permission(6);
        loader.updatePermission(project, user.getUserId(), permOverride, false);
        Assert.assertEquals((Object)permOverride, (Object)project.getUserPermission(user.getUserId()));
        Project project2 = loader.fetchProjectById(project.getId());
        this.assertProjectMemberEquals(project, project2);
        Assert.assertEquals((Object)permOverride, (Object)project2.getUserPermission(user.getUserId()));
    }

    @Test
    public void testProjectEventLogs() throws ProjectManagerException {
        if (!this.isTestSetup()) {
            return;
        }
        ProjectLoader loader = this.createLoader();
        String projectName = "testProjectEventLogs";
        String projectDescription = "This is my new project";
        User user = new User("testUser");
        String message = "My message";
        ProjectLogEvent.EventType type = ProjectLogEvent.EventType.USER_PERMISSION;
        Project project = loader.createNewProject(projectName, projectDescription, user);
        loader.postEvent(project, type, user.getUserId(), message);
        List events = loader.getProjectEvents(project, 10, 0);
        Assert.assertTrue((events.size() == 1 ? 1 : 0) != 0);
        ProjectLogEvent event = (ProjectLogEvent)events.get(0);
        Assert.assertEquals((long)event.getProjectId(), (long)project.getId());
        Assert.assertEquals((Object)event.getUser(), (Object)user.getUserId());
        Assert.assertEquals((Object)event.getMessage(), (Object)message);
        Assert.assertEquals((Object)event.getType(), (Object)type);
    }

    @Test
    public void testFlowUpload() throws ProjectManagerException {
        ProjectLoader loader = this.createLoader();
        ((JdbcProjectLoader)loader).setDefaultEncodingType(AbstractJdbcLoader.EncodingType.GZIP);
        String projectName = "mytestFlowUpload1";
        String projectDescription = "This is my new project";
        User user = new User("testUser");
        Project project = loader.createNewProject(projectName, projectDescription, user);
        Flow flow = new Flow("MyNewFlow");
        flow.addNode(new Node("A"));
        flow.addNode(new Node("B"));
        flow.addNode(new Node("C"));
        flow.addNode(new Node("D"));
        flow.addEdge(new Edge("A", "B"));
        flow.addEdge(new Edge("A", "C"));
        flow.addEdge(new Edge("B", "D"));
        flow.addEdge(new Edge("C", "D"));
        flow.initialize();
        loader.uploadFlow(project, 4, flow);
        project.setVersion(4);
        Flow newFlow = loader.fetchFlow(project, flow.getId());
        Assert.assertTrue((newFlow != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)flow.getId(), (Object)newFlow.getId());
        Assert.assertEquals((long)flow.getEdges().size(), (long)newFlow.getEdges().size());
        Assert.assertEquals((long)flow.getNodes().size(), (long)newFlow.getNodes().size());
    }

    @Test
    public void testFlowUploadPlain() throws ProjectManagerException {
        ProjectLoader loader = this.createLoader();
        ((JdbcProjectLoader)loader).setDefaultEncodingType(AbstractJdbcLoader.EncodingType.PLAIN);
        String projectName = "mytestFlowUpload2";
        String projectDescription = "This is my new project";
        User user = new User("testUser");
        Project project = loader.createNewProject(projectName, projectDescription, user);
        Flow flow = new Flow("MyNewFlow2");
        flow.addNode(new Node("A1"));
        flow.addNode(new Node("B1"));
        flow.addNode(new Node("C1"));
        flow.addNode(new Node("D1"));
        flow.addEdge(new Edge("A1", "B1"));
        flow.addEdge(new Edge("A1", "C1"));
        flow.addEdge(new Edge("B1", "D1"));
        flow.addEdge(new Edge("C1", "D1"));
        flow.initialize();
        loader.uploadFlow(project, 4, flow);
        project.setVersion(4);
        Flow newFlow = loader.fetchFlow(project, flow.getId());
        Assert.assertTrue((newFlow != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)flow.getId(), (Object)newFlow.getId());
        Assert.assertEquals((long)flow.getEdges().size(), (long)newFlow.getEdges().size());
        Assert.assertEquals((long)flow.getNodes().size(), (long)newFlow.getNodes().size());
        List flows = loader.fetchAllProjectFlows(project);
        Assert.assertTrue((flows.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testProjectProperties() throws ProjectManagerException {
        ProjectLoader loader = this.createLoader();
        ((JdbcProjectLoader)loader).setDefaultEncodingType(AbstractJdbcLoader.EncodingType.PLAIN);
        String projectName = "testProjectProperties";
        String projectDescription = "This is my new project";
        User user = new User("testUser");
        Project project = loader.createNewProject(projectName, projectDescription, user);
        project.setVersion(5);
        Props props = new Props();
        props.put("a", "abc");
        props.put("b", "bcd");
        props.put("c", "cde");
        props.setSource("mysource");
        loader.uploadProjectProperty(project, props);
        Props retProps = loader.fetchProjectProperty(project, "mysource");
        Assert.assertEquals((Object)retProps.getSource(), (Object)props.getSource());
        Assert.assertEquals((Object)retProps.getKeySet(), (Object)props.getKeySet());
        Assert.assertEquals((Object)PropsUtils.toStringMap((Props)retProps, (boolean)true), (Object)PropsUtils.toStringMap((Props)props, (boolean)true));
    }

    @Test
    public void testProjectFilesUpload() throws ProjectManagerException {
        User user;
        String projectDescription;
        String projectName;
        if (!this.isTestSetup()) {
            return;
        }
        ProjectLoader loader = this.createLoader();
        Project project = loader.createNewProject(projectName = "testProjectFilesUpload1", projectDescription = "This is my new project", user = new User("testUser"));
        Assert.assertTrue((String)"Project Id set", (project.getId() > -1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Project name", (Object)projectName, (Object)project.getName());
        Assert.assertEquals((String)"Project description", (Object)projectDescription, (Object)project.getDescription());
        File testDir = new File("unit/project/testjob/testjob.zip");
        loader.uploadProjectFile(project, 1, "zip", "testjob.zip", testDir, user.getUserId());
        ProjectFileHandler handler = loader.getUploadedFile(project, 1);
        Assert.assertEquals((long)handler.getProjectId(), (long)project.getId());
        Assert.assertEquals((Object)handler.getFileName(), (Object)"testjob.zip");
        Assert.assertEquals((long)handler.getVersion(), (long)1L);
        Assert.assertEquals((Object)handler.getFileType(), (Object)"zip");
        File file = handler.getLocalFile();
        Assert.assertTrue((boolean)handler.getLocalFile().exists());
        Assert.assertEquals((Object)handler.getFileName(), (Object)"testjob.zip");
        Assert.assertEquals((Object)handler.getUploader(), (Object)user.getUserId());
        handler.deleteLocalFile();
        Assert.assertTrue((handler.getLocalFile() == null ? 1 : 0) != 0);
        Assert.assertFalse((boolean)file.exists());
    }

    private void assertProjectMemberEquals(Project p1, Project p2) {
        Assert.assertEquals((long)p1.getId(), (long)p2.getId());
        Assert.assertEquals((Object)p1.getName(), (Object)p2.getName());
        Assert.assertEquals((long)p1.getCreateTimestamp(), (long)p2.getCreateTimestamp());
        Assert.assertEquals((Object)p1.getDescription(), (Object)p2.getDescription());
        Assert.assertEquals((Object)p1.getLastModifiedUser(), (Object)p2.getLastModifiedUser());
        Assert.assertEquals((long)p1.getVersion(), (long)p2.getVersion());
        Assert.assertEquals((Object)p1.isActive(), (Object)p2.isActive());
        Assert.assertEquals((Object)p1.getLastModifiedUser(), (Object)p2.getLastModifiedUser());
        this.assertUserPermissionsEqual(p1, p2);
        this.assertGroupPermissionsEqual(p1, p2);
    }

    private void assertUserPermissionsEqual(Project p1, Project p2) {
        Permission perm;
        List perm1 = p1.getUserPermissions();
        List perm2 = p2.getUserPermissions();
        Assert.assertEquals((long)perm1.size(), (long)perm2.size());
        HashMap<String, Permission> perm1Map = new HashMap<String, Permission>();
        for (Pair p : perm1) {
            perm1Map.put((String)p.getFirst(), (Permission)p.getSecond());
        }
        for (Pair p : perm2) {
            Assert.assertTrue((boolean)perm1Map.containsKey(p.getFirst()));
            perm = (Permission)perm1Map.get(p.getFirst());
            Assert.assertEquals((Object)perm, (Object)p.getSecond());
        }
        HashMap<String, Permission> perm2Map = new HashMap<String, Permission>();
        for (Pair p : perm2) {
            perm2Map.put((String)p.getFirst(), (Permission)p.getSecond());
        }
        for (Pair p : perm1) {
            Assert.assertTrue((boolean)perm2Map.containsKey(p.getFirst()));
            perm = (Permission)perm2Map.get(p.getFirst());
            Assert.assertEquals((Object)perm, (Object)p.getSecond());
        }
    }

    private void assertGroupPermissionsEqual(Project p1, Project p2) {
        Permission perm;
        List perm1 = p1.getGroupPermissions();
        List perm2 = p2.getGroupPermissions();
        Assert.assertEquals((long)perm1.size(), (long)perm2.size());
        HashMap<String, Permission> perm1Map = new HashMap<String, Permission>();
        for (Pair p : perm1) {
            perm1Map.put((String)p.getFirst(), (Permission)p.getSecond());
        }
        for (Pair p : perm2) {
            Assert.assertTrue((boolean)perm1Map.containsKey(p.getFirst()));
            perm = (Permission)perm1Map.get(p.getFirst());
            Assert.assertEquals((Object)perm, (Object)p.getSecond());
        }
        HashMap<String, Permission> perm2Map = new HashMap<String, Permission>();
        for (Pair p : perm2) {
            perm2Map.put((String)p.getFirst(), (Permission)p.getSecond());
        }
        for (Pair p : perm1) {
            Assert.assertTrue((boolean)perm2Map.containsKey(p.getFirst()));
            perm = (Permission)perm2Map.get(p.getFirst());
            Assert.assertEquals((Object)perm, (Object)p.getSecond());
        }
    }

    private ProjectLoader createLoader() {
        Props props = new Props();
        props.put("database.type", "mysql");
        props.put("mysql.host", "localhost");
        props.put("mysql.port", Integer.valueOf(3306));
        props.put("mysql.user", "azkaban");
        props.put("mysql.database", "test");
        props.put("mysql.password", "azkaban");
        props.put("mysql.numconnections", Integer.valueOf(10));
        return new JdbcProjectLoader(props);
    }

    private boolean isTestSetup() {
        if (!testDBExists) {
            System.err.println("Skipping DB test because Db not setup.");
            return false;
        }
        System.out.println("Running DB test because Db setup.");
        return true;
    }
}

