/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils.cache;

import azkaban.utils.cache.Cache;
import java.util.HashSet;
import java.util.Set;

public class CacheManager {
    private static final long UPDATE_FREQUENCY = 30000L;
    private long updateFrequency = 30000L;
    private Set<Cache> caches;
    private static CacheManager manager = null;
    private final CacheManagerThread updaterThread = new CacheManagerThread();
    private boolean activeExpiry = false;

    public static CacheManager getInstance() {
        if (manager == null) {
            manager = new CacheManager();
        }
        return manager;
    }

    private CacheManager() {
        this.caches = new HashSet<Cache>();
        this.updaterThread.start();
    }

    public static void setUpdateFrequency(long updateFreqMs) {
        manager.internalUpdateFrequency(updateFreqMs);
    }

    public static void shutdown() {
        manager.internalShutdown();
    }

    public Cache createCache() {
        Cache cache = new Cache(manager);
        manager.internalAddCache(cache);
        return cache;
    }

    public void removeCache(Cache cache) {
        manager.internalRemoveCache(cache);
    }

    private void internalUpdateFrequency(long updateFreq) {
        this.updateFrequency = updateFreq;
        this.updaterThread.interrupt();
    }

    private void internalAddCache(Cache cache) {
        this.caches.add(cache);
        this.updaterThread.interrupt();
    }

    private void internalRemoveCache(Cache cache) {
        this.caches.remove(cache);
    }

    private synchronized void internalShutdown() {
        this.updaterThread.shutdown();
    }

    synchronized void update() {
        boolean activeExpiry = false;
        for (Cache cache : this.caches) {
            if (cache.getExpireTimeToIdle() <= 0L && cache.getExpireTimeToLive() <= 0L) continue;
            activeExpiry = true;
            break;
        }
        if (this.activeExpiry != activeExpiry && activeExpiry) {
            this.activeExpiry = activeExpiry;
            this.updaterThread.interrupt();
        }
    }

    private class CacheManagerThread
    extends Thread {
        private boolean shutdown = false;

        private CacheManagerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.shutdown) {
                CacheManagerThread cacheManagerThread;
                if (CacheManager.this.activeExpiry) {
                    for (Cache cache : CacheManager.this.caches) {
                        cache.expireCache();
                    }
                    cacheManagerThread = this;
                    synchronized (cacheManagerThread) {
                        try {
                            this.wait(CacheManager.this.updateFrequency);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                cacheManagerThread = this;
                synchronized (cacheManagerThread) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        public void shutdown() {
            this.shutdown = true;
            CacheManager.this.updaterThread.interrupt();
        }
    }
}

