/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.streaming;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.pig.PigToStream;
import org.apache.pig.data.Tuple;

public abstract class InputHandler {
    protected PigToStream serializer;
    private OutputStream out;
    protected boolean alreadyClosed = false;

    public abstract InputType getInputType();

    public void putNext(Tuple t) throws IOException {
        this.out.write(this.serializer.serialize(t));
    }

    public synchronized void close(Process process) throws IOException {
        if (!this.alreadyClosed) {
            this.alreadyClosed = true;
            this.out.flush();
            this.out.close();
            this.out = null;
        }
    }

    public void bindTo(OutputStream os) throws IOException {
        this.out = os;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InputType {
        SYNCHRONOUS,
        ASYNCHRONOUS;

    }
}

