/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.optimizer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.relational.LOCogroup;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LOSplitOutput;
import org.apache.pig.newplan.logical.relational.LogicalPlan;

public class LogicalPlanPrinter
extends PlanVisitor {
    private PrintStream mStream = null;
    private String TAB1 = "    ";
    private String TABMore = "|   ";
    private String LSep = "|\n|---";
    private String USep = "|   |\n|   ";
    public static String SEPERATE = "\t";

    public LogicalPlanPrinter(OperatorPlan plan, PrintStream ps) throws FrontendException {
        super(plan, null);
        this.mStream = ps;
    }

    public void visit() throws FrontendException {
        try {
            if (this.plan instanceof LogicalPlan) {
                this.mStream.write(this.depthFirstLP().getBytes());
            } else {
                this.mStream.write(this.reverseDepthFirstLP().getBytes());
            }
        }
        catch (IOException e) {
            throw new FrontendException(e);
        }
    }

    protected String depthFirstLP() throws FrontendException, IOException {
        StringBuilder sb = new StringBuilder();
        List<Operator> leaves = this.plan.getSinks();
        for (Operator leaf : leaves) {
            sb.append(this.depthFirst(leaf));
            sb.append("\n");
        }
        return sb.toString();
    }

    private String depthFirst(Operator node) throws FrontendException, IOException {
        String nodeString = this.printNode(node);
        List<Operator> originalPredecessors = this.plan.getPredecessors(node);
        if (originalPredecessors == null) {
            return nodeString;
        }
        StringBuffer sb = new StringBuffer(nodeString);
        ArrayList<Operator> predecessors = new ArrayList<Operator>(originalPredecessors);
        int i = 0;
        for (Operator pred : predecessors) {
            ++i;
            String DFStr = this.depthFirst(pred);
            if (DFStr == null) continue;
            sb.append(this.LSep);
            if (i < predecessors.size()) {
                sb.append(this.shiftStringByTabs(DFStr, 2));
                continue;
            }
            sb.append(this.shiftStringByTabs(DFStr, 1));
        }
        return sb.toString();
    }

    protected String reverseDepthFirstLP() throws FrontendException, IOException {
        StringBuilder sb = new StringBuilder();
        List<Operator> roots = this.plan.getSources();
        for (Operator root : roots) {
            sb.append(this.reverseDepthFirst(root));
            sb.append("\n");
        }
        return sb.toString();
    }

    private String reverseDepthFirst(Operator node) throws FrontendException, IOException {
        String nodeString = this.printNode(node);
        List<Operator> originalSuccessors = this.plan.getSuccessors(node);
        if (originalSuccessors == null) {
            return nodeString;
        }
        StringBuffer sb = new StringBuffer(nodeString);
        ArrayList<Operator> successors = new ArrayList<Operator>(originalSuccessors);
        int i = 0;
        for (Operator succ : successors) {
            ++i;
            String DFStr = this.reverseDepthFirst(succ);
            if (DFStr == null) continue;
            sb.append(this.LSep);
            if (i < successors.size()) {
                sb.append(this.shiftStringByTabs(DFStr, 2));
                continue;
            }
            sb.append(this.shiftStringByTabs(DFStr, 1));
        }
        return sb.toString();
    }

    private String planString(OperatorPlan lp) throws VisitorException, IOException {
        StringBuilder sb = new StringBuilder();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        if (lp == null) {
            return "";
        }
        LogicalPlanPrinter printer = new LogicalPlanPrinter(lp, ps);
        printer.visit();
        sb.append(this.USep);
        sb.append(this.shiftStringByTabs(baos.toString(), 2));
        return sb.toString();
    }

    private String printNode(Operator node) throws FrontendException, IOException {
        StringBuilder sb;
        block7: {
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block6: {
                                    sb = new StringBuilder(node.toString() + "\n");
                                    if (!(node instanceof LOFilter)) break block6;
                                    sb.append(this.planString(((LOFilter)node).getFilterPlan()));
                                    break block7;
                                }
                                if (!(node instanceof LOForEach)) break block8;
                                sb.append(this.planString(((LOForEach)node).getInnerPlan()));
                                break block7;
                            }
                            if (!(node instanceof LOCogroup)) break block9;
                            MultiMap<Integer, LogicalExpressionPlan> plans = ((LOCogroup)node).getExpressionPlans();
                            for (int i : plans.keySet()) {
                                for (LogicalExpressionPlan plan : plans.get(i)) {
                                    sb.append(this.planString(plan));
                                }
                            }
                            break block7;
                        }
                        if (!(node instanceof LOJoin)) break block10;
                        MultiMap<Integer, LogicalExpressionPlan> plans = ((LOJoin)node).getExpressionPlans();
                        for (int i : plans.keySet()) {
                            for (LogicalExpressionPlan plan : plans.get(i)) {
                                sb.append(this.planString(plan));
                            }
                        }
                        break block7;
                    }
                    if (!(node instanceof LOSort)) break block11;
                    for (LogicalExpressionPlan plan : ((LOSort)node).getSortColPlans()) {
                        sb.append(this.planString(plan));
                    }
                    break block7;
                }
                if (!(node instanceof LOSplitOutput)) break block12;
                sb.append(this.planString(((LOSplitOutput)node).getFilterPlan()));
                break block7;
            }
            if (!(node instanceof LOGenerate)) break block7;
            for (LogicalExpressionPlan plan : ((LOGenerate)node).getOutputPlans()) {
                sb.append(this.planString(plan));
            }
        }
        return sb.toString();
    }

    private String shiftStringByTabs(String DFStr, int TabType) {
        StringBuilder sb = new StringBuilder();
        String[] spl = DFStr.split("\n");
        String tab = TabType == 1 ? this.TAB1 : this.TABMore;
        sb.append(spl[0] + "\n");
        for (int i = 1; i < spl.length; ++i) {
            sb.append(tab);
            sb.append(spl[i]);
            sb.append("\n");
        }
        return sb.toString();
    }
}

