/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly.chunk;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.log4j.Logger;
import voldemort.store.readonly.chunk.DataFileChunk;
import voldemort.store.readonly.chunk.DataFileChunkSet;
import voldemort.utils.ClosableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DataFileChunkSetIterator<T>
implements ClosableIterator<T> {
    private static Logger logger = Logger.getLogger(DataFileChunkSetIterator.class);
    private DataFileChunkSet dataFileChunkSet;
    private int currentChunk;
    private long currentOffsetInChunk;
    private boolean chunksFinished;
    protected boolean coalesceCollided;
    private short tupleCount;
    private ReadWriteLock fileModificationLock;

    public DataFileChunkSetIterator(DataFileChunkSet dataFileChunkSet, boolean coalesceCollided) {
        this(dataFileChunkSet, coalesceCollided, null);
    }

    public DataFileChunkSetIterator(DataFileChunkSet dataFileChunkSet, boolean coalesceCollided, ReadWriteLock fileModificationLock) {
        this.dataFileChunkSet = dataFileChunkSet;
        this.currentChunk = 0;
        this.currentOffsetInChunk = 0L;
        this.tupleCount = 0;
        this.chunksFinished = false;
        this.fileModificationLock = fileModificationLock;
        this.coalesceCollided = coalesceCollided;
        if (this.fileModificationLock != null) {
            this.fileModificationLock.readLock().lock();
        }
    }

    @Override
    public void close() {
        if (this.fileModificationLock != null) {
            this.fileModificationLock.readLock().unlock();
        }
    }

    @Override
    public abstract T next();

    protected DataFileChunk getCurrentChunk() {
        return this.dataFileChunkSet.dataFileFor(this.currentChunk);
    }

    protected long getCurrentOffsetInChunk() {
        return this.currentOffsetInChunk;
    }

    @Override
    public boolean hasNext() {
        if (this.chunksFinished) {
            return false;
        }
        if (this.currentOffsetInChunk >= (long)this.dataFileChunkSet.getDataFileSize(this.currentChunk)) {
            ++this.currentChunk;
            this.currentOffsetInChunk = 0L;
            while (this.currentChunk < this.dataFileChunkSet.getNumChunks() && this.dataFileChunkSet.getDataFileSize(this.currentChunk) == 0) {
                ++this.currentChunk;
            }
            if (this.currentChunk == this.dataFileChunkSet.getNumChunks()) {
                this.chunksFinished = true;
                return false;
            }
        }
        if (!this.coalesceCollided && this.tupleCount == 0) {
            ByteBuffer numKeyValsBuffer = ByteBuffer.allocate(2);
            try {
                this.getCurrentChunk().read(numKeyValsBuffer, this.currentOffsetInChunk);
            }
            catch (IOException e) {
                logger.error((Object)"Error while reading tuple count in iterator", (Throwable)e);
                return false;
            }
            this.tupleCount = numKeyValsBuffer.getShort(0);
            this.currentOffsetInChunk += 2L;
        }
        return true;
    }

    public void updateOffset(long updatedOffset) {
        if (!this.coalesceCollided) {
            this.tupleCount = (short)(this.tupleCount - 1);
        }
        this.currentOffsetInChunk = updatedOffset;
        this.hasNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from these read-only data chunks");
    }
}

