/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.serialized;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import voldemort.VoldemortException;
import voldemort.serialization.Serializer;
import voldemort.store.Store;
import voldemort.store.StoreCapabilityType;
import voldemort.store.StoreUtils;
import voldemort.utils.ByteArray;
import voldemort.utils.Utils;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializingStore<K, V, T>
implements Store<K, V, T> {
    private final Store<ByteArray, byte[], byte[]> store;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private final Serializer<T> transformsSerializer;

    public SerializingStore(Store<ByteArray, byte[], byte[]> store, Serializer<K> keySerializer, Serializer<V> valueSerializer, Serializer<T> transformsSerializer) {
        this.store = Utils.notNull(store);
        this.keySerializer = Utils.notNull(keySerializer);
        this.valueSerializer = Utils.notNull(valueSerializer);
        this.transformsSerializer = transformsSerializer;
    }

    public static <K1, V1, T1> SerializingStore<K1, V1, T1> wrap(Store<ByteArray, byte[], byte[]> s, Serializer<K1> k, Serializer<V1> v, Serializer<T1> t) {
        return new SerializingStore<K1, V1, T1>(s, k, v, t);
    }

    @Override
    public boolean delete(K key, Version version) throws VoldemortException {
        return this.store.delete(this.keyToBytes(key), version);
    }

    private ByteArray keyToBytes(K key) {
        return new ByteArray(this.keySerializer.toBytes(key));
    }

    private Map<ByteArray, K> keysToBytes(Iterable<K> keys) {
        HashMap<ByteArray, K> result = StoreUtils.newEmptyHashMap(keys);
        for (K key : keys) {
            result.put(this.keyToBytes(key), key);
        }
        return result;
    }

    private byte[] transformToBytes(T transform) {
        if (transform == null) {
            return null;
        }
        if (this.transformsSerializer == null) {
            return null;
        }
        return this.transformsSerializer.toBytes(transform);
    }

    private Map<ByteArray, byte[]> transformsToBytes(Map<K, T> transforms) {
        if (transforms == null) {
            return null;
        }
        HashMap result = Maps.newHashMap();
        for (Map.Entry<K, T> transform : transforms.entrySet()) {
            result.put(this.keyToBytes(transform.getKey()), this.transformToBytes(transform.getValue()));
        }
        return result;
    }

    @Override
    public List<Versioned<V>> get(K key, T transforms) throws VoldemortException {
        List<Versioned<byte[]>> found = this.store.get(this.keyToBytes(key), this.transformsSerializer != null && transforms != null ? this.transformsSerializer.toBytes(transforms) : null);
        ArrayList<Versioned<V>> results = new ArrayList<Versioned<V>>(found.size());
        for (Versioned<byte[]> versioned : found) {
            results.add(new Versioned<V>(this.valueSerializer.toObject(versioned.getValue()), versioned.getVersion()));
        }
        return results;
    }

    @Override
    public Map<K, List<Versioned<V>>> getAll(Iterable<K> keys, Map<K, T> transforms) throws VoldemortException {
        StoreUtils.assertValidKeys(keys);
        Map<ByteArray, K> byteKeyToKey = this.keysToBytes(keys);
        Map<ByteArray, List<Versioned<byte[]>>> storeResult = this.store.getAll(byteKeyToKey.keySet(), this.transformsToBytes(transforms));
        HashMap result = Maps.newHashMapWithExpectedSize((int)storeResult.size());
        for (Map.Entry<ByteArray, List<Versioned<byte[]>>> mapEntry : storeResult.entrySet()) {
            ArrayList values = Lists.newArrayListWithExpectedSize((int)mapEntry.getValue().size());
            for (Versioned<byte[]> versioned : mapEntry.getValue()) {
                values.add(new Versioned<V>(this.valueSerializer.toObject(versioned.getValue()), versioned.getVersion()));
            }
            result.put(byteKeyToKey.get(mapEntry.getKey()), values);
        }
        return result;
    }

    @Override
    public String getName() {
        return this.store.getName();
    }

    @Override
    public void put(K key, Versioned<V> value, T transforms) throws VoldemortException {
        this.store.put(this.keyToBytes(key), new Versioned<byte[]>(this.valueSerializer.toBytes(value.getValue()), value.getVersion()), this.transformToBytes(transforms));
    }

    @Override
    public List<Version> getVersions(K key) {
        return this.store.getVersions(this.keyToBytes(key));
    }

    @Override
    public void close() {
        this.store.close();
    }

    protected Serializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    protected Serializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    @Override
    public Object getCapability(StoreCapabilityType capability) {
        switch (capability) {
            case KEY_SERIALIZER: {
                return this.keySerializer;
            }
            case VALUE_SERIALIZER: {
                return this.valueSerializer;
            }
        }
        return this.store.getCapability(capability);
    }
}

