/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.slop.strategy;

import voldemort.VoldemortException;
import voldemort.cluster.Cluster;
import voldemort.store.StoreDefinition;
import voldemort.store.slop.strategy.ConsistentHandoffStrategy;
import voldemort.store.slop.strategy.HandoffToAnyStrategy;
import voldemort.store.slop.strategy.HintedHandoffStrategy;
import voldemort.store.slop.strategy.HintedHandoffStrategyType;
import voldemort.store.slop.strategy.ProximityHandoffStrategy;

public class HintedHandoffStrategyFactory {
    private final boolean enableZoneRouting;
    private final int clientZoneId;

    public HintedHandoffStrategyFactory(boolean enableZoneRouting, int clientZoneId) {
        this.enableZoneRouting = enableZoneRouting;
        this.clientZoneId = clientZoneId;
    }

    public HintedHandoffStrategy updateHintedHandoffStrategy(StoreDefinition storeDef, Cluster cluster) {
        if (HintedHandoffStrategyType.CONSISTENT_STRATEGY.toDisplay().compareTo(storeDef.getHintedHandoffStrategyType().toDisplay()) == 0) {
            Integer hintPrefListSize = storeDef.getHintPrefListSize();
            if (null == hintPrefListSize) {
                hintPrefListSize = cluster.getNumberOfNodes() == storeDef.getReplicationFactor() ? Integer.valueOf(storeDef.getReplicationFactor() - 1) : Integer.valueOf(storeDef.getReplicationFactor());
            }
            return new ConsistentHandoffStrategy(cluster, hintPrefListSize, this.enableZoneRouting, this.clientZoneId);
        }
        if (HintedHandoffStrategyType.ANY_STRATEGY.toDisplay().compareTo(storeDef.getHintedHandoffStrategyType().toDisplay()) == 0) {
            return new HandoffToAnyStrategy(cluster, this.enableZoneRouting, this.clientZoneId);
        }
        if (HintedHandoffStrategyType.PROXIMITY_STRATEGY.toDisplay().compareTo(storeDef.getHintedHandoffStrategyType().toDisplay()) == 0) {
            return new ProximityHandoffStrategy(cluster, this.clientZoneId);
        }
        throw new VoldemortException("HintedHandoffStrategyType:" + (Object)((Object)storeDef.getHintedHandoffStrategyType()) + " not handled by " + this.getClass());
    }
}

