/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.parameters;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.tools.parameters.ParamLoader;
import org.apache.pig.tools.parameters.ParseException;
import org.apache.pig.tools.parameters.PigFileParser;
import org.apache.pig.tools.parameters.PreprocessorContext;

public class ParameterSubstitutionPreprocessor {
    private PreprocessorContext pc;
    private final Log log = LogFactory.getLog(this.getClass());
    private ParamLoader paramParser;
    private PigFileParser pigParser;

    public ParameterSubstitutionPreprocessor(int limit) {
        this.pc = new PreprocessorContext(50);
        Reader sr = null;
        this.paramParser = new ParamLoader(sr);
        this.paramParser.setContext(this.pc);
        this.pigParser = new PigFileParser(sr);
        this.pigParser.setContext(this.pc);
    }

    public void genSubstitutedFile(BufferedReader pigInput, Writer pigOutput, String[] args, String[] argFiles) throws ParseException {
        int i;
        if (argFiles != null) {
            for (i = 0; i < argFiles.length; ++i) {
                if (argFiles[i].length() <= 0) continue;
                this.loadParamsFromFile(argFiles[i]);
            }
        }
        if (args != null) {
            for (i = 0; i < args.length; ++i) {
                if (args[i].length() <= 0) continue;
                this.loadParamsFromCmdline(args[i]);
            }
        }
        String line = null;
        StringBuilder blder = new StringBuilder();
        try {
            while ((line = pigInput.readLine()) != null) {
                blder.append(line).append("\n");
            }
        }
        catch (IOException e) {
            throw new ParseException(e.getMessage());
        }
        pigInput = new BufferedReader(new StringReader(blder.toString()));
        this.parsePigFile(pigInput, pigOutput);
    }

    private void parsePigFile(BufferedReader in, Writer out) throws ParseException {
        this.pigParser.setOutputWriter(out);
        this.pigParser.ReInit(in);
        try {
            this.pigParser.Parse();
            in.close();
            out.flush();
            out.close();
        }
        catch (IOException e) {
            RuntimeException rte = new RuntimeException(e.getMessage(), e);
            throw rte;
        }
    }

    private void loadParamsFromFile(String filename) throws ParseException {
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            this.paramParser.ReInit(in);
            while (this.paramParser.Parse()) {
            }
            in.close();
        }
        catch (IOException e) {
            RuntimeException rte = new RuntimeException(e.getMessage(), e);
            throw rte;
        }
    }

    private void loadParamsFromCmdline(String line) throws ParseException {
        try {
            this.paramParser.ReInit(new StringReader(line));
            this.paramParser.Parse();
        }
        catch (IOException e) {
            RuntimeException rte = new RuntimeException(e.getMessage(), e);
            throw rte;
        }
    }
}

