/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.storage;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import voldemort.annotations.jmx.JmxOperation;
import voldemort.cluster.Node;
import voldemort.routing.RoutingStrategy;
import voldemort.routing.RoutingStrategyFactory;
import voldemort.server.StoreRepository;
import voldemort.server.storage.ScanPermitWrapper;
import voldemort.store.StorageEngine;
import voldemort.store.StoreDefinition;
import voldemort.store.metadata.MetadataStore;
import voldemort.utils.ByteArray;
import voldemort.utils.ClosableIterator;
import voldemort.utils.Pair;
import voldemort.utils.Utils;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepairJob
implements Runnable {
    private static final int DELETE_BATCH_SIZE = 10000;
    private static final Logger logger = Logger.getLogger((String)RepairJob.class.getName());
    public static final List<String> blackList = Arrays.asList("mysql", "krati", "read-only");
    private final ScanPermitWrapper repairPermits;
    private final StoreRepository storeRepo;
    private final MetadataStore metadataStore;
    private final int deleteBatchSize;

    public RepairJob(StoreRepository storeRepo, MetadataStore metadataStore, ScanPermitWrapper repairPermits, int deleteBatchSize) {
        this.storeRepo = storeRepo;
        this.metadataStore = metadataStore;
        this.repairPermits = Utils.notNull(repairPermits);
        this.deleteBatchSize = deleteBatchSize;
    }

    public RepairJob(StoreRepository storeRepo, MetadataStore metadataStore, ScanPermitWrapper repairPermits) {
        this(storeRepo, metadataStore, repairPermits, 10000);
    }

    @JmxOperation(description="Start the Repair Job thread", impact=1)
    public void startRepairJob() {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (!this.metadataStore.getServerState().equals((Object)MetadataStore.VoldemortState.NORMAL_SERVER)) {
            logger.error((Object)"Cannot run repair job since Voldemort server is not in normal state");
            return;
        }
        ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> iterator = null;
        Date startTime = new Date();
        logger.info((Object)("Started repair job at " + startTime));
        HashMap localStats = Maps.newHashMap();
        for (StoreDefinition storeDef : this.metadataStore.getStoreDefList()) {
            localStats.put(storeDef.getName(), 0L);
        }
        AtomicLong progress = new AtomicLong(0L);
        if (!this.acquireRepairPermit(progress)) {
            return;
        }
        try {
            try {
                RoutingStrategyFactory routingStrategyFactory = new RoutingStrategyFactory();
                for (StoreDefinition storeDef : this.metadataStore.getStoreDefList()) {
                    if (!this.isWritableStore(storeDef)) continue;
                    logger.info((Object)("Repairing store " + storeDef.getName()));
                    StorageEngine<ByteArray, byte[], byte[]> engine = this.storeRepo.getStorageEngine(storeDef.getName());
                    iterator = engine.entries();
                    RoutingStrategy routingStrategy = routingStrategyFactory.updateRoutingStrategy(storeDef, this.metadataStore.getCluster());
                    long repairSlops = 0L;
                    long numDeletedKeys = 0L;
                    while (iterator.hasNext()) {
                        long itemsScanned;
                        Pair keyAndVal = (Pair)iterator.next();
                        List<Node> nodes = routingStrategy.routeRequest(((ByteArray)keyAndVal.getFirst()).get());
                        if (!this.hasDestination(nodes)) {
                            engine.delete((ByteArray)keyAndVal.getFirst(), ((Versioned)keyAndVal.getSecond()).getVersion());
                            ++numDeletedKeys;
                        }
                        if ((itemsScanned = progress.incrementAndGet()) % (long)this.deleteBatchSize != 0L) continue;
                        logger.info((Object)("#Scanned:" + itemsScanned + " #Deleted:" + numDeletedKeys));
                    }
                    this.closeIterator(iterator);
                    localStats.put(storeDef.getName(), repairSlops);
                    logger.info((Object)("Completed store " + storeDef.getName()));
                }
                Object var19_16 = null;
                this.closeIterator(iterator);
                this.repairPermits.release();
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                Object var19_17 = null;
                this.closeIterator(iterator);
                this.repairPermits.release();
                logger.info((Object)("Completed repair job started at " + startTime));
                return;
            }
        }
        catch (Throwable throwable) {
            Object var19_18 = null;
            this.closeIterator(iterator);
            this.repairPermits.release();
            logger.info((Object)("Completed repair job started at " + startTime));
            throw throwable;
        }
        logger.info((Object)("Completed repair job started at " + startTime));
    }

    private void closeIterator(ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> iterator) {
        try {
            if (iterator != null) {
                iterator.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error in closing iterator", (Throwable)e);
        }
    }

    private boolean hasDestination(List<Node> nodes) {
        for (Node node : nodes) {
            if (node.getId() != this.metadataStore.getNodeId()) continue;
            return true;
        }
        return false;
    }

    private boolean isWritableStore(StoreDefinition storeDef) {
        return !storeDef.isView() && !blackList.contains(storeDef.getType());
    }

    private boolean acquireRepairPermit(AtomicLong progress) {
        logger.info((Object)"Acquiring lock to perform repair job ");
        if (this.repairPermits.tryAcquire(progress)) {
            logger.info((Object)"Acquired lock to perform repair job ");
            return true;
        }
        logger.error((Object)"Aborting Repair Job since another instance is already running! ");
        return false;
    }
}

