/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.bdb.stats;

import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.StatsConfig;
import java.util.concurrent.Callable;
import voldemort.VoldemortException;
import voldemort.annotations.jmx.JmxGetter;
import voldemort.store.bdb.stats.SpaceUtilizationStats;
import voldemort.utils.CachedCallable;

public class BdbEnvironmentStats {
    private final Environment environment;
    private final CachedCallable<EnvironmentStats> fastStats;
    private final CachedCallable<SpaceUtilizationStats> fastSpaceStats;
    private final boolean exposeSpaceStats;

    public BdbEnvironmentStats(Environment environment, long ttlMs, boolean exposeSpaceUtil) {
        this.environment = environment;
        this.exposeSpaceStats = exposeSpaceUtil;
        Callable<EnvironmentStats> fastStatsCallable = new Callable<EnvironmentStats>(){

            @Override
            public EnvironmentStats call() throws Exception {
                return BdbEnvironmentStats.this.getEnvironmentStats(true);
            }
        };
        this.fastStats = new CachedCallable<EnvironmentStats>(fastStatsCallable, ttlMs);
        Callable<SpaceUtilizationStats> fastDbStatsCallable = new Callable<SpaceUtilizationStats>(){

            @Override
            public SpaceUtilizationStats call() throws Exception {
                return BdbEnvironmentStats.this.getSpaceUtilizationStats();
            }
        };
        this.fastSpaceStats = new CachedCallable<SpaceUtilizationStats>(fastDbStatsCallable, ttlMs);
    }

    private EnvironmentStats getEnvironmentStats(boolean fast) {
        StatsConfig config = new StatsConfig();
        config.setFast(fast);
        return this.environment.getStats(config);
    }

    private SpaceUtilizationStats getSpaceUtilizationStats() {
        return new SpaceUtilizationStats(this.environment);
    }

    private SpaceUtilizationStats getFastSpaceUtilizationStats() {
        try {
            return this.fastSpaceStats.call();
        }
        catch (Exception e) {
            throw new VoldemortException(e);
        }
    }

    private EnvironmentStats getFastStats() {
        try {
            return this.fastStats.call();
        }
        catch (Exception e) {
            throw new VoldemortException(e);
        }
    }

    @JmxGetter(name="FastStatsAsString")
    public String getFastStatsAsString() {
        return this.getFastStats().toString();
    }

    @JmxGetter(name="NumCacheMiss")
    public long getNumCacheMiss() {
        return this.getFastStats().getNCacheMiss();
    }

    @JmxGetter(name="NumNotResident")
    public long getNumNotResident() {
        return this.getFastStats().getNNotResident();
    }

    @JmxGetter(name="TotalCacheSize")
    public long getTotalCacheSize() {
        return this.getFastStats().getSharedCacheTotalBytes();
    }

    @JmxGetter(name="AllotedCacheSize")
    public long getAllotedCacheSize() {
        return this.getFastStats().getCacheTotalBytes();
    }

    @JmxGetter(name="EvictionPasses")
    public long getEvictedLNs() {
        return this.getFastStats().getNEvictPasses();
    }

    @JmxGetter(name="NumRandomWrites")
    public long getNumRandomWrites() {
        return this.getFastStats().getNRandomWrites();
    }

    @JmxGetter(name="NumRandomWriteBytes")
    public long getNumRandomWriteBytes() {
        return this.getFastStats().getNRandomWriteBytes();
    }

    @JmxGetter(name="NumRandomReads")
    public long getNumRandomReads() {
        return this.getFastStats().getNRandomReads();
    }

    @JmxGetter(name="NumRandomReadBytes")
    public long getNumRandomReadBytes() {
        return this.getFastStats().getNRandomReadBytes();
    }

    @JmxGetter(name="NumSequentialWrites")
    public long getNumSequentialWrites() {
        return this.getFastStats().getNSequentialWrites();
    }

    @JmxGetter(name="NumSequentialWriteBytes")
    public long getNumSequentialWriteBytes() {
        return this.getFastStats().getNSequentialWriteBytes();
    }

    @JmxGetter(name="NumSequentialReads")
    public long getNumSequentialReads() {
        return this.getFastStats().getNSequentialReads();
    }

    @JmxGetter(name="NumSequentialReadBytes")
    public long getNumSequentialReadBytes() {
        return this.getFastStats().getNSequentialReadBytes();
    }

    @JmxGetter(name="NumFSyncs")
    public long getNumFSyncs() {
        return this.getFastStats().getNFSyncs();
    }

    @JmxGetter(name="NumCleanerEntriesRead")
    public long getNumCleanerEntriesRead() {
        return this.getFastStats().getNCleanerEntriesRead();
    }

    @JmxGetter(name="FileDeletionBacklog")
    public long getFileDeletionBacklog() {
        return this.getFastStats().getFileDeletionBacklog();
    }

    @JmxGetter(name="FileDeletionBacklogBytes")
    public long getFileDeletionBacklogBytes() {
        String logFileMaxStr = this.environment.getConfig().getConfigParam("je.log.fileMax");
        long logFileMax = Long.parseLong(logFileMaxStr);
        return this.getFileDeletionBacklog() * logFileMax;
    }

    @JmxGetter(name="CleanerBacklog")
    public long getCleanerBacklog() {
        return this.getFastStats().getCleanerBacklog();
    }

    @JmxGetter(name="NumCleanerRuns")
    public long getNumCleanerRuns() {
        return this.getFastStats().getNCleanerRuns();
    }

    @JmxGetter(name="NumCleanerDeletions")
    public long getNumCleanerDeletions() {
        return this.getFastStats().getNCleanerRuns();
    }

    @JmxGetter(name="NumCheckpoints")
    public long getNumCheckpoints() {
        return this.getFastStats().getNCheckpoints();
    }

    @JmxGetter(name="TotalSpace")
    public long getTotalSpace() {
        if (this.exposeSpaceStats) {
            return this.getFastSpaceUtilizationStats().getTotalSpaceUsed();
        }
        return 0L;
    }

    @JmxGetter(name="TotalSpaceUtilized")
    public long getTotalSpaceUtilized() {
        if (this.exposeSpaceStats) {
            return this.getFastSpaceUtilizationStats().getTotalSpaceUtilized();
        }
        return 0L;
    }

    @JmxGetter(name="UtilizationSummary", description="Displays the disk space utilization for an environment.")
    public String getUtilizationSummaryAsString() {
        return this.getFastSpaceUtilizationStats().getSummariesAsString();
    }

    @JmxGetter(name="BtreeLatches")
    public long getBtreeLatches() {
        return this.getFastStats().getRelatchesRequired();
    }

    @JmxGetter(name="NumAcquiresWithContention")
    public long getNumAcquiresWithContention() {
        return this.getFastStats().getNAcquiresWithContention();
    }

    @JmxGetter(name="NumAcquiresNoWaiters")
    public long getNumAcquiresNoWaiters() {
        return this.getFastStats().getNAcquiresNoWaiters();
    }

    @JmxGetter(name="NumWritesTotal")
    public long getNumWritesTotal() {
        return this.getNumRandomWrites() + this.getNumSequentialWrites();
    }

    @JmxGetter(name="NumWriteBytesTotal")
    public long getNumWriteBytesTotal() {
        return this.getNumSequentialWriteBytes() + this.getNumRandomWriteBytes();
    }

    @JmxGetter(name="PercentRandomWrites")
    public double getPercentRandomWrites() {
        return BdbEnvironmentStats.safeGetPercentage(this.getNumRandomWrites(), this.getNumWritesTotal());
    }

    @JmxGetter(name="PercentageRandomWriteBytes")
    public double getPercentageRandomWriteBytes() {
        return BdbEnvironmentStats.safeGetPercentage(this.getNumRandomWriteBytes(), this.getNumRandomWriteBytes() + this.getNumSequentialWriteBytes());
    }

    @JmxGetter(name="NumReadsTotal")
    public long getNumReadsTotal() {
        return this.getNumRandomReads() + this.getNumSequentialReads();
    }

    @JmxGetter(name="NumReadBytesTotal")
    public long getNumReadBytesTotal() {
        return this.getNumRandomReadBytes() + this.getNumSequentialReadBytes();
    }

    @JmxGetter(name="PercentageRandomReads")
    public double getPercentageRandomReads() {
        return BdbEnvironmentStats.safeGetPercentage(this.getNumRandomReads(), this.getNumReadsTotal());
    }

    @JmxGetter(name="PercentageRandomReadBytes")
    public double getPercentageRandomReadBytes() {
        return BdbEnvironmentStats.safeGetPercentage(this.getNumRandomWriteBytes(), this.getNumRandomReadBytes() + this.getNumSequentialReadBytes());
    }

    @JmxGetter(name="PercentageReads")
    public double getPercentageReads() {
        return BdbEnvironmentStats.safeGetPercentage(this.getNumReadsTotal(), this.getNumReadsTotal() + this.getNumWritesTotal());
    }

    @JmxGetter(name="PercentageReadBytes")
    public double getPercentageReadBytes() {
        return BdbEnvironmentStats.safeGetPercentage(this.getNumReadBytesTotal(), this.getNumWriteBytesTotal() + this.getNumReadBytesTotal());
    }

    @JmxGetter(name="PercentageCacheHits")
    public double getPercentageCacheHits() {
        return 1.0 - this.getPercentageCacheMisses();
    }

    @JmxGetter(name="PercentageCacheMisses")
    public double getPercentageCacheMisses() {
        return BdbEnvironmentStats.safeGetPercentage(this.getNumCacheMiss(), this.getNumReadsTotal() + this.getNumWritesTotal());
    }

    @JmxGetter(name="PercentageContended")
    public double getPercentageContended() {
        return BdbEnvironmentStats.safeGetPercentage(this.getNumAcquiresWithContention(), this.getNumAcquiresWithContention() + this.getNumAcquiresNoWaiters());
    }

    @JmxGetter(name="PercentageUtilization")
    public double getPercentageUtilization() {
        return BdbEnvironmentStats.safeGetPercentage(this.getTotalSpaceUtilized(), this.getTotalSpace());
    }

    public static double safeGetPercentage(long rawNum, long total) {
        return total == 0L ? 0.0 : (double)((float)rawNum / (float)total);
    }
}

