/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import org.apache.log4j.Logger;

public class JNAUtils {
    private static final Logger logger = Logger.getLogger(JNAUtils.class);
    private static final int MCL_CURRENT = 1;
    private static final int MCL_FUTURE = 2;
    private static final int ENOMEM = 12;

    private static native int mlockall(int var0) throws LastErrorException;

    private static native int munlockall() throws LastErrorException;

    private static boolean isOperatingSystem(String os) {
        return System.getProperty("os.name").toLowerCase().contains(os);
    }

    public static void tryMlockall() {
        block5: {
            try {
                if (JNAUtils.isOperatingSystem("windows")) {
                    return;
                }
                JNAUtils.mlockall(1);
                logger.info((Object)"mlockall() on JVM Heap successful");
            }
            catch (Exception e) {
                LastErrorException le;
                if (!(e instanceof LastErrorException)) {
                    logger.error((Object)"Unexpected error during mlock of server heap", (Throwable)e);
                }
                if ((le = (LastErrorException)e).getErrorCode() == 12 && JNAUtils.isOperatingSystem("linux")) {
                    logger.warn((Object)"Unable to lock JVM memory (ENOMEM). This can result in part of the JVM being swapped out with higher Young gen stalls Increase RLIMIT_MEMLOCK or run Voldemort as root.");
                }
                if (JNAUtils.isOperatingSystem("mac")) break block5;
                logger.warn((Object)("Unknown mlockall error " + le.getErrorCode()));
            }
        }
    }

    public static void tryMunlockall() {
        try {
            if (JNAUtils.isOperatingSystem("windows")) {
                return;
            }
            JNAUtils.munlockall();
            logger.info((Object)"munlockall() on JVM Heap successful");
        }
        catch (Exception e) {
            if (!(e instanceof LastErrorException)) {
                logger.error((Object)"Unexpected error during mlock of server heap", (Throwable)e);
            }
            LastErrorException le = (LastErrorException)e;
            logger.warn((Object)("Error unlocking JVM heap  " + le.getErrorCode()));
        }
    }

    static {
        try {
            Native.register((String)"c");
        }
        catch (NoClassDefFoundError e) {
            logger.info((Object)"Could not locate JNA classes");
        }
        catch (UnsatisfiedLinkError e) {
            logger.info((Object)"Failed to link to native library");
        }
        catch (NoSuchMethodError e) {
            logger.warn((Object)"Older version of JNA. Please upgrade to 3.2.7+");
        }
    }
}

