/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.cache;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CacheLIRS<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private long maxMemory;
    private int averageMemory;
    private final Segment<K, V>[] segments;
    private final int segmentCount;
    private final int segmentShift;
    private final int segmentMask;
    private final int stackMoveDistance;

    private CacheLIRS(long l, int n, int n2, int n3) {
        this.setMaxMemory(l);
        this.setAverageMemory(n);
        if (Integer.bitCount(n2) != 1) {
            throw new IllegalArgumentException("The segment count must be a power of 2, is " + n2);
        }
        this.segmentCount = n2;
        this.segmentMask = n2 - 1;
        this.stackMoveDistance = n3;
        this.segments = new Segment[n2];
        this.clear();
        this.segmentShift = Integer.numberOfTrailingZeros(this.segments[0].entries.length);
    }

    @Override
    public void clear() {
        long l = Math.max(1L, this.maxMemory / (long)this.segmentCount);
        for (int i = 0; i < this.segmentCount; ++i) {
            this.segments[i] = new Segment(l, this.averageMemory, this.stackMoveDistance);
        }
    }

    private Entry<K, V> find(Object object) {
        int n = CacheLIRS.getHash(object);
        return this.getSegment(n).find(object, n);
    }

    @Override
    public boolean containsKey(Object object) {
        int n = CacheLIRS.getHash(object);
        return this.getSegment(n).containsKey(object, n);
    }

    public V peek(K k) {
        Entry<K, V> entry = this.find(k);
        return entry == null ? null : (V)entry.value;
    }

    public V put(K k, V v, int n) {
        int n2 = CacheLIRS.getHash(k);
        return this.getSegment(n2).put(k, n2, v, n);
    }

    @Override
    public V put(K k, V v) {
        return this.put(k, v, this.averageMemory);
    }

    @Override
    public synchronized V remove(Object object) {
        int n = CacheLIRS.getHash(object);
        return this.getSegment(n).remove(object, n);
    }

    public int getMemory(K k) {
        int n = CacheLIRS.getHash(k);
        return this.getSegment(n).getMemory(k, n);
    }

    @Override
    public V get(Object object) {
        int n = CacheLIRS.getHash(object);
        return this.getSegment(n).get(object, n);
    }

    private Segment<K, V> getSegment(int n) {
        int n2 = n >>> this.segmentShift & this.segmentMask;
        return this.segments[n2];
    }

    static int getHash(Object object) {
        int n = object.hashCode();
        n = (n >>> 16 ^ n) * 73244475;
        n = (n >>> 16 ^ n) * 73244475;
        n = n >>> 16 ^ n;
        return n;
    }

    public long getUsedMemory() {
        long l = 0L;
        for (Segment<K, V> segment : this.segments) {
            l += segment.usedMemory;
        }
        return l;
    }

    public void setMaxMemory(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Max memory must be larger than 0");
        }
        this.maxMemory = l;
        if (this.segments != null) {
            long l2 = 1L + l / (long)this.segments.length;
            for (Segment<K, V> segment : this.segments) {
                segment.setMaxMemory(l2);
            }
        }
    }

    public void setAverageMemory(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Average memory must be larger than 0");
        }
        this.averageMemory = n;
        if (this.segments != null) {
            for (Segment<K, V> segment : this.segments) {
                segment.setAverageMemory(n);
            }
        }
    }

    public int getAverageMemory() {
        return this.averageMemory;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public static <K, V> CacheLIRS<K, V> newInstance(int n) {
        return new CacheLIRS<K, V>(n, 1, 16, n / 100);
    }

    public static <K, V> CacheLIRS<K, V> newInstance(int n, int n2, int n3, int n4) {
        return new CacheLIRS<K, V>(n, n2, n3, n4);
    }

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        HashMap hashMap = new HashMap();
        for (K k : this.keySet()) {
            hashMap.put(k, this.find(k).value);
        }
        return hashMap.entrySet();
    }

    @Override
    public synchronized Set<K> keySet() {
        HashSet<K> hashSet = new HashSet<K>();
        for (Segment<K, V> segment : this.segments) {
            hashSet.addAll(segment.keySet());
        }
        return hashSet;
    }

    public int sizeNonResident() {
        int n = 0;
        for (Segment<K, V> segment : this.segments) {
            n += segment.queue2Size;
        }
        return n;
    }

    public int sizeMapArray() {
        int n = 0;
        for (Segment<K, V> segment : this.segments) {
            n += segment.entries.length;
        }
        return n;
    }

    public int sizeHot() {
        int n = 0;
        for (Segment<K, V> segment : this.segments) {
            n += segment.mapSize - segment.queueSize - segment.queue2Size;
        }
        return n;
    }

    @Override
    public int size() {
        int n = 0;
        for (Segment<K, V> segment : this.segments) {
            n += segment.mapSize - segment.queue2Size;
        }
        return n;
    }

    public synchronized List<K> keys(boolean bl, boolean bl2) {
        ArrayList<K> arrayList = new ArrayList<K>();
        for (Segment<K, V> segment : this.segments) {
            arrayList.addAll(segment.keys(bl, bl2));
        }
        return arrayList;
    }

    static class Entry<K, V> {
        K key;
        V value;
        int memory;
        int topMove;
        Entry<K, V> stackNext;
        Entry<K, V> stackPrev;
        Entry<K, V> queueNext;
        Entry<K, V> queuePrev;
        Entry<K, V> mapNext;

        Entry() {
        }

        boolean isHot() {
            return this.queueNext == null;
        }
    }

    static class Segment<K, V> {
        int mapSize;
        int queueSize;
        int queue2Size;
        Entry<K, V>[] entries;
        long usedMemory;
        private final int stackMoveDistance;
        private long maxMemory;
        private int averageMemory;
        private int mask;
        private int stackSize;
        private Entry<K, V> stack;
        private Entry<K, V> queue;
        private Entry<K, V> queue2;
        private int stackMoveCounter;

        Segment(long l, int n, int n2) {
            this.setMaxMemory(l);
            this.setAverageMemory(n);
            this.stackMoveDistance = n2;
            this.clear();
        }

        private void clear() {
            long l;
            long l2 = (long)((double)(this.maxMemory / (long)this.averageMemory) / 0.75);
            for (l = 8L; l < l2; l += l) {
            }
            int n = (int)Math.min(0x80000000L, l);
            this.mask = n - 1;
            this.stack = new Entry();
            this.stack.stackNext = this.stack;
            this.stack.stackPrev = this.stack.stackNext;
            this.queue = new Entry();
            this.queue.queueNext = this.queue;
            this.queue.queuePrev = this.queue.queueNext;
            this.queue2 = new Entry();
            this.queue2.queueNext = this.queue2;
            this.queue2.queuePrev = this.queue2.queueNext;
            this.entries = null;
            Entry[] entryArray = new Entry[n];
            this.entries = entryArray;
            this.mapSize = 0;
            this.usedMemory = 0L;
            this.queue2Size = 0;
            this.queueSize = 0;
            this.stackSize = 0;
        }

        int getMemory(K k, int n) {
            Entry<K, V> entry = this.find(k, n);
            return entry == null ? 0 : entry.memory;
        }

        V get(Object object, int n) {
            Entry<K, V> entry = this.find(object, n);
            if (entry == null) {
                return null;
            }
            Object v = entry.value;
            if (v == null) {
                return null;
            }
            if (entry.isHot()) {
                if (entry != this.stack.stackNext && (this.stackMoveDistance == 0 || this.stackMoveCounter - entry.topMove > this.stackMoveDistance)) {
                    this.access(object, n);
                }
            } else {
                this.access(object, n);
            }
            return v;
        }

        private synchronized void access(Object object, int n) {
            Entry<K, V> entry = this.find(object, n);
            if (entry == null || entry.value == null) {
                return;
            }
            if (entry.isHot()) {
                if (entry != this.stack.stackNext && (this.stackMoveDistance == 0 || this.stackMoveCounter - entry.topMove > this.stackMoveDistance)) {
                    boolean bl = entry == this.stack.stackPrev;
                    this.removeFromStack(entry);
                    if (bl) {
                        this.pruneStack();
                    }
                    this.addToStack(entry);
                }
            } else {
                this.removeFromQueue(entry);
                if (entry.stackNext != null) {
                    this.removeFromStack(entry);
                    this.convertOldestHotToCold();
                } else {
                    this.addToQueue(this.queue, entry);
                }
                this.addToStack(entry);
            }
        }

        synchronized V put(K k, int n, V v, int n2) {
            V v2;
            if (v == null) {
                throw new NullPointerException();
            }
            Entry<K, V> entry = this.find(k, n);
            if (entry == null) {
                v2 = null;
            } else {
                v2 = entry.value;
                this.remove(k, n);
            }
            entry = new Entry();
            entry.key = k;
            entry.value = v;
            entry.memory = n2;
            int n3 = n & this.mask;
            entry.mapNext = this.entries[n3];
            this.entries[n3] = entry;
            this.usedMemory += (long)n2;
            if (this.usedMemory > this.maxMemory && this.mapSize > 0) {
                this.evict(entry);
            }
            ++this.mapSize;
            this.addToStack(entry);
            return v2;
        }

        synchronized V remove(Object object, int n) {
            Object v;
            int n2 = n & this.mask;
            Entry<K, V> entry = this.entries[n2];
            if (entry == null) {
                return null;
            }
            if (entry.key.equals(object)) {
                v = entry.value;
                this.entries[n2] = entry.mapNext;
            } else {
                do {
                    Entry<K, V> entry2 = entry;
                    entry = entry.mapNext;
                    if (entry != null) continue;
                    return null;
                } while (!entry.key.equals(object));
                v = entry.value;
                entry2.mapNext = entry.mapNext;
            }
            --this.mapSize;
            this.usedMemory -= (long)entry.memory;
            if (entry.stackNext != null) {
                this.removeFromStack(entry);
            }
            if (entry.isHot()) {
                entry = this.queue.queueNext;
                if (entry != this.queue) {
                    this.removeFromQueue(entry);
                    if (entry.stackNext == null) {
                        this.addToStackBottom(entry);
                    }
                }
            } else {
                this.removeFromQueue(entry);
            }
            this.pruneStack();
            return v;
        }

        private void evict(Entry<K, V> entry) {
            while (this.queueSize << 5 < this.mapSize) {
                this.convertOldestHotToCold();
            }
            if (this.stackSize > 0) {
                this.addToQueue(this.queue, entry);
            }
            while (this.usedMemory > this.maxMemory && this.queueSize > 1) {
                Entry entry2 = this.queue.queuePrev;
                this.usedMemory -= (long)entry2.memory;
                this.removeFromQueue(entry2);
                entry2.value = null;
                entry2.memory = 0;
                this.addToQueue(this.queue2, entry2);
                while (this.queue2Size + this.queue2Size > this.stackSize) {
                    entry2 = this.queue2.queuePrev;
                    int n = CacheLIRS.getHash(entry2.key);
                    this.remove(entry2.key, n);
                }
            }
        }

        private void convertOldestHotToCold() {
            Entry entry = this.stack.stackPrev;
            this.removeFromStack(entry);
            this.addToQueue(this.queue, entry);
            this.pruneStack();
        }

        private void pruneStack() {
            Entry entry;
            while ((entry = this.stack.stackPrev) != this.stack && !entry.isHot()) {
                this.removeFromStack(entry);
            }
        }

        Entry<K, V> find(Object object, int n) {
            int n2 = n & this.mask;
            Entry<K, V> entry = this.entries[n2];
            while (entry != null && !entry.key.equals(object)) {
                entry = entry.mapNext;
            }
            return entry;
        }

        private void addToStack(Entry<K, V> entry) {
            entry.stackPrev = this.stack;
            entry.stackNext = this.stack.stackNext;
            entry.stackNext.stackPrev = entry;
            this.stack.stackNext = entry;
            ++this.stackSize;
            entry.topMove = this.stackMoveCounter++;
        }

        private void addToStackBottom(Entry<K, V> entry) {
            entry.stackNext = this.stack;
            entry.stackPrev = this.stack.stackPrev;
            entry.stackPrev.stackNext = entry;
            this.stack.stackPrev = entry;
            ++this.stackSize;
        }

        private void removeFromStack(Entry<K, V> entry) {
            entry.stackPrev.stackNext = entry.stackNext;
            entry.stackNext.stackPrev = entry.stackPrev;
            entry.stackNext = null;
            entry.stackPrev = null;
            --this.stackSize;
        }

        private void addToQueue(Entry<K, V> entry, Entry<K, V> entry2) {
            entry2.queuePrev = entry;
            entry2.queueNext = entry.queueNext;
            entry2.queueNext.queuePrev = entry2;
            entry.queueNext = entry2;
            if (entry2.value != null) {
                ++this.queueSize;
            } else {
                ++this.queue2Size;
            }
        }

        private void removeFromQueue(Entry<K, V> entry) {
            entry.queuePrev.queueNext = entry.queueNext;
            entry.queueNext.queuePrev = entry.queuePrev;
            entry.queueNext = null;
            entry.queuePrev = null;
            if (entry.value != null) {
                --this.queueSize;
            } else {
                --this.queue2Size;
            }
        }

        synchronized List<K> keys(boolean bl, boolean bl2) {
            ArrayList arrayList = new ArrayList();
            if (bl) {
                Entry<K, V> entry = bl2 ? this.queue2 : this.queue;
                Entry entry2 = entry.queueNext;
                while (entry2 != entry) {
                    arrayList.add(entry2.key);
                    entry2 = entry2.queueNext;
                }
            } else {
                Entry entry = this.stack.stackNext;
                while (entry != this.stack) {
                    arrayList.add(entry.key);
                    entry = entry.stackNext;
                }
            }
            return arrayList;
        }

        boolean containsKey(Object object, int n) {
            Entry<K, V> entry = this.find(object, n);
            return entry != null && entry.value != null;
        }

        synchronized Set<K> keySet() {
            HashSet hashSet = new HashSet();
            Entry entry = this.stack.stackNext;
            while (entry != this.stack) {
                hashSet.add(entry.key);
                entry = entry.stackNext;
            }
            entry = this.queue.queueNext;
            while (entry != this.queue) {
                hashSet.add(entry.key);
                entry = entry.queueNext;
            }
            return hashSet;
        }

        void setMaxMemory(long l) {
            if (l <= 0L) {
                throw new IllegalArgumentException("Max memory must be larger than 0");
            }
            this.maxMemory = l;
        }

        void setAverageMemory(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("Average memory must be larger than 0");
            }
            this.averageMemory = n;
        }
    }
}

