/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.executor;

import azkaban.utils.Props;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

/*
 * Exception performing whole class analysis ignored.
 */
public class JavaJobRunnerMain {
    public static final String JOB_CLASS = "job.class";
    public static final String DEFAULT_RUN_METHOD = "run";
    public static final String DEFAULT_CANCEL_METHOD = "cancel";
    public static final String GET_GENERATED_PROPERTIES_METHOD = "getJobGeneratedProperties";
    public static final String CANCEL_METHOD_PARAM = "method.cancel";
    public static final String RUN_METHOD_PARAM = "method.run";
    public static final String[] PROPS_CLASSES = new String[]{"azkaban.utils.Props", "azkaban.common.utils.Props"};
    private static final Layout DEFAULT_LAYOUT = new PatternLayout("%p %m\n");
    public final Logger _logger;
    public String _cancelMethod;
    public String _jobName;
    public Object _javaObject;
    private boolean _isFinished;

    public static void main(String[] args) throws Exception {
        JavaJobRunnerMain wrapper = new JavaJobRunnerMain();
    }

    public JavaJobRunnerMain() throws Exception {
        block7: {
            this._isFinished = false;
            Runtime.getRuntime().addShutdownHook((Thread)new /* Unavailable Anonymous Inner Class!! */);
            try {
                this._jobName = System.getenv("JOB_NAME");
                String propsFile = System.getenv("JOB_PROP_FILE");
                this._logger = Logger.getRootLogger();
                this._logger.removeAllAppenders();
                ConsoleAppender appender = new ConsoleAppender(DEFAULT_LAYOUT);
                appender.activateOptions();
                this._logger.addAppender((Appender)appender);
                Properties prop = new Properties();
                prop.load(new BufferedReader(new FileReader(propsFile)));
                this._logger.info((Object)("Running job " + this._jobName));
                String className = prop.getProperty("job.class");
                if (className == null) {
                    throw new Exception("Class name is not set.");
                }
                this._logger.info((Object)("Class name " + className));
                this._javaObject = JavaJobRunnerMain.getObject((String)this._jobName, (String)className, (Properties)prop, (Logger)this._logger);
                if (this._javaObject == null) {
                    this._logger.info((Object)("Could not create java object to run job: " + className));
                    throw new Exception("Could not create running object");
                }
                this._cancelMethod = prop.getProperty("method.cancel", "cancel");
                String runMethod = prop.getProperty("method.run", "run");
                this._logger.info((Object)("Invoking method " + runMethod));
                this._logger.info((Object)"Proxy check failed, not proxying run.");
                this.runMethod(this._javaObject, runMethod);
                this._isFinished = true;
                try {
                    Method generatedPropertiesMethod = this._javaObject.getClass().getMethod("getJobGeneratedProperties", new Class[0]);
                    Object outputGendProps = generatedPropertiesMethod.invoke(this._javaObject, new Object[0]);
                    if (outputGendProps != null) {
                        Method toPropertiesMethod = outputGendProps.getClass().getMethod("toProperties", new Class[0]);
                        Properties properties = (Properties)toPropertiesMethod.invoke(outputGendProps, new Object[0]);
                        Props outputProps = new Props(null, new Properties[]{properties});
                        this.outputGeneratedProperties(outputProps);
                        break block7;
                    }
                    this.outputGeneratedProperties(new Props());
                }
                catch (NoSuchMethodException e) {
                    this._logger.info((Object)String.format("Apparently there isn't a method[%s] on object[%s], using empty Props object instead.", "getJobGeneratedProperties", this._javaObject));
                    this.outputGeneratedProperties(new Props());
                }
            }
            catch (Exception e) {
                this._isFinished = true;
                throw e;
            }
        }
    }

    private void runMethod(Object obj, String runMethod) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        obj.getClass().getMethod(runMethod, new Class[0]).invoke(obj, new Object[0]);
    }

    private void outputGeneratedProperties(Props outputProperties) {
        if (outputProperties == null) {
            this._logger.info((Object)"  no gend props");
            return;
        }
        for (String key : outputProperties.getKeySet()) {
            this._logger.info((Object)("  gend prop " + key + " value:" + outputProperties.get((Object)key)));
        }
        String outputFileStr = System.getenv("JOB_OUTPUT_PROP_FILE");
        if (outputFileStr == null) {
            return;
        }
        this._logger.info((Object)("Outputting generated properties to " + outputFileStr));
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        for (String key : outputProperties.getKeySet()) {
            properties.put(key, outputProperties.get((Object)key));
        }
        OutputStream writer = null;
        try {
            try {
                writer = new BufferedOutputStream(new FileOutputStream(outputFileStr));
                writer.write("{\n".getBytes());
                for (Map.Entry entry : properties.entrySet()) {
                    writer.write(String.format("  \"%s\":\"%s\",\n", ((String)entry.getKey()).replace("\"", "\\\\\""), ((String)entry.getValue()).replace("\"", "\\\\\"")).getBytes());
                }
                writer.write("}".getBytes());
            }
            catch (Exception e) {
                new RuntimeException("Unable to store output properties to: " + outputFileStr);
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void cancelJob() {
        if (this._isFinished) {
            return;
        }
        this._logger.info((Object)"Attempting to call cancel on this job");
        if (this._javaObject != null) {
            Method method = null;
            try {
                method = this._javaObject.getClass().getMethod(this._cancelMethod, new Class[0]);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (method != null) {
                try {
                    method.invoke(this._javaObject, new Object[0]);
                }
                catch (Exception e) {
                    if (this._logger != null) {
                        this._logger.error((Object)"Cancel method failed! ", (Throwable)e);
                    }
                }
            } else {
                throw new RuntimeException("Job " + this._jobName + " does not have cancel method " + this._cancelMethod);
            }
        }
    }

    private static Object getObject(String jobName, String className, Properties properties, Logger logger) throws Exception {
        Class<?> runningClass = JavaJobRunnerMain.class.getClassLoader().loadClass(className);
        if (runningClass == null) {
            throw new Exception("Class " + className + " was not found. Cannot run job.");
        }
        Class<?> propsClass = null;
        String[] stringArray = PROPS_CLASSES;
        int n = PROPS_CLASSES.length;
        int n2 = 0;
        while (n2 < n) {
            String propClassName = stringArray[n2];
            try {
                propsClass = JavaJobRunnerMain.class.getClassLoader().loadClass(propClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (propsClass != null && JavaJobRunnerMain.getConstructor(runningClass, (Class[])new Class[]{String.class, propsClass}) != null) break;
            propsClass = null;
            ++n2;
        }
        Object obj = null;
        if (propsClass != null && JavaJobRunnerMain.getConstructor(runningClass, (Class[])new Class[]{String.class, propsClass}) != null) {
            Constructor propsCon = JavaJobRunnerMain.getConstructor(propsClass, (Class[])new Class[]{propsClass, Properties[].class});
            Object props = propsCon.newInstance(null, new Properties[]{properties});
            Constructor con = JavaJobRunnerMain.getConstructor(runningClass, (Class[])new Class[]{String.class, propsClass});
            logger.info((Object)("Constructor found " + con.toGenericString()));
            obj = con.newInstance(jobName, props);
        } else if (JavaJobRunnerMain.getConstructor(runningClass, (Class[])new Class[]{String.class, Properties.class}) != null) {
            Constructor con = JavaJobRunnerMain.getConstructor(runningClass, (Class[])new Class[]{String.class, Properties.class});
            logger.info((Object)("Constructor found " + con.toGenericString()));
            obj = con.newInstance(jobName, properties);
        } else if (JavaJobRunnerMain.getConstructor(runningClass, (Class[])new Class[]{String.class, Map.class}) != null) {
            Constructor con = JavaJobRunnerMain.getConstructor(runningClass, (Class[])new Class[]{String.class, Map.class});
            logger.info((Object)("Constructor found " + con.toGenericString()));
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
            obj = con.newInstance(jobName, map);
        } else if (JavaJobRunnerMain.getConstructor(runningClass, (Class[])new Class[]{String.class}) != null) {
            Constructor con = JavaJobRunnerMain.getConstructor(runningClass, (Class[])new Class[]{String.class});
            logger.info((Object)("Constructor found " + con.toGenericString()));
            obj = con.newInstance(jobName);
        } else if (JavaJobRunnerMain.getConstructor(runningClass, (Class[])new Class[0]) != null) {
            Constructor con = JavaJobRunnerMain.getConstructor(runningClass, (Class[])new Class[0]);
            logger.info((Object)("Constructor found " + con.toGenericString()));
            obj = con.newInstance(new Object[0]);
        } else {
            logger.error((Object)"Constructor not found. Listing available Constructors.");
            Constructor<?>[] constructorArray = runningClass.getConstructors();
            int n3 = constructorArray.length;
            n = 0;
            while (n < n3) {
                Constructor<?> c = constructorArray[n];
                logger.info((Object)c.toGenericString());
                ++n;
            }
        }
        return obj;
    }

    private static Constructor<?> getConstructor(Class<?> c, Class<?> ... args) {
        try {
            Constructor<?> cons = c.getConstructor(args);
            return cons;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

