/*
 * Copyright 2012 LinkedIn Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package azkaban.metric.inmemoryemitter;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class InMemoryHistoryNode {
  private Object value;
  private Date date;

  public InMemoryHistoryNode(Object val) {
    value = val;
    date = new Date();
  }

  public Object getValue() {
    return value;
  }

  public Date getTimestamp() {
    return date;
  }

  public String formattedTimestamp() {
    DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    return dateFormat.format(date);
  }
}
