/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.util.Iterator;
import org.h2.mvstore.CursorPos;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.Page;

public class ChangeCursor<K, V>
implements Iterator<K> {
    private final MVMap<K, V> map;
    private final Page root1;
    private final Page root2;
    private int state;
    private CursorPos pos1;
    private CursorPos pos2;
    private K current;

    ChangeCursor(MVMap<K, V> mVMap, Page page, Page page2) {
        this.map = mVMap;
        this.root1 = page;
        this.root2 = page2;
    }

    @Override
    public K next() {
        K k = this.current;
        this.fetchNext();
        return k;
    }

    @Override
    public boolean hasNext() {
        if (this.state == 0) {
            this.pos1 = new CursorPos(this.root1, 0, null);
            this.pos1 = ChangeCursor.min(this.pos1);
            this.state = 1;
            this.fetchNext();
        }
        return this.current != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void fetchNext() {
        Object object;
        Object object2;
        while (this.fetchNextKey() && this.pos1 != null && this.pos2 != null && (object2 = this.map.binarySearch(this.root1, this.current)).equals(object = this.map.binarySearch(this.root2, this.current))) {
        }
    }

    private boolean fetchNextKey() {
        while (true) {
            block14: {
                block13: {
                    if (this.state == 3) {
                        return false;
                    }
                    if (this.state == 1) {
                        this.pos1 = this.fetchNext(this.pos1);
                        if (this.pos1 == null) {
                            this.state = 2;
                            this.pos2 = null;
                            continue;
                        }
                        this.pos2 = this.find(this.root2, this.current);
                        if (this.pos2 == null) {
                            return true;
                        }
                        if (!this.pos1.page.equals(this.pos2.page)) {
                            return true;
                        }
                        do {
                            this.pos1 = this.pos1.parent;
                            if (this.pos1 == null) {
                                this.state = 2;
                                this.pos2 = null;
                                break block13;
                            }
                            this.pos2 = this.pos2.parent;
                        } while (this.pos2 != null && this.pos1.page.equals(this.pos2.page) || this.pos1.index + 1 >= this.map.getChildPageCount(this.pos1.page));
                        this.pos1 = new CursorPos(this.pos1.page.getChildPage(++this.pos1.index), 0, this.pos1);
                        this.pos1 = ChangeCursor.min(this.pos1);
                    }
                }
                if (this.state != 2) continue;
                if (this.pos2 == null) {
                    this.pos2 = new CursorPos(this.root2, 0, null);
                    this.pos2 = ChangeCursor.min(this.pos2);
                }
                this.pos2 = this.fetchNext(this.pos2);
                if (this.pos2 == null) {
                    this.state = 3;
                    this.current = null;
                    continue;
                }
                this.pos1 = this.find(this.root1, this.current);
                if (this.pos1 == null) break;
                if (!this.pos1.page.equals(this.pos2.page)) {
                    this.pos1 = null;
                    continue;
                }
                do {
                    this.pos2 = this.pos2.parent;
                    if (this.pos2 == null) {
                        this.state = 3;
                        this.current = null;
                        this.pos1 = null;
                        break block14;
                    }
                    this.pos1 = this.pos1.parent;
                } while (this.pos1 != null && this.pos2.page.equals(this.pos1.page) || this.pos2.index + 1 >= this.map.getChildPageCount(this.pos2.page));
                this.pos2 = new CursorPos(this.pos2.page.getChildPage(++this.pos2.index), 0, this.pos2);
                this.pos2 = ChangeCursor.min(this.pos2);
            }
            this.pos1 = null;
        }
        return true;
    }

    private CursorPos find(Page page, K k) {
        CursorPos cursorPos = null;
        while (true) {
            int n;
            if (page.isLeaf()) {
                int n2 = n = k == null ? 0 : page.binarySearch(k);
                if (n < 0) {
                    return null;
                }
                return new CursorPos(page, n, cursorPos);
            }
            int n3 = n = k == null ? -1 : page.binarySearch(k);
            n = n < 0 ? -n - 1 : ++n;
            cursorPos = new CursorPos(page, n, cursorPos);
            page = page.getChildPage(n);
        }
    }

    private CursorPos fetchNext(CursorPos cursorPos) {
        while (cursorPos != null) {
            if (cursorPos.index < cursorPos.page.getKeyCount()) {
                this.current = cursorPos.page.getKey(cursorPos.index++);
                return cursorPos;
            }
            cursorPos = cursorPos.parent;
            if (cursorPos == null) break;
            if (cursorPos.index + 1 >= this.map.getChildPageCount(cursorPos.page)) continue;
            ++cursorPos.index;
            cursorPos = new CursorPos(cursorPos.page.getChildPage(cursorPos.index), 0, cursorPos);
            cursorPos = ChangeCursor.min(cursorPos);
        }
        this.current = null;
        return cursorPos;
    }

    private static CursorPos min(CursorPos cursorPos) {
        while (!cursorPos.page.isLeaf()) {
            Page page = cursorPos.page.getChildPage(0);
            cursorPos = new CursorPos(page, 0, cursorPos);
        }
        return cursorPos;
    }
}

