/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client;

import java.io.StringReader;
import java.util.List;
import voldemort.client.BootstrapFailureException;
import voldemort.client.DefaultStoreClient;
import voldemort.client.StoreClient;
import voldemort.client.StoreClientFactory;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.cluster.failuredetector.NoopFailureDetector;
import voldemort.serialization.DefaultSerializerFactory;
import voldemort.serialization.Serializer;
import voldemort.store.StorageEngine;
import voldemort.store.Store;
import voldemort.store.StoreDefinition;
import voldemort.store.StoreUtils;
import voldemort.store.memory.InMemoryStorageEngine;
import voldemort.store.serialized.SerializingStore;
import voldemort.store.versioned.InconsistencyResolvingStore;
import voldemort.store.versioned.VersionIncrementingStore;
import voldemort.store.views.ViewStorageConfiguration;
import voldemort.store.views.ViewStorageEngine;
import voldemort.utils.ByteArray;
import voldemort.utils.SystemTime;
import voldemort.utils.Time;
import voldemort.versioning.ChainedResolver;
import voldemort.versioning.InconsistencyResolver;
import voldemort.versioning.TimeBasedInconsistencyResolver;
import voldemort.versioning.VectorClockInconsistencyResolver;
import voldemort.versioning.Versioned;
import voldemort.xml.StoreDefinitionsMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockStoreClientFactory
implements StoreClientFactory {
    private final int nodeId;
    private final Serializer<?> keySerializer;
    private final Serializer<?> valueSerializer;
    private final Serializer<?> viewValueSerializer;
    private final Serializer<?> transformsSerializer;
    private final Time time;
    private final FailureDetector failureDetector;
    private static final StoreDefinitionsMapper storeMapper = new StoreDefinitionsMapper();
    private String storesXml;

    public MockStoreClientFactory(Serializer<?> keySerializer, Serializer<?> valueSerializer, Serializer<?> transformsSerializer) {
        this(keySerializer, valueSerializer, null, transformsSerializer, 0, SystemTime.INSTANCE);
    }

    public MockStoreClientFactory(Serializer<?> keySerializer, Serializer<?> valueSerializer, Serializer<?> viewValueSerializer, Serializer<?> transformsSerializer, String storesXml) {
        this(keySerializer, valueSerializer, viewValueSerializer, transformsSerializer, 0, SystemTime.INSTANCE);
        this.storesXml = storesXml;
    }

    public MockStoreClientFactory(Serializer<?> keySerializer, Serializer<?> valueSerializer, Serializer<?> viewValueSerializer, Serializer<?> transformsSerializer, int nodeId, Time time) {
        this.nodeId = nodeId;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.viewValueSerializer = viewValueSerializer;
        this.transformsSerializer = transformsSerializer;
        this.time = time;
        this.failureDetector = new NoopFailureDetector();
    }

    @Override
    public <K, V> StoreClient<K, V> getStoreClient(String storeName) {
        return this.getStoreClient(storeName, new TimeBasedInconsistencyResolver());
    }

    @Override
    public <K, V> StoreClient<K, V> getStoreClient(String storeName, InconsistencyResolver<Versioned<V>> resolver) {
        return new DefaultStoreClient(storeName, resolver, this, 3);
    }

    public <K1, V1, T1> Store<K1, V1, T1> getRawStore(String storeName, InconsistencyResolver<Versioned<V1>> resolver) {
        if (this.storesXml != null) {
            return this.getRawStore(storeName);
        }
        InconsistencyResolver<Versioned<Object>> secondaryResolver = new TimeBasedInconsistencyResolver();
        if (resolver != null) {
            secondaryResolver = resolver;
        }
        Store<ByteArray, Object, Object> store = new VersionIncrementingStore<ByteArray, byte[], byte[]>(new InMemoryStorageEngine(storeName), this.nodeId, this.time);
        if (this.isSerialized()) {
            store = new SerializingStore(store, this.keySerializer, this.valueSerializer, this.transformsSerializer);
        }
        InconsistencyResolvingStore<ByteArray, byte[], byte[]> consistentStore = new InconsistencyResolvingStore<ByteArray, byte[], byte[]>(store, new ChainedResolver(new VectorClockInconsistencyResolver(), secondaryResolver));
        return consistentStore;
    }

    private <K1, V1, T1> Store<K1, V1, T1> getRawStore(String storeName) {
        List<StoreDefinition> storeDefs = storeMapper.readStoreList(new StringReader(this.storesXml));
        StoreDefinition storeDef = null;
        for (StoreDefinition d : storeDefs) {
            if (!d.getName().equals(storeName)) continue;
            storeDef = d;
        }
        if (storeDef == null) {
            throw new BootstrapFailureException("Unknown store '" + storeName + "'.");
        }
        DefaultSerializerFactory serializerFactory = new DefaultSerializerFactory();
        Serializer<?> keySerializer = serializerFactory.getSerializer(storeDef.getKeySerializer());
        Serializer<?> valueSerializer = serializerFactory.getSerializer(storeDef.getValueSerializer());
        Serializer<?> transformsSerializer = null;
        if (storeDef.isView()) {
            transformsSerializer = serializerFactory.getSerializer(storeDef.getTransformsSerializer());
        }
        TimeBasedInconsistencyResolver secondaryResolver = new TimeBasedInconsistencyResolver();
        StorageEngine<ByteArray, Object, Object> engine = storeDef.isView() ? new InMemoryStorageEngine<ByteArray, byte[], byte[]>(storeDef.getViewTargetStoreName()) : new InMemoryStorageEngine(storeDef.getName());
        if (storeDef.isView()) {
            String targetName = storeDef.getViewTargetStoreName();
            StoreDefinition targetDef = StoreUtils.getStoreDef(storeDefs, targetName);
            engine = new ViewStorageEngine(storeName, engine, this.viewValueSerializer != null ? this.viewValueSerializer : serializerFactory.getSerializer(storeDef.getValueSerializer()), this.transformsSerializer != null ? this.transformsSerializer : serializerFactory.getSerializer(storeDef.getTransformsSerializer()), this.keySerializer != null ? this.keySerializer : serializerFactory.getSerializer(targetDef.getKeySerializer()), this.valueSerializer != null ? this.valueSerializer : serializerFactory.getSerializer(targetDef.getValueSerializer()), null, ViewStorageConfiguration.loadTransformation(storeDef.getValueTransformation()));
        }
        Store<ByteArray, Object, Object> store = new VersionIncrementingStore<ByteArray, byte[], byte[]>(engine, this.nodeId, this.time);
        store = new SerializingStore(store, this.keySerializer != null ? this.keySerializer : keySerializer, this.valueSerializer != null ? this.valueSerializer : valueSerializer, this.transformsSerializer != null ? this.transformsSerializer : transformsSerializer);
        InconsistencyResolvingStore<ByteArray, byte[], byte[]> consistentStore = new InconsistencyResolvingStore<ByteArray, byte[], byte[]>(store, new ChainedResolver(new VectorClockInconsistencyResolver(), secondaryResolver));
        return consistentStore;
    }

    private boolean isSerialized() {
        return this.keySerializer != null && this.valueSerializer != null;
    }

    @Override
    public void close() {
    }

    @Override
    public FailureDetector getFailureDetector() {
        return this.failureDetector;
    }
}

