/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.rebalancing;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.annotations.jmx.JmxGetter;
import voldemort.annotations.jmx.JmxSetter;
import voldemort.client.protocol.RequestFormatType;
import voldemort.client.rebalance.RebalancePartitionsInfo;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.server.RequestRoutingType;
import voldemort.server.StoreRepository;
import voldemort.store.DelegatingStore;
import voldemort.store.Store;
import voldemort.store.StoreUtils;
import voldemort.store.UnreachableStoreException;
import voldemort.store.metadata.MetadataStore;
import voldemort.store.rebalancing.ProxyUnreachableException;
import voldemort.store.socket.SocketStoreFactory;
import voldemort.utils.ByteArray;
import voldemort.versioning.ObsoleteVersionException;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedirectingStore
extends DelegatingStore<ByteArray, byte[], byte[]> {
    private static final Logger logger = Logger.getLogger(RedirectingStore.class);
    private final MetadataStore metadata;
    private final StoreRepository storeRepository;
    private final SocketStoreFactory storeFactory;
    private FailureDetector failureDetector;
    private AtomicBoolean isRedirectingStoreEnabled;

    public RedirectingStore(Store<ByteArray, byte[], byte[]> innerStore, MetadataStore metadata, StoreRepository storeRepository, FailureDetector detector, SocketStoreFactory storeFactory) {
        super(innerStore);
        this.metadata = metadata;
        this.storeRepository = storeRepository;
        this.storeFactory = storeFactory;
        this.failureDetector = detector;
        this.isRedirectingStoreEnabled = new AtomicBoolean(true);
    }

    @JmxSetter(name="setRedirectingStoreEnabled", description="Enable the redirecting store for this store")
    public void setIsRedirectingStoreEnabled(boolean isRedirectingStoreEnabled) {
        logger.info((Object)("Setting redirecting store flag for " + this.getName() + " to " + isRedirectingStoreEnabled));
        this.isRedirectingStoreEnabled.set(isRedirectingStoreEnabled);
    }

    @JmxGetter(name="isRedirectingStoreEnabled", description="Get the redirecting store state for this store")
    public boolean getIsRedirectingStoreEnabled() {
        return this.isRedirectingStoreEnabled.get();
    }

    @Override
    public void put(ByteArray key, Versioned<byte[]> value, byte[] transforms) throws VoldemortException {
        RebalancePartitionsInfo stealInfo = this.redirectingKey(key);
        if (stealInfo != null) {
            this.proxyGetAndLocalPut(key, stealInfo.getDonorId(), transforms);
        }
        this.getInnerStore().put(key, value, transforms);
    }

    private RebalancePartitionsInfo redirectingKey(ByteArray key) {
        if (MetadataStore.VoldemortState.REBALANCING_MASTER_SERVER.equals((Object)this.metadata.getServerState()) && this.isRedirectingStoreEnabled.get()) {
            return this.metadata.getRebalancerState().find(this.getName(), this.metadata.getRoutingStrategy(this.getName()).getPartitionList(key.get()), this.metadata.getCluster().getNodeById(this.metadata.getNodeId()).getPartitionIds());
        }
        return null;
    }

    @Override
    public List<Versioned<byte[]>> get(ByteArray key, byte[] transforms) throws VoldemortException {
        RebalancePartitionsInfo stealInfo = this.redirectingKey(key);
        if (stealInfo != null) {
            this.proxyGetAndLocalPut(key, stealInfo.getDonorId(), transforms);
        }
        return this.getInnerStore().get(key, transforms);
    }

    @Override
    public List<Version> getVersions(ByteArray key) {
        RebalancePartitionsInfo stealInfo = this.redirectingKey(key);
        if (stealInfo != null) {
            this.proxyGetAndLocalPut(key, stealInfo.getDonorId(), null);
        }
        return this.getInnerStore().getVersions(key);
    }

    @Override
    public Map<ByteArray, List<Versioned<byte[]>>> getAll(Iterable<ByteArray> keys, Map<ByteArray, byte[]> transforms) throws VoldemortException {
        HashMap rebalancePartitionsInfoPerKey = Maps.newHashMapWithExpectedSize((int)Iterables.size(keys));
        for (ByteArray key : keys) {
            RebalancePartitionsInfo info = this.redirectingKey(key);
            if (info == null) continue;
            rebalancePartitionsInfoPerKey.put(key, info);
        }
        if (!rebalancePartitionsInfoPerKey.isEmpty()) {
            this.proxyGetAllAndLocalPut(rebalancePartitionsInfoPerKey, transforms);
        }
        return this.getInnerStore().getAll(keys, transforms);
    }

    @Override
    public boolean delete(ByteArray key, Version version) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        return this.getInnerStore().delete(key, version);
    }

    private List<Versioned<byte[]>> proxyGet(ByteArray key, int donorNodeId, byte[] transform) {
        Node donorNode = this.metadata.getCluster().getNodeById(donorNodeId);
        this.checkNodeAvailable(donorNode);
        long startNs = System.nanoTime();
        try {
            Store<ByteArray, byte[], byte[]> redirectingStore = this.getRedirectingSocketStore(this.getName(), donorNodeId);
            List<Versioned<byte[]>> values = redirectingStore.get(key, transform);
            this.recordSuccess(donorNode, startNs);
            return values;
        }
        catch (UnreachableStoreException e) {
            this.recordException(donorNode, startNs, e);
            throw new ProxyUnreachableException("Failed to reach proxy node " + donorNode, e);
        }
    }

    private void checkNodeAvailable(Node donorNode) {
        if (!this.failureDetector.isAvailable(donorNode)) {
            throw new ProxyUnreachableException("Failed to reach proxy node " + donorNode + " is marked down by failure detector.");
        }
    }

    private Map<ByteArray, List<Versioned<byte[]>>> proxyGetAll(Map<ByteArray, RebalancePartitionsInfo> rebalancePartitionsInfoPerKey, Map<ByteArray, byte[]> transforms) throws VoldemortException {
        HashMultimap donorNodeToKeys = HashMultimap.create();
        int numKeys = 0;
        for (Map.Entry<ByteArray, RebalancePartitionsInfo> entry : rebalancePartitionsInfoPerKey.entrySet()) {
            ++numKeys;
            donorNodeToKeys.put((Object)entry.getValue().getDonorId(), (Object)entry.getKey());
        }
        HashMap gatherMap = Maps.newHashMapWithExpectedSize((int)numKeys);
        Iterator i$ = donorNodeToKeys.keySet().iterator();
        while (i$.hasNext()) {
            int donorNodeId = (Integer)i$.next();
            Node donorNode = this.metadata.getCluster().getNodeById(donorNodeId);
            this.checkNodeAvailable(donorNode);
            long startNs = System.nanoTime();
            try {
                Map<ByteArray, List<Versioned<byte[]>>> resultsForNode = this.getRedirectingSocketStore(this.getName(), donorNodeId).getAll(donorNodeToKeys.get((Object)donorNodeId), transforms);
                this.recordSuccess(donorNode, startNs);
                for (Map.Entry<ByteArray, List<Versioned<byte[]>>> entry : resultsForNode.entrySet()) {
                    gatherMap.put(entry.getKey(), entry.getValue());
                }
            }
            catch (UnreachableStoreException e) {
                this.recordException(donorNode, startNs, e);
                throw new ProxyUnreachableException("Failed to reach proxy node " + donorNode, e);
            }
        }
        return gatherMap;
    }

    private List<Versioned<byte[]>> proxyGetAndLocalPut(ByteArray key, int donorId, byte[] transforms) throws VoldemortException {
        List<Versioned<byte[]>> proxyValues = this.proxyGet(key, donorId, transforms);
        for (Versioned<byte[]> proxyValue : proxyValues) {
            try {
                this.getInnerStore().put(key, proxyValue, null);
            }
            catch (ObsoleteVersionException e) {}
        }
        return proxyValues;
    }

    private Map<ByteArray, List<Versioned<byte[]>>> proxyGetAllAndLocalPut(Map<ByteArray, RebalancePartitionsInfo> rebalancePartitionsInfoPerKey, Map<ByteArray, byte[]> transforms) throws VoldemortException {
        Map<ByteArray, List<Versioned<byte[]>>> proxyKeyValues = this.proxyGetAll(rebalancePartitionsInfoPerKey, transforms);
        for (Map.Entry<ByteArray, List<Versioned<byte[]>>> keyValuePair : proxyKeyValues.entrySet()) {
            for (Versioned<byte[]> proxyValue : keyValuePair.getValue()) {
                try {
                    this.getInnerStore().put(keyValuePair.getKey(), proxyValue, null);
                }
                catch (ObsoleteVersionException e) {}
            }
        }
        return proxyKeyValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Store<ByteArray, byte[], byte[]> getRedirectingSocketStore(String storeName, int donorNodeId) {
        if (!this.storeRepository.hasRedirectingSocketStore(storeName, donorNodeId)) {
            StoreRepository storeRepository = this.storeRepository;
            synchronized (storeRepository) {
                if (!this.storeRepository.hasRedirectingSocketStore(storeName, donorNodeId)) {
                    Node donorNode = this.getNodeIfPresent(donorNodeId);
                    logger.info((Object)("Creating new redirecting store for donor node " + donorNode.getId() + " and store " + storeName));
                    this.storeRepository.addRedirectingSocketStore(donorNode.getId(), this.storeFactory.create(storeName, donorNode.getHost(), donorNode.getSocketPort(), RequestFormatType.PROTOCOL_BUFFERS, RequestRoutingType.IGNORE_CHECKS));
                }
            }
        }
        return this.storeRepository.getRedirectingSocketStore(storeName, donorNodeId);
    }

    private Node getNodeIfPresent(int donorId) {
        try {
            return this.metadata.getCluster().getNodeById(donorId);
        }
        catch (Exception e) {
            throw new VoldemortException("Failed to get donorNode " + donorId + " from current cluster " + this.metadata.getCluster() + " at node " + this.metadata.getNodeId(), e);
        }
    }

    private void recordException(Node node, long startNs, UnreachableStoreException e) {
        this.failureDetector.recordException(node, (System.nanoTime() - startNs) / 1000000L, e);
    }

    private void recordSuccess(Node node, long startNs) {
        this.failureDetector.recordSuccess(node, (System.nanoTime() - startNs) / 1000000L);
    }
}

