/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.serialized;

import voldemort.serialization.Serializer;
import voldemort.store.StorageEngine;
import voldemort.store.serialized.SerializingStore;
import voldemort.utils.ByteArray;
import voldemort.utils.ClosableIterator;
import voldemort.utils.Pair;
import voldemort.utils.Utils;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializingStorageEngine<K, V, T>
extends SerializingStore<K, V, T>
implements StorageEngine<K, V, T> {
    private final StorageEngine<ByteArray, byte[], byte[]> storageEngine;

    public SerializingStorageEngine(StorageEngine<ByteArray, byte[], byte[]> innerStorageEngine, Serializer<K> keySerializer, Serializer<V> valueSerializer, Serializer<T> transformsSerializer) {
        super(innerStorageEngine, keySerializer, valueSerializer, transformsSerializer);
        this.storageEngine = Utils.notNull(innerStorageEngine);
    }

    public static <K1, V1, T1> SerializingStorageEngine<K1, V1, T1> wrap(StorageEngine<ByteArray, byte[], byte[]> s, Serializer<K1> k, Serializer<V1> v, Serializer<T1> t) {
        return new SerializingStorageEngine<K1, V1, T1>(s, k, v, t);
    }

    @Override
    public ClosableIterator<Pair<K, Versioned<V>>> entries() {
        return new EntriesIterator(this.storageEngine.entries());
    }

    @Override
    public ClosableIterator<K> keys() {
        return new KeysIterator(this.storageEngine.keys());
    }

    @Override
    public void truncate() {
        this.storageEngine.truncate();
    }

    @Override
    public boolean isPartitionAware() {
        return this.storageEngine.isPartitionAware();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntriesIterator
    implements ClosableIterator<Pair<K, Versioned<V>>> {
        private final ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> iterator;

        public EntriesIterator(ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Pair<K, Versioned<V>> next() {
            Pair keyAndVal = (Pair)this.iterator.next();
            if (keyAndVal == null) {
                return null;
            }
            Versioned versioned = (Versioned)keyAndVal.getSecond();
            return Pair.create(SerializingStorageEngine.this.getKeySerializer().toObject(((ByteArray)keyAndVal.getFirst()).get()), new Versioned(SerializingStorageEngine.this.getValueSerializer().toObject((byte[])versioned.getValue()), versioned.getVersion()));
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public void close() {
            this.iterator.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeysIterator
    implements ClosableIterator<K> {
        private final ClosableIterator<ByteArray> iterator;

        public KeysIterator(ClosableIterator<ByteArray> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K next() {
            ByteArray key = (ByteArray)this.iterator.next();
            if (key == null) {
                return null;
            }
            return SerializingStorageEngine.this.getKeySerializer().toObject(key.get());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public void close() {
            this.iterator.close();
        }
    }
}

